/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.processor;

import au.org.ala.biocache.model.FullRecord;
import au.org.ala.biocache.model.QualityAssertion;
import au.org.ala.biocache.model.QualityAssertion$;
import au.org.ala.biocache.processor.Processor;
import au.org.ala.biocache.processor.Processor$class;
import au.org.ala.biocache.vocab.AssertionCodes$;
import au.org.ala.biocache.vocab.AssertionStatus$;
import au.org.ala.biocache.vocab.Term;
import au.org.ala.biocache.vocab.TypeStatus$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u000154A!\u0001\u0002\u0001\u001b\t\u0019B+\u001f9f'R\fG/^:Qe>\u001cWm]:pe*\u00111\u0001B\u0001\naJ|7-Z:t_JT!!\u0002\u0004\u0002\u0011\tLwnY1dQ\u0016T!a\u0002\u0005\u0002\u0007\u0005d\u0017M\u0003\u0002\n\u0015\u0005\u0019qN]4\u000b\u0003-\t!!Y;\u0004\u0001M\u0019\u0001A\u0004\u000b\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g!\t)b#D\u0001\u0003\u0013\t9\"AA\u0005Qe>\u001cWm]:pe\")\u0011\u0004\u0001C\u00015\u00051A(\u001b8jiz\"\u0012a\u0007\t\u0003+\u0001Aq!\b\u0001C\u0002\u0013\u0005a$\u0001\u0004m_\u001e<WM]\u000b\u0002?A\u0011\u0001\u0005J\u0007\u0002C)\u0011!eI\u0001\u0006g24GG\u001b\u0006\u0002\u0013%\u0011Q%\t\u0002\u0007\u0019><w-\u001a:\t\r\u001d\u0002\u0001\u0015!\u0003 \u0003\u001dawnZ4fe\u0002Bq!\u000b\u0001C\u0002\u0013\u0005!&\u0001\u0007X\u001fJ#u\fU!U)\u0016\u0013f*F\u0001,!\ta\u0013'D\u0001.\u0015\tqs&\u0001\u0005nCR\u001c\u0007.\u001b8h\u0015\t\u0001\u0004#\u0001\u0003vi&d\u0017B\u0001\u001a.\u0005\u0015\u0011VmZ3y\u0011\u0019!\u0004\u0001)A\u0005W\u0005iqk\u0014*E?B\u000bE\u000bV#S\u001d\u0002BQA\u000e\u0001\u0005\u0002]\nq\u0001\u001d:pG\u0016\u001c8\u000fF\u00039\u0003*{\u0015\u000bE\u0002\u0010smJ!A\u000f\t\u0003\u000b\u0005\u0013(/Y=\u0011\u0005qzT\"A\u001f\u000b\u0005y\"\u0011!B7pI\u0016d\u0017B\u0001!>\u0005A\tV/\u00197jif\f5o]3si&|g\u000eC\u0003Ck\u0001\u00071)\u0001\u0003hk&$\u0007C\u0001#H\u001d\tyQ)\u0003\u0002G!\u00051\u0001K]3eK\u001aL!\u0001S%\u0003\rM#(/\u001b8h\u0015\t1\u0005\u0003C\u0003Lk\u0001\u0007A*A\u0002sC^\u0004\"\u0001P'\n\u00059k$A\u0003$vY2\u0014VmY8sI\")\u0001+\u000ea\u0001\u0019\u0006I\u0001O]8dKN\u001cX\r\u001a\u0005\b%V\u0002\n\u00111\u0001T\u00035a\u0017m\u001d;Qe>\u001cWm]:fIB\u0019q\u0002\u0016'\n\u0005U\u0003\"AB(qi&|g\u000eC\u0003X\u0001\u0011\u0005\u0001,A\u0004hKRt\u0015-\\3\u0016\u0003e\u0003\"AW0\u000e\u0003mS!\u0001X/\u0002\t1\fgn\u001a\u0006\u0002=\u0006!!.\u0019<b\u0013\tA5\fC\u0004b\u0001E\u0005I\u0011\t2\u0002#A\u0014xnY3tg\u0012\"WMZ1vYR$C'F\u0001dU\t\u0019FmK\u0001f!\t17.D\u0001h\u0015\tA\u0017.A\u0005v]\u000eDWmY6fI*\u0011!\u000eE\u0001\u000bC:tw\u000e^1uS>t\u0017B\u00017h\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class TypeStatusProcessor
implements Processor {
    private final Logger logger;
    private final Regex WORD_PATTERN;

    public Logger logger() {
        return this.logger;
    }

    public Regex WORD_PATTERN() {
        return this.WORD_PATTERN;
    }

    @Override
    public QualityAssertion[] process(String guid, FullRecord raw, FullRecord processed, Option<FullRecord> lastProcessed) {
        QualityAssertion[] qualityAssertionArray;
        if (raw.identification().typeStatus() == null || raw.identification().typeStatus().isEmpty()) {
            qualityAssertionArray = (QualityAssertion[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(QualityAssertion.class));
        } else {
            List typeStatuses = (List)this.WORD_PATTERN().findAllIn((CharSequence)raw.identification().typeStatus()).toList().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Option<Term> apply(String word) {
                    return TypeStatus$.MODULE$.matchTerm(word);
                }
            }, List$.MODULE$.canBuildFrom());
            List list = (List)((SeqLike)((TraversableLike)typeStatuses.filter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Option<Term> x$1) {
                    return x$1.nonEmpty();
                }
            })).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(Option<Term> ts) {
                    return ((Term)ts.get()).canonical();
                }
            }, List$.MODULE$.canBuildFrom())).distinct();
            if (list.isEmpty()) {
                qualityAssertionArray = (QualityAssertion[])((Object[])new QualityAssertion[]{QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.UNRECOGNISED_TYPESTATUS(), "Unrecognised type status")});
            } else {
                processed.identification().typeStatus_$eq(list.mkString("|"));
                qualityAssertionArray = (QualityAssertion[])((Object[])new QualityAssertion[]{QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.UNRECOGNISED_TYPESTATUS(), AssertionStatus$.MODULE$.PASSED())});
            }
        }
        return qualityAssertionArray;
    }

    @Override
    public Option<FullRecord> process$default$4() {
        return None$.MODULE$;
    }

    @Override
    public String getName() {
        return "type";
    }

    public TypeStatusProcessor() {
        Processor$class.$init$(this);
        this.logger = LoggerFactory.getLogger((String)"TypeStatusProcessor");
        this.WORD_PATTERN = new StringOps(Predef$.MODULE$.augmentString("[\\p{L}]{4,}")).r();
    }
}

