/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.processor;

import au.org.ala.biocache.Config$;
import au.org.ala.biocache.model.FullRecord;
import au.org.ala.biocache.model.QualityAssertion;
import au.org.ala.biocache.processor.Processor;
import au.org.ala.biocache.processor.Processor$class;
import java.io.File;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.LinearSeqOptimized;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.io.BufferedSource;
import scala.io.Source;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005c\u0001B\u0001\u0003\u00015\u0011\u0001%\u00133f]RLg-[2bi&|g.U;bY&4\u0017.\u001a:Qe>\u001cWm]:pe*\u00111\u0001B\u0001\naJ|7-Z:t_JT!!\u0002\u0004\u0002\u0011\tLwnY1dQ\u0016T!a\u0002\u0005\u0002\u0007\u0005d\u0017M\u0003\u0002\n\u0015\u0005\u0019qN]4\u000b\u0003-\t!!Y;\u0004\u0001M\u0019\u0001A\u0004\u000b\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g!\t)b#D\u0001\u0003\u0013\t9\"AA\u0005Qe>\u001cWm]:pe\")\u0011\u0004\u0001C\u00015\u00051A(\u001b8jiz\"\u0012a\u0007\t\u0003+\u0001Aq!\b\u0001C\u0002\u0013\u0005a$\u0001\u0004m_\u001e<WM]\u000b\u0002?A\u0011\u0001\u0005J\u0007\u0002C)\u0011!eI\u0001\u0006g24GG\u001b\u0006\u0002\u0013%\u0011Q%\t\u0002\u0007\u0019><w-\u001a:\t\r\u001d\u0002\u0001\u0015!\u0003 \u0003\u001dawnZ4fe\u0002Bq!\u000b\u0001C\u0002\u0013\u0005!&A\u0004DKJ$\u0018-\u001b8\u0016\u0003-\u0002\"\u0001L\u0019\u000e\u00035R!AL\u0018\u0002\t1\fgn\u001a\u0006\u0002a\u0005!!.\u0019<b\u0013\t\u0011TF\u0001\u0004TiJLgn\u001a\u0005\u0007i\u0001\u0001\u000b\u0011B\u0016\u0002\u0011\r+'\u000f^1j]\u0002BqA\u000e\u0001C\u0002\u0013\u0005!&A\u0005V]\u000e,'\u000f^1j]\"1\u0001\b\u0001Q\u0001\n-\n!\"\u00168dKJ$\u0018-\u001b8!\u0011\u001dQ\u0004A1A\u0005\u0002)\nQBT8u%\u0016\u001cwn\u001a8jg\u0016$\u0007B\u0002\u001f\u0001A\u0003%1&\u0001\bO_R\u0014VmY8h]&\u001cX\r\u001a\u0011\t\u000fy\u0002!\u0019!C\u0001U\u0005Yaj\u001c;Qe>4\u0018\u000eZ3e\u0011\u0019\u0001\u0005\u0001)A\u0005W\u0005aaj\u001c;Qe>4\u0018\u000eZ3eA!9!\tAA!\u0002\u0013\u0019\u0015a\u0001=%cA!q\u0002\u0012$G\u0013\t)\u0005C\u0001\u0004UkBdWM\r\t\u0003\u000f*s!a\u0004%\n\u0005%\u0003\u0012A\u0002)sK\u0012,g-\u0003\u00023\u0017*\u0011\u0011\n\u0005\u0005\b\u001b\u0002\u0011\r\u0011\"\u0001O\u0003I\u0019WM\u001d;bS:\\U-_<pe\u0012d\u0015n\u001d;\u0016\u0003\u0019Ca\u0001\u0015\u0001!\u0002\u00131\u0015aE2feR\f\u0017N\\&fs^|'\u000f\u001a'jgR\u0004\u0003b\u0002*\u0001\u0005\u0004%\tAT\u0001\u0015k:\u001cUM\u001d;bS:\\U-_<pe\u0012d\u0015n\u001d;\t\rQ\u0003\u0001\u0015!\u0003G\u0003U)hnQ3si\u0006LgnS3zo>\u0014H\rT5ti\u0002BQA\u0016\u0001\u0005\u0002]\u000bq\u0001\u001d:pG\u0016\u001c8\u000fF\u0003YC\u000eD'\u000eE\u0002\u00103nK!A\u0017\t\u0003\u000b\u0005\u0013(/Y=\u0011\u0005q{V\"A/\u000b\u0005y#\u0011!B7pI\u0016d\u0017B\u00011^\u0005A\tV/\u00197jif\f5o]3si&|g\u000eC\u0003c+\u0002\u0007a)\u0001\u0003hk&$\u0007\"\u00023V\u0001\u0004)\u0017a\u0001:boB\u0011ALZ\u0005\u0003Ov\u0013!BR;mYJ+7m\u001c:e\u0011\u0015IW\u000b1\u0001f\u0003%\u0001(o\\2fgN,G\rC\u0004l+B\u0005\t\u0019\u00017\u0002\u001b1\f7\u000f\u001e)s_\u000e,7o]3e!\ryQ.Z\u0005\u0003]B\u0011aa\u00149uS>t\u0007\"\u00029\u0001\t\u0003\t\u0018A\b9s_\u000e,7o]%eK:$\u0018NZ5dCRLwN\\)vC2Lg-[3s)\t\u00118\u0010\u0005\u0003\u0010\t\u001a\u001b\bc\u0001;z76\tQO\u0003\u0002wo\u00069Q.\u001e;bE2,'B\u0001=\u0011\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003uV\u00141\"\u0011:sCf\u0014UO\u001a4fe\")Ap\u001ca\u0001\r\u0006Q\"/Y<JI\u0016tG/\u001b4jG\u0006$\u0018n\u001c8Rk\u0006d\u0017NZ5fe\")a\u0010\u0001C\u0001\u007f\u0006a!/Z1e\rJ|WNR5mKR\u00191)!\u0001\t\r\u0005\rQ\u00101\u0001G\u0003!1\u0017\u000e\\3QCRD\u0007bBA\u0004\u0001\u0011\u0005\u0011\u0011B\u0001\u0006e\u0016<W\r\u001f\u000b\u0004\r\u0006-\u0001bBA\u0007\u0003\u000b\u0001\rAR\u0001\bW\u0016Lxo\u001c:e\u0011\u001d\t\t\u0002\u0001C\u0001\u0003'\t\u0011bZ3u'>,(oY3\u0015\t\u0005U\u0011\u0011\u0005\t\u0005\u0003/\ti\"\u0004\u0002\u0002\u001a)\u0019\u00111\u0004\t\u0002\u0005%|\u0017\u0002BA\u0010\u00033\u0011aaU8ve\u000e,\u0007bBA\u0002\u0003\u001f\u0001\rA\u0012\u0005\u0007\u0003K\u0001A\u0011\u0001\u0016\u0002\u000f\u001d,GOT1nK\"I\u0011\u0011\u0006\u0001\u0012\u0002\u0013\u0005\u00131F\u0001\u0012aJ|7-Z:tI\u0011,g-Y;mi\u0012\"TCAA\u0017U\ra\u0017qF\u0016\u0003\u0003c\u0001B!a\r\u0002>5\u0011\u0011Q\u0007\u0006\u0005\u0003o\tI$A\u0005v]\u000eDWmY6fI*\u0019\u00111\b\t\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002@\u0005U\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class IdentificationQualifierProcessor
implements Processor {
    private final Logger logger;
    private final String Certain;
    private final String Uncertain;
    private final String NotRecognised;
    private final String NotProvided;
    private final Tuple2<String, String> x$1;
    private final String certainKeywordList;
    private final String unCertainKeywordList;

    public Logger logger() {
        return this.logger;
    }

    public String Certain() {
        return this.Certain;
    }

    public String Uncertain() {
        return this.Uncertain;
    }

    public String NotRecognised() {
        return this.NotRecognised;
    }

    public String NotProvided() {
        return this.NotProvided;
    }

    public String certainKeywordList() {
        return this.certainKeywordList;
    }

    public String unCertainKeywordList() {
        return this.unCertainKeywordList;
    }

    @Override
    public QualityAssertion[] process(String guid, FullRecord raw, FullRecord processed, Option<FullRecord> lastProcessed) {
        Tuple2<String, ArrayBuffer<QualityAssertion>> tuple2 = this.processIdentificationQualifier(raw.identification().identificationQualifier());
        if (tuple2 != null) {
            Tuple2 tuple22;
            String translatedIdQualifier = (String)tuple2._1();
            ArrayBuffer assertions = (ArrayBuffer)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)translatedIdQualifier, (Object)assertions);
            String translatedIdQualifier2 = (String)tuple23._1();
            ArrayBuffer assertions2 = (ArrayBuffer)tuple23._2();
            processed.identification().identificationQualifier_$eq(translatedIdQualifier2);
            Tuple2<String, ArrayBuffer<QualityAssertion>> tuple24 = this.processIdentificationQualifier(raw.identification().abcdIdentificationQualifier());
            if (tuple24 != null) {
                Tuple2 tuple25;
                String translatedAbcdIdQualifier = (String)tuple24._1();
                ArrayBuffer abcdAssertions = (ArrayBuffer)tuple24._2();
                Tuple2 tuple26 = tuple25 = new Tuple2((Object)translatedAbcdIdQualifier, (Object)abcdAssertions);
                String translatedAbcdIdQualifier2 = (String)tuple26._1();
                ArrayBuffer abcdAssertions2 = (ArrayBuffer)tuple26._2();
                processed.identification().abcdIdentificationQualifier_$eq(translatedAbcdIdQualifier2);
                return (QualityAssertion[])assertions2.$plus$plus((GenTraversableOnce)abcdAssertions2).toArray(ClassTag$.MODULE$.apply(QualityAssertion.class));
            }
            throw new MatchError(tuple24);
        }
        throw new MatchError(tuple2);
    }

    @Override
    public Option<FullRecord> process$default$4() {
        return None$.MODULE$;
    }

    public Tuple2<String, ArrayBuffer<QualityAssertion>> processIdentificationQualifier(String rawIdentificationQualifier) {
        ArrayBuffer assertions = new ArrayBuffer();
        Regex CertainKeywordRegex = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder().append((Object)"((?:.*?)?(?:").append((Object)this.certainKeywordList()).append((Object)")(?:.*)?)").toString())).r();
        Regex UncertainKeywordRegex = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder().append((Object)"((?:.*?)?(?:").append((Object)this.unCertainKeywordList()).append((Object)")(?:.*)?)").toString())).r();
        String stringVal = rawIdentificationQualifier;
        String translatedIdQualifier = this.NotProvided();
        this.logger().debug(new StringBuilder().append((Object)"Processing raw.identification.identificationQualifier: ").append((Object)stringVal).toString());
        if (StringUtils.isNotBlank((String)stringVal)) {
            String string = stringVal.trim().replaceAll("\\s+", " ").toLowerCase();
            Option option = UncertainKeywordRegex.unapplySeq((Object)string);
            if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
                this.logger().debug(new StringBuilder().append((Object)"Identification Qualifier '").append((Object)stringVal).append((Object)"' is mapped to ").append((Object)this.Uncertain()).toString());
                translatedIdQualifier = this.Uncertain();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                Option option2 = CertainKeywordRegex.unapplySeq((Object)string);
                if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(1) == 0) {
                    this.logger().debug(new StringBuilder().append((Object)"Identification Qualifier '").append((Object)stringVal).append((Object)"' is mapped to ").append((Object)this.Certain()).toString());
                    translatedIdQualifier = this.Certain();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.logger().debug(new StringBuilder().append((Object)"Identification Qualifier '").append((Object)stringVal).append((Object)"' is mapped to ").append((Object)this.NotRecognised()).toString());
                    translatedIdQualifier = this.NotRecognised();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
        } else {
            this.logger().debug("No Identification Qualifier provided");
        }
        return new Tuple2((Object)translatedIdQualifier, (Object)assertions);
    }

    public Tuple2<String, String> readFromFile(String filePath) {
        ObjectRef certainList = new ObjectRef((Object)"");
        ObjectRef uncertainList = new ObjectRef((Object)"");
        String CertainHeader = new StringBuilder().append((Object)"[").append((Object)this.Certain().toLowerCase()).append((Object)"]").toString();
        String UncertainHeader = new StringBuilder().append((Object)"[").append((Object)this.Uncertain().toLowerCase()).append((Object)"]").toString();
        ObjectRef objectRef = new ObjectRef((Object)"");
        this.getSource(filePath).getLines().foreach((Function1)new Serializable(this, certainList, uncertainList, CertainHeader, UncertainHeader, objectRef){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IdentificationQualifierProcessor $outer;
            private final ObjectRef certainList$1;
            private final ObjectRef uncertainList$1;
            private final String CertainHeader$1;
            private final String UncertainHeader$1;
            private final ObjectRef switch$1;

            public final void apply(String line) {
                this.$outer.logger().debug(line);
                if (StringUtils.isNotBlank((String)line)) {
                    String string = line.trim().toLowerCase();
                    String string2 = this.CertainHeader$1;
                    String string3 = string;
                    if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                        this.switch$1.elem = this.CertainHeader$1;
                        this.$outer.logger().debug(new StringBuilder().append((Object)"Encoutered ").append((Object)this.CertainHeader$1).toString());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        String string4 = this.UncertainHeader$1;
                        String string5 = string;
                        if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                            this.switch$1.elem = this.UncertainHeader$1;
                            this.$outer.logger().debug(new StringBuilder().append((Object)"Encoutered ").append((Object)this.UncertainHeader$1).toString());
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            BoxedUnit boxedUnit;
                            String string6 = (String)this.switch$1.elem;
                            String string7 = this.CertainHeader$1;
                            if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                                String string8 = (String)this.certainList$1.elem;
                                String string9 = "";
                                this.certainList$1.elem = !(string8 != null ? !string8.equals(string9) : string9 != null) ? ((String)this.certainList$1.elem).concat(this.$outer.regex(line)) : ((String)this.certainList$1.elem).concat(new StringBuilder().append((Object)"|").append((Object)this.$outer.regex(line)).toString());
                                this.$outer.logger().debug("Adding to certain List ");
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                String string10 = (String)this.switch$1.elem;
                                String string11 = this.UncertainHeader$1;
                                if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                                    String string12 = (String)this.uncertainList$1.elem;
                                    String string13 = "";
                                    this.uncertainList$1.elem = !(string12 != null ? !string12.equals(string13) : string13 != null) ? ((String)this.uncertainList$1.elem).concat(this.$outer.regex(line)) : ((String)this.uncertainList$1.elem).concat(new StringBuilder().append((Object)"|").append((Object)this.$outer.regex(line)).toString());
                                    this.$outer.logger().debug("Adding to Uncertain List ");
                                    boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit = BoxedUnit.UNIT;
                                }
                            }
                            BoxedUnit boxedUnit2 = boxedUnit;
                        }
                    }
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.certainList$1 = certainList$1;
                this.uncertainList$1 = uncertainList$1;
                this.CertainHeader$1 = CertainHeader$1;
                this.UncertainHeader$1 = UncertainHeader$1;
                this.switch$1 = switch$1;
            }
        });
        this.logger().debug(new StringBuilder().append((Object)"Printing certain List from IdentifcationQualifier.txt : ").append((Object)((String)certainList.elem)).toString());
        this.logger().debug(new StringBuilder().append((Object)"Printing uncertain List from IdentifcationQualifier.txt : ").append((Object)((String)uncertainList.elem)).toString());
        return new Tuple2((Object)((String)certainList.elem), (Object)((String)uncertainList.elem));
    }

    public String regex(String keyword) {
        String string = keyword;
        String string2 = "?";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return "\\?";
        }
        if (keyword.contains(".")) {
            return new StringBuilder().append((Object)"\\b").append((Object)keyword.replace(".", "\\b[.]").replace("(ed)", "(?:ed)?").replaceAll("\\s+", " ")).toString();
        }
        return new StringBuilder().append((Object)"\\b").append((Object)keyword.replace(".", "[.]").replace("(ed)", "(?:ed)?").replaceAll("\\s+", " ")).append((Object)"\\b").toString();
    }

    public Source getSource(String filePath) {
        BufferedSource bufferedSource;
        File overrideFile = new File(new StringBuilder().append((Object)Config$.MODULE$.vocabDirectory()).append((Object)filePath).toString());
        if (overrideFile.exists()) {
            this.logger().debug(new StringBuilder().append((Object)"Reading identificationQualifier file: ").append((Object)overrideFile.getAbsolutePath()).toString());
            bufferedSource = Source$.MODULE$.fromFile(overrideFile, "utf-8");
        } else {
            this.logger().debug(new StringBuilder().append((Object)"Reading internal identificationQualifier file: ").append((Object)filePath).toString());
            bufferedSource = Source$.MODULE$.fromURL(this.getClass().getResource(filePath), "utf-8");
        }
        return bufferedSource;
    }

    @Override
    public String getName() {
        return "IdentificationQualifierProcessor";
    }

    public IdentificationQualifierProcessor() {
        Processor$class.$init$(this);
        this.logger = LoggerFactory.getLogger((String)this.getName());
        this.Certain = "Certain";
        this.Uncertain = "Uncertain";
        this.NotRecognised = "Not recognised";
        this.NotProvided = "Not provided";
        Tuple2<String, String> tuple2 = this.readFromFile("/identificationQualifiers.txt");
        if (tuple2 != null) {
            Tuple2 tuple22;
            String certainKeywordList = (String)tuple2._1();
            String unCertainKeywordList = (String)tuple2._2();
            this.x$1 = tuple22 = new Tuple2((Object)certainKeywordList, (Object)unCertainKeywordList);
            this.certainKeywordList = (String)this.x$1._1();
            this.unCertainKeywordList = (String)this.x$1._2();
            return;
        }
        throw new MatchError(tuple2);
    }
}

