/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.load;

import au.org.ala.biocache.Config$;
import au.org.ala.biocache.load.DataLoader;
import au.org.ala.biocache.load.DataResourceConfig;
import au.org.ala.biocache.load.DownloadMedia$;
import au.org.ala.biocache.model.FullRecord;
import au.org.ala.biocache.model.Multimedia;
import au.org.ala.biocache.parser.DateParser$;
import au.org.ala.biocache.util.BiocacheConversions$;
import au.org.ala.biocache.util.FileHelper$;
import au.org.ala.biocache.util.HttpUtil$;
import au.org.ala.biocache.util.SFTPTools$;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.gbif.dwc.terms.Term;
import org.gbif.dwc.terms.TermFactory;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.Tuple5;
import scala.collection.GenTraversableOnce;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.StringBuilder;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.parsing.json.JSON$;

public abstract class DataLoader$class {
    public static boolean emptyTempFileStore(DataLoader $this, String resourceUid) {
        return FileUtils.deleteQuietly((File)new File(new StringBuilder().append((Object)$this.temporaryFileStore()).append((Object)File.separator).append((Object)resourceUid).toString()));
    }

    public static FileWriter getDeletedFileWriter(DataLoader $this, String resourceUid) {
        File file = new File(new StringBuilder().append((Object)Config$.MODULE$.deletedFileStore()).append((Object)File.separator).append((Object)resourceUid).append((Object)File.separator).append((Object)"deleted.txt").toString());
        FileUtils.forceMkdir((File)file.getParentFile());
        return new FileWriter(file);
    }

    public static void deleteOldRowKeys(DataLoader $this, String resourceUid) {
        FileUtils.deleteQuietly((File)new File(new StringBuilder().append((Object)Config$.MODULE$.tmpWorkDir()).append((Object)"/row_key_").append((Object)resourceUid).append((Object)".csv").toString()));
    }

    public static Option getRowKeyWriter(DataLoader $this, String resourceUid, boolean writeRowKeys) {
        None$ none$;
        if (writeRowKeys) {
            FileUtils.forceMkdir((File)new File(Config$.MODULE$.tmpWorkDir()));
            none$ = new Some((Object)new FileWriter(new StringBuilder().append((Object)Config$.MODULE$.tmpWorkDir()).append((Object)"/row_key_").append((Object)resourceUid).append((Object)".csv").toString(), true));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public static void setNotLoadedForOtherPhases(DataLoader $this, String resourceUid) {
        if (DataLoader$class.writer$1($this, resourceUid).isDefined()) {
            ((Writer)DataLoader$class.writer$1($this, resourceUid).get()).flush();
            ((Writer)DataLoader$class.writer$1($this, resourceUid).get()).close();
        }
    }

    public static Map getDataResourceDetailsAsMap(DataLoader $this, String uid) {
        String json = Source$.MODULE$.fromURL(new StringBuilder().append((Object)Config$.MODULE$.registryUrl()).append((Object)"/dataResource/").append((Object)uid).toString(), "UTF-8").getLines().mkString();
        return (Map)JSON$.MODULE$.parseFull(json).get();
    }

    public static Map getDataProviderDetailsAsMap(DataLoader $this, String uid) {
        String json = Source$.MODULE$.fromURL(new StringBuilder().append((Object)Config$.MODULE$.registryUrl()).append((Object)"/dataProvider/").append((Object)uid).toString(), "UTF-8").getLines().mkString();
        return (Map)JSON$.MODULE$.parseFull(json).get();
    }

    public static Map getInstitutionDetailsAsMap(DataLoader $this, String uid) {
        String json = Source$.MODULE$.fromURL(new StringBuilder().append((Object)Config$.MODULE$.registryUrl()).append((Object)"/institution/").append((Object)uid).toString(), "UTF-8").getLines().mkString();
        return (Map)JSON$.MODULE$.parseFull(json).get();
    }

    /*
     * Unable to fully structure code
     */
    public static Option retrieveConnectionParameters(DataLoader $this, String resourceUid) {
        try {
            map = $this.getDataResourceDetailsAsMap(resourceUid);
            connectionParameters = (Map)map.getOrElse((Object)"connectionParameters", (Function0)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final Map<String, Object> apply() {
                    return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
                }
            });
            protocol = (String)connectionParameters.getOrElse((Object)"protocol", (Function0)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "";
                }
            });
            urlsObject = connectionParameters.getOrElse((Object)"url", (Function0)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final List<String> apply() {
                    return Nil$.MODULE$;
                }
            });
            if (urlsObject instanceof List) {
                v0 = urlsObject;
            } else {
                singleValue = (String)connectionParameters.apply((Object)"url");
                v0 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{singleValue}));
            }
            urls = v0;
            var10_8 = false;
            var11_9 = null;
            var12_10 = connectionParameters.get((Object)"termsForUniqueKey");
            if (!(var12_10 instanceof Some)) ** GOTO lbl-1000
            var10_8 = true;
            var11_9 = (Some)var12_10;
            list = var11_9.x();
            if (list instanceof List) {
                var14_12 = (List)list;
                var15_13 = var14_12;
            } else if (var10_8 && (singleValue = var11_9.x()) instanceof String) {
                var17_15 = (String)singleValue;
                var15_13 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{var17_15}));
            } else {
                v1 = None$.MODULE$;
                var18_16 = var12_10;
                if (v1 != null ? v1.equals(var18_16) == false : var18_16 != null) {
                    throw new MatchError((Object)var12_10);
                }
                var15_13 = Nil$.MODULE$;
            }
            uniqueTerms = var15_13;
            var21_19 = var20_18 = protocol.toLowerCase();
            if (!("customwebservice" != null ? "customwebservice".equals(var21_19) == false : var21_19 != null)) {
                params = (String)connectionParameters.getOrElse((Object)"params", (Function0)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "";
                    }
                });
                var22_21 = (Map)JSON$.MODULE$.parseFull(params).getOrElse((Function0)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final Map<String, String> apply() {
                        return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
                    }
                });
            } else {
                var22_21 = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
            }
            customParams = var22_21;
            lastChecked = (String)map.apply((Object)"lastChecked");
            dateLastChecked = DateParser$.MODULE$.parseStringToDate(lastChecked);
            v2 = new Some((Object)new DataResourceConfig(protocol, (Seq<String>)((List)urls), (Seq<String>)uniqueTerms, (Map<String, String>)connectionParameters, (Map<String, String>)customParams, dateLastChecked));
        }
        catch (Exception var2_25) {
            $this.logger().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Problem retrieve data resource config for resource: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resourceUid})), (Throwable)var2_25);
            v2 = None$.MODULE$;
        }
        return v2;
    }

    public static Seq mapConceptTerms(DataLoader $this, Seq terms) {
        TermFactory termFactory = TermFactory.instance();
        return (Seq)terms.map((Function1)new Serializable($this, termFactory){
            public static final long serialVersionUID = 0L;
            private final TermFactory termFactory$1;

            public final Term apply(String term) {
                return this.termFactory$1.findTerm(term);
            }
            {
                this.termFactory$1 = termFactory$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public static boolean exists(DataLoader $this, String dataResourceUid, List identifyingTerms) {
        return !Config$.MODULE$.occurrenceDAO().getUUIDForUniqueID($this.createUniqueID(dataResourceUid, (Seq<String>)identifyingTerms, $this.createUniqueID$default$3())).isEmpty();
    }

    public static String createUniqueID(DataLoader $this, String dataResourceUid, Seq identifyingTerms, boolean stripSpaces) {
        List list = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{dataResourceUid}));
        String uniqueId = identifyingTerms.toList().$colon$colon$colon(list).mkString("|").trim();
        return stripSpaces ? uniqueId.replaceAll("\\s", "") : uniqueId;
    }

    public static boolean createUniqueID$default$3(DataLoader $this) {
        return false;
    }

    public static boolean load(DataLoader $this, String dataResourceUid, FullRecord fr, Seq identifyingTerms, Seq multimedia) {
        return $this.load(dataResourceUid, fr, (Seq<String>)identifyingTerms, true, false, false, (Option<Writer>)None$.MODULE$, (Seq<Multimedia>)multimedia, false);
    }

    public static boolean load(DataLoader $this, String dataResourceUid, FullRecord fr, Seq identifyingTerms) {
        return $this.load(dataResourceUid, fr, (Seq<String>)identifyingTerms, true, false, false, (Option<Writer>)None$.MODULE$, (Seq<Multimedia>)Nil$.MODULE$, false);
    }

    public static boolean load(DataLoader $this, String dataResourceUid, FullRecord fr, Seq identifyingTerms, boolean updateLastModified) {
        return $this.load(dataResourceUid, fr, (Seq<String>)identifyingTerms, updateLastModified, false, false, (Option<Writer>)None$.MODULE$, (Seq<Multimedia>)Nil$.MODULE$, false);
    }

    public static boolean load(DataLoader $this, String dataResourceUid, FullRecord fr, Seq identifyingTerms, boolean updateLastModified, boolean downloadMedia2, boolean deleteIfNullValue) {
        return $this.load(dataResourceUid, fr, (Seq<String>)identifyingTerms, updateLastModified, downloadMedia2, false, (Option<Writer>)None$.MODULE$, (Seq<Multimedia>)Nil$.MODULE$, deleteIfNullValue);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static boolean load(DataLoader $this, String dataResourceUid, FullRecord fr, Seq identifyingTerms, boolean updateLastModified, boolean downloadMedia, boolean stripSpaces, Option rowKeyWriter, Seq multimedia, boolean deleteIfNullValue) {
        block7: {
            block6: {
                v0 /* !! */  = uniqueID = identifyingTerms.isEmpty() != false ? None$.MODULE$ : new Some((Object)$this.createUniqueID(dataResourceUid, (Seq<String>)identifyingTerms, stripSpaces));
                if (fr.uuid() == null) break block6;
                v1 = fr.uuid().trim();
                var13_11 = "";
                if (v1 != null ? v1.equals(var13_11) == false : var13_11 != null) ** GOTO lbl20
            }
            if (!((var14_12 = uniqueID) instanceof Some)) break block7;
            var15_13 = (Some)var14_12;
            value = (String)var15_13.x();
            var17_15 = Config$.MODULE$.occurrenceDAO().createOrRetrieveUuid(value);
            ** GOTO lbl17
        }
        v2 = None$.MODULE$;
        var18_16 = var14_12;
        if (!(v2 != null ? v2.equals(var18_16) == false : var18_16 != null)) {
            var17_15 = new Tuple2((Object)Config$.MODULE$.occurrenceDAO().createUuid(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
lbl17:
            // 2 sources

            v3 = var17_15;
        } else {
            throw new MatchError((Object)var14_12);
lbl20:
            // 1 sources

            v3 = var12_17 = new Tuple2((Object)fr.uuid(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        if (var12_17 != null) {
            recordUuid = (String)var12_17._1();
            isNew = var12_17._2$mcZ$sp();
            var11_21 = var21_20 = new Tuple2((Object)recordUuid, (Object)BoxesRunTime.boxToBoolean((boolean)isNew));
            recordUuid = (String)var11_21._1();
            isNew = var11_21._2$mcZ$sp();
            fr.uuid_$eq(recordUuid);
            fr.rowKey_$eq(uniqueID.isEmpty() != false ? new StringBuilder().append((Object)dataResourceUid).append((Object)"|").append((Object)recordUuid).toString() : (String)uniqueID.get());
            if (rowKeyWriter.isDefined()) {
                ((Writer)rowKeyWriter.get()).write(new StringBuilder().append((Object)fr.rowKey()).append((Object)"\n").toString());
            }
            if (updateLastModified) {
                fr.lastModifiedTime_$eq($this.loadTime());
            }
            if (isNew) {
                fr.firstLoaded_$eq($this.loadTime());
            }
            fr.attribution().dataResourceUid_$eq(dataResourceUid);
            $this.processMedia(dataResourceUid, fr, (Seq<Multimedia>)multimedia);
            Config$.MODULE$.occurrenceDAO().addRawOccurrence(fr, deleteIfNullValue);
            return true;
        }
        throw new MatchError((Object)var12_17);
    }

    public static FullRecord processMedia(DataLoader $this, String dataResourceUid, FullRecord fr, Seq multimedia) {
        Seq suppliedMedia = (Seq)multimedia.map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(Multimedia media) {
                return media.location().toString();
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq associatedMedia = (Seq)DownloadMedia$.MODULE$.unpackAssociatedMedia(fr.occurrence().associatedMedia()).filter((Function1)new Serializable($this, suppliedMedia){
            public static final long serialVersionUID = 0L;
            private final Seq suppliedMedia$1;

            public final boolean apply(String url) {
                return this.suppliedMedia$1.forall((Function1)new Serializable(this, url){
                    public static final long serialVersionUID = 0L;
                    private final String url$1;

                    public final boolean apply(String x$3) {
                        return !x$3.endsWith(this.url$1);
                    }
                    {
                        this.url$1 = url$1;
                    }
                });
            }
            {
                this.suppliedMedia$1 = suppliedMedia$1;
            }
        });
        Seq filesToImport = (Seq)((TraversableLike)associatedMedia.$plus$plus((GenTraversableOnce)suppliedMedia, Seq$.MODULE$.canBuildFrom())).filter((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String url) {
                return Config$.MODULE$.blacklistedMediaUrls().forall((Function1)new Serializable(this, url){
                    public static final long serialVersionUID = 0L;
                    private final String url$2;

                    public final boolean apply(String x$4) {
                        return !this.url$2.startsWith(x$4);
                    }
                    {
                        this.url$2 = url$2;
                    }
                });
            }
        });
        if (filesToImport.isEmpty()) {
            return fr;
        }
        HashMap fileNameToID = new HashMap();
        ArrayBuffer associatedMediaBuffer = new ArrayBuffer();
        ArrayBuffer imagesBuffer = new ArrayBuffer();
        ArrayBuffer soundsBuffer = new ArrayBuffer();
        ArrayBuffer videosBuffer = new ArrayBuffer();
        filesToImport.foreach((Function1)new Serializable($this, associatedMediaBuffer, imagesBuffer, soundsBuffer, videosBuffer, fr, multimedia){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DataLoader $outer;
            private final ArrayBuffer associatedMediaBuffer$1;
            private final ArrayBuffer imagesBuffer$1;
            private final ArrayBuffer soundsBuffer$1;
            private final ArrayBuffer videosBuffer$1;
            private final FullRecord fr$1;
            private final Seq multimedia$1;

            public final void apply(String fileToStore) {
                Option option;
                block4: {
                    Option<Tuple2<String, String>> option2;
                    block7: {
                        block6: {
                            BoxedUnit boxedUnit;
                            block5: {
                                Some some;
                                Tuple2 tuple2;
                                Option<Tuple2<String, String>> savedTo;
                                Some some2;
                                block3: {
                                    block2: {
                                        Option multiMediaObject = this.multimedia$1.find((Function1)new Serializable(this, fileToStore){
                                            public static final long serialVersionUID = 0L;
                                            private final String fileToStore$1;

                                            public final boolean apply(Multimedia media) {
                                                String string = media.location().toString();
                                                String string2 = this.fileToStore$1;
                                                return !(string != null ? !string.equals(string2) : string2 != null);
                                            }
                                            {
                                                this.fileToStore$1 = fileToStore$1;
                                            }
                                        });
                                        option = multiMediaObject;
                                        if (!(option instanceof Some)) break block2;
                                        Some some3 = (Some)option;
                                        Multimedia multimedia = (Multimedia)some3.x();
                                        some2 = new Some((Object)multimedia);
                                        break block3;
                                    }
                                    None$ none$ = None$.MODULE$;
                                    Option option3 = option;
                                    if (none$ != null ? !none$.equals(option3) : option3 != null) break block4;
                                    some2 = new Some((Object)new Multimedia(new URL(fileToStore), "", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"creator"), (Object)this.fr$1.occurrence().recordedBy()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"title"), (Object)this.fr$1.classification().scientificName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"description"), (Object)this.fr$1.occurrence().occurrenceRemarks()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"license"), (Object)this.fr$1.occurrence().license()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"rights"), (Object)this.fr$1.occurrence().rights()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"rightsHolder"), (Object)this.fr$1.occurrence().rightsholder())})))));
                                }
                                Some media = some2;
                                option2 = savedTo = Config$.MODULE$.mediaStore().save(this.fr$1.uuid(), this.fr$1.attribution().dataResourceUid(), fileToStore, (Option<Multimedia>)media);
                                if (!(option2 instanceof Some) || (tuple2 = (Tuple2)(some = (Some)option2).x()) == null) break block5;
                                String savedFilename = (String)tuple2._1();
                                String savedFilePathOrId = (String)tuple2._2();
                                ArrayBuffer arrayBuffer = Config$.MODULE$.mediaStore().isValidSound(fileToStore) ? this.soundsBuffer$1.$plus$eq((Object)savedFilePathOrId) : (Config$.MODULE$.mediaStore().isValidVideo(fileToStore) ? this.videosBuffer$1.$plus$eq((Object)savedFilePathOrId) : this.imagesBuffer$1.$plus$eq((Object)savedFilePathOrId));
                                boxedUnit = this.associatedMediaBuffer$1.$plus$eq((Object)savedFilename);
                                break block6;
                            }
                            None$ none$ = None$.MODULE$;
                            Option<Tuple2<String, String>> option4 = option2;
                            if (none$ != null ? !none$.equals(option4) : option4 != null) break block7;
                            this.$outer.logger().warn(new StringBuilder().append((Object)"Unable to save file: ").append((Object)fileToStore).toString());
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        this.fr$1.occurrence().associatedMedia_$eq(Predef$.MODULE$.refArrayOps((Object[])this.associatedMediaBuffer$1.toArray(ClassTag$.MODULE$.apply(String.class))).mkString(";"));
                        this.fr$1.occurrence().images_$eq((String[])this.imagesBuffer$1.toArray(ClassTag$.MODULE$.apply(String.class)));
                        this.fr$1.occurrence().sounds_$eq((String[])this.soundsBuffer$1.toArray(ClassTag$.MODULE$.apply(String.class)));
                        this.fr$1.occurrence().videos_$eq((String[])this.videosBuffer$1.toArray(ClassTag$.MODULE$.apply(String.class)));
                        return;
                    }
                    throw new MatchError(option2);
                }
                throw new MatchError((Object)option);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.associatedMediaBuffer$1 = associatedMediaBuffer$1;
                this.imagesBuffer$1 = imagesBuffer$1;
                this.soundsBuffer$1 = soundsBuffer$1;
                this.videosBuffer$1 = videosBuffer$1;
                this.fr$1 = fr$1;
                this.multimedia$1 = multimedia$1;
            }
        });
        return fr;
    }

    public static Seq processMedia$default$3(DataLoader $this) {
        return (Seq)Seq$.MODULE$.empty();
    }

    public static Tuple2 downloadArchive(DataLoader $this, String url, String resourceUid, Option lastChecked) {
        Tuple4<File, Date, Object, Object> tuple4;
        Tuple4<File, Date, Object, Object> tuple42 = tuple4 = url.startsWith("sftp://") ? $this.downloadSFTPArchive(url, resourceUid, (Option<Date>)lastChecked) : $this.downloadStandardArchive(url, resourceUid, (Option<Date>)lastChecked);
        if (tuple4 != null) {
            Tuple2 tuple2;
            Tuple4 tuple43;
            File file = (File)tuple4._1();
            Date date = (Date)tuple4._2();
            boolean isZipped = BoxesRunTime.unboxToBoolean((Object)tuple4._3());
            boolean isGzipped = BoxesRunTime.unboxToBoolean((Object)tuple4._4());
            Tuple4 tuple44 = tuple43 = new Tuple4((Object)file, (Object)date, (Object)BoxesRunTime.boxToBoolean((boolean)isZipped), (Object)BoxesRunTime.boxToBoolean((boolean)isGzipped));
            File file2 = (File)tuple44._1();
            Date date2 = (Date)tuple44._2();
            boolean isZipped2 = BoxesRunTime.unboxToBoolean((Object)tuple44._3());
            boolean isGzipped2 = BoxesRunTime.unboxToBoolean((Object)tuple44._4());
            if (file2 == null) {
                $this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to extract a new file for ", " at ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resourceUid, url})));
                tuple2 = new Tuple2(null, null);
            } else if (isZipped2) {
                $this.logger().info(new StringBuilder().append((Object)"Extracting ZIP ").append((Object)file2.getAbsolutePath()).toString());
                FileHelper$.MODULE$.file2helper(file2).extractZip();
                String fileName = FilenameUtils.removeExtension((String)file2.getAbsolutePath());
                $this.logger().info(new StringBuilder().append((Object)"Archive extracted to directory: ").append((Object)fileName).toString());
                tuple2 = new Tuple2((Object)fileName, (Object)date2);
            } else if (isGzipped2) {
                $this.logger().info(new StringBuilder().append((Object)"Extracting GZIP ").append((Object)file2.getAbsolutePath()).toString());
                FileHelper$.MODULE$.file2helper(file2).extractGzip();
                FileUtils.forceDelete((File)file2);
                String fileName = FilenameUtils.removeExtension((String)file2.getAbsolutePath());
                $this.logger().info(new StringBuilder().append((Object)"Archive extracted to directory: ").append((Object)fileName).toString());
                tuple2 = new Tuple2((Object)new File(fileName).getParentFile().getAbsolutePath(), (Object)date2);
            } else {
                tuple2 = new Tuple2((Object)file2.getParentFile().getAbsolutePath(), (Object)date2);
            }
            return tuple2;
        }
        throw new MatchError(tuple4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Tuple4 downloadSFTPArchive(DataLoader $this, String url, String resourceUid, Option lastChecked) {
        Tuple4 tuple4;
        Option<Tuple2<String, Date>> fileDetails;
        Tuple5 tuple5;
        Tuple5 tuple52;
        String string = url;
        Option option = $this.sftpPattern().unapplySeq((Object)string);
        if (option.isEmpty()) return new Tuple4(null, null, (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        if (option.get() == null) return new Tuple4(null, null, (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        if (((LinearSeqOptimized)option.get()).lengthCompare(2) != 0) return new Tuple4(null, null, (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        String server = (String)((LinearSeqOptimized)option.get()).apply(0);
        String filename = (String)((LinearSeqOptimized)option.get()).apply(1);
        if (url.endsWith(".zip")) {
            File f = new File(new StringBuilder().append((Object)$this.temporaryFileStore()).append((Object)resourceUid).append((Object)".zip").toString());
            f.createNewFile();
            tuple52 = new Tuple5((Object)f, null, (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        } else if (url.endsWith(".gz")) {
            File f = new File(new StringBuilder().append((Object)$this.temporaryFileStore()).append((Object)resourceUid).append((Object)File.separator).append((Object)resourceUid).append((Object)".gz").toString());
            $this.logger().info(new StringBuilder().append((Object)"  creating file: ").append((Object)f.getAbsolutePath()).toString());
            FileUtils.forceMkdir((File)f.getParentFile());
            f.createNewFile();
            tuple52 = new Tuple5((Object)f, null, (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        } else if (filename.contains(".")) {
            File f = new File(new StringBuilder().append((Object)$this.temporaryFileStore()).append((Object)resourceUid).append((Object)File.separator).append((Object)resourceUid).append((Object)".csv").toString());
            $this.logger().info(new StringBuilder().append((Object)"  creating file: ").append((Object)f.getAbsolutePath()).toString());
            FileUtils.forceMkdir((File)f.getParentFile());
            f.createNewFile();
            tuple52 = new Tuple5((Object)f, null, (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        } else {
            $this.logger().info(new StringBuilder().append((Object)"SFTP the most recent from ").append((Object)url).toString());
            if (DataLoader$class.fileDetails$1($this, url, resourceUid, lastChecked).isDefined()) {
                Tuple2 tuple2;
                Tuple2 tuple22 = (Tuple2)DataLoader$class.fileDetails$1($this, url, resourceUid, lastChecked).get();
                if (tuple22 == null) throw new MatchError((Object)tuple22);
                String file = (String)tuple22._1();
                Date date = (Date)tuple22._2();
                Tuple2 tuple23 = tuple2 = new Tuple2((Object)file, (Object)date);
                String file2 = (String)tuple23._1();
                Date date2 = (Date)tuple23._2();
                $this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The most recent file is ", " with last modified date : ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file2, date2})));
                tuple52 = new Tuple5((Object)new File(file2), (Object)date2, (Object)BoxesRunTime.boxToBoolean((boolean)file2.endsWith("zip")), (Object)BoxesRunTime.boxToBoolean((boolean)file2.endsWith("gz")), (Object)BoxesRunTime.boxToBoolean((boolean)true));
            } else {
                tuple52 = new Tuple5(null, null, (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)false));
            }
        }
        Tuple5 tuple53 = tuple52;
        if (tuple53 == null) throw new MatchError((Object)tuple53);
        File targetfile = (File)tuple53._1();
        Date date = (Date)tuple53._2();
        boolean isZipped = BoxesRunTime.unboxToBoolean((Object)tuple53._3());
        boolean isGzipped = BoxesRunTime.unboxToBoolean((Object)tuple53._4());
        boolean downloaded = BoxesRunTime.unboxToBoolean((Object)tuple53._5());
        Tuple5 tuple54 = tuple5 = new Tuple5((Object)targetfile, (Object)date, (Object)BoxesRunTime.boxToBoolean((boolean)isZipped), (Object)BoxesRunTime.boxToBoolean((boolean)isGzipped), (Object)BoxesRunTime.boxToBoolean((boolean)downloaded));
        File targetfile2 = (File)tuple54._1();
        Date date3 = (Date)tuple54._2();
        boolean isZipped2 = BoxesRunTime.unboxToBoolean((Object)tuple54._3());
        boolean isGzipped2 = BoxesRunTime.unboxToBoolean((Object)tuple54._4());
        boolean downloaded2 = BoxesRunTime.unboxToBoolean((Object)tuple54._5());
        Object object = targetfile2 == null ? None$.MODULE$ : (fileDetails = downloaded2 ? new Some((Object)new Tuple2((Object)targetfile2, (Object)date3)) : SFTPTools$.MODULE$.scpFile(server, Config$.MODULE$.getProperty("uploadUser"), Config$.MODULE$.getProperty("uploadPassword"), filename, targetfile2));
        if (fileDetails.isDefined()) {
            Tuple2 tuple2;
            Tuple2 tuple24 = (Tuple2)fileDetails.get();
            if (tuple24 == null) throw new MatchError((Object)tuple24);
            Object file = tuple24._1();
            Date date4 = (Date)tuple24._2();
            Tuple2 tuple25 = tuple2 = new Tuple2(file, (Object)date4);
            Object file3 = tuple25._1();
            Date date5 = (Date)tuple25._2();
            tuple4 = new Tuple4((Object)targetfile2, (Object)date5, (Object)BoxesRunTime.boxToBoolean((boolean)isZipped2), (Object)BoxesRunTime.boxToBoolean((boolean)isGzipped2));
            return tuple4;
        } else {
            tuple4 = new Tuple4(null, null, (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        return tuple4;
    }

    public static Option sftpLatestArchive(DataLoader $this, String url, String resourceUid, Option afterDate) {
        return SFTPTools$.MODULE$.sftpLatestArchive(url, resourceUid, $this.temporaryFileStore(), (Option<Date>)afterDate);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Tuple4 downloadStandardArchive(DataLoader $this, String url, String resourceUid, Option afterDate) {
        Tuple4 tuple4;
        Date date;
        File tmpStore = new File($this.temporaryFileStore());
        if (!tmpStore.exists()) {
            FileUtils.forceMkdir((File)tmpStore);
        }
        $this.logger().info(new StringBuilder().append((Object)"Downloading zip file from ").append((Object)url).toString());
        URLConnection urlConnection = new URL(url.replaceAll(" ", "%20")).openConnection();
        Date date2 = date = urlConnection.getLastModified() == 0L ? new Date() : new Date(urlConnection.getLastModified());
        if (afterDate.isEmpty() || urlConnection.getLastModified() == 0L || ((Date)afterDate.get()).getTime() < urlConnection.getLastModified()) {
            Tuple3 tuple3;
            Tuple3 tuple32;
            Tuple3 tuple33;
            String contentDisp = urlConnection.getHeaderField("Content-Disposition");
            if (contentDisp != null) {
                $this.logger().info(new StringBuilder().append((Object)" Content-Disposition: ").append((Object)contentDisp).toString());
            }
            InputStream in = urlConnection.getInputStream();
            if (url.endsWith(".zip") || contentDisp != null && contentDisp.endsWith(".zip\"")) {
                File f = new File(new StringBuilder().append((Object)$this.temporaryFileStore()).append((Object)BoxesRunTime.boxToCharacter((char)File.separatorChar)).append((Object)resourceUid).append((Object)".zip").toString());
                $this.logger().info(new StringBuilder().append((Object)"Creating file: ").append((Object)f.getAbsolutePath()).toString());
                f.createNewFile();
                tuple33 = new Tuple3((Object)f, (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)false));
            } else if (url.endsWith(".gz") || contentDisp != null && contentDisp.endsWith(".gz\"")) {
                File f = new File(new StringBuilder().append((Object)$this.temporaryFileStore()).append((Object)BoxesRunTime.boxToCharacter((char)File.separatorChar)).append((Object)resourceUid).append((Object)File.separator).append((Object)resourceUid).append((Object)".gz").toString());
                $this.logger().info(new StringBuilder().append((Object)"Creating file: ").append((Object)f.getAbsolutePath()).toString());
                FileUtils.forceMkdir((File)f.getParentFile());
                f.createNewFile();
                tuple33 = new Tuple3((Object)f, (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)true));
            } else {
                File f = new File(new StringBuilder().append((Object)$this.temporaryFileStore()).append((Object)BoxesRunTime.boxToCharacter((char)File.separatorChar)).append((Object)resourceUid).append((Object)File.separator).append((Object)resourceUid).append((Object)".csv").toString());
                $this.logger().info(new StringBuilder().append((Object)"Creating file: ").append((Object)f.getAbsolutePath()).toString());
                FileUtils.forceMkdir((File)f.getParentFile());
                f.createNewFile();
                tuple33 = tuple32 = new Tuple3((Object)f, (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)false));
            }
            if (tuple32 == null) throw new MatchError((Object)tuple32);
            File file = (File)tuple32._1();
            boolean isZipped = BoxesRunTime.unboxToBoolean((Object)tuple32._2());
            boolean isGzipped = BoxesRunTime.unboxToBoolean((Object)tuple32._3());
            Tuple3 tuple34 = tuple3 = new Tuple3((Object)file, (Object)BoxesRunTime.boxToBoolean((boolean)isZipped), (Object)BoxesRunTime.boxToBoolean((boolean)isGzipped));
            File file2 = (File)tuple34._1();
            boolean isZipped2 = BoxesRunTime.unboxToBoolean((Object)tuple34._2());
            boolean isGzipped2 = BoxesRunTime.unboxToBoolean((Object)tuple34._3());
            FileOutputStream out = new FileOutputStream(file2);
            byte[] buffer = new byte[40960];
            int numRead = 0;
            int counter = 0;
            while ((numRead = in.read(buffer)) != -1) {
                counter += numRead;
                out.write(buffer, 0, numRead);
                out.flush();
            }
            out.flush();
            in.close();
            out.close();
            $this.logger().info("Downloaded. File size: ", new Object[]{new StringBuilder().append(counter / 1024).append((Object)"kB, ").append((Object)file2.getAbsolutePath()).append((Object)", is zipped: ").append((Object)BoxesRunTime.boxToBoolean((boolean)isZipped2)).append((Object)"\n").toString()});
            tuple4 = new Tuple4((Object)file2, (Object)date, (Object)BoxesRunTime.boxToBoolean((boolean)isZipped2), (Object)BoxesRunTime.boxToBoolean((boolean)isGzipped2));
            return tuple4;
        } else {
            $this.logger().info("The file has not changed since the last time it  was loaded. To load the data a force-load will need to be performed");
            tuple4 = new Tuple4(null, null, (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        return tuple4;
    }

    public static boolean updateLastChecked(DataLoader $this, String resourceUid, Option dataCurrency) {
        boolean bl;
        try {
            String string = Config$.MODULE$.allowCollectoryUpdates();
            String string2 = "true";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                HashMap map = new HashMap();
                map.$plus$plus$eq((TraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"user"), (Object)$this.user()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"api_key"), (Object)Config$.MODULE$.collectoryApiKey()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"lastChecked"), (Object)$this.loadTime())})));
                Object object = dataCurrency.isDefined() ? map.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"dataCurrency"), (Object)BiocacheConversions$.MODULE$.dateToString((Date)dataCurrency.get()))) : BoxedUnit.UNIT;
                String data = ((TraversableOnce)map.map((Function1)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Tuple2<String, String> pair) {
                        return new StringBuilder().append((Object)"\"").append(pair._1()).append((Object)"\":\"").append(pair._2()).append((Object)"\"").toString();
                    }
                }, Iterable$.MODULE$.canBuildFrom())).mkString("{", ",", "}");
                Tuple2<Object, String> tuple2 = HttpUtil$.MODULE$.postBody(new StringBuilder().append((Object)Config$.MODULE$.registryUrl()).append((Object)"/dataResource/").append((Object)resourceUid).toString(), "application/json", data);
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    int responseCode = tuple2._1$mcI$sp();
                    String responseBody = (String)tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)responseCode), (Object)responseBody);
                    int responseCode2 = tuple23._1$mcI$sp();
                    String responseBody2 = (String)tuple23._2();
                    $this.logger().info(new StringBuilder().append((Object)"Registry response code: ").append((Object)BoxesRunTime.boxToInteger((int)responseCode2)).toString());
                } else {
                    throw new MatchError(tuple2);
                }
            }
            bl = true;
        }
        catch (Exception exception) {
            $this.logger().warn(new StringBuilder().append((Object)"Unable to update the lastChecked timestamp in the collectory.  This is most likely caused by a bad URL path for the collectory. Please check configuration. ").append((Object)exception.getMessage()).toString(), (Throwable)exception);
            bl = false;
        }
        return bl;
    }

    public static Option updateLastChecked$default$2(DataLoader $this) {
        return None$.MODULE$;
    }

    private static final Option writer$1(DataLoader $this, String resourceUid$1) {
        return $this.getRowKeyWriter(resourceUid$1, true);
    }

    private static final Option fileDetails$1(DataLoader $this, String url$3, String resourceUid$2, Option lastChecked$1) {
        return SFTPTools$.MODULE$.sftpLatestArchive(url$3, resourceUid$2, $this.temporaryFileStore(), (Option<Date>)lastChecked$1);
    }

    public static void $init$(DataLoader $this) {
        $this.au$org$ala$biocache$load$DataLoader$_setter_$user_$eq("biocache");
        $this.au$org$ala$biocache$load$DataLoader$_setter_$logger_$eq(LoggerFactory.getLogger((String)"DataLoader"));
        $this.au$org$ala$biocache$load$DataLoader$_setter_$temporaryFileStore_$eq(Config$.MODULE$.loadFileStore());
        $this.au$org$ala$biocache$load$DataLoader$_setter_$pm_$eq(Config$.MODULE$.persistenceManager());
        $this.au$org$ala$biocache$load$DataLoader$_setter_$loadTime_$eq(DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd'T'HH:mm:ss'Z'"));
        $this.au$org$ala$biocache$load$DataLoader$_setter_$sftpPattern_$eq(new StringOps(Predef$.MODULE$.augmentString("sftp://([a-zA-z\\.]*):([0-9a-zA-Z_/\\.\\-]*)")).r());
    }
}

