/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.index.lucene;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.io.LegacyShapeReadWriterFormat;
import com.spatial4j.core.shape.Shape;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.spatial.prefix.PrefixTreeStrategy;
import org.apache.lucene.spatial.prefix.tree.Cell;
import org.apache.lucene.spatial.prefix.tree.SpatialPrefixTree;
import org.apache.lucene.spatial.query.SpatialArgs;
import org.apache.solr.schema.DateField;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.SpatialRecursivePrefixTreeFieldType;
import org.apache.solr.schema.SpatialTermQueryPrefixTreeFieldType;
import org.apache.solr.schema.StrField;
import org.apache.solr.schema.TextField;
import org.apache.solr.schema.TrieDateField;
import org.apache.solr.schema.TrieField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecycleDoc
implements Iterable<IndexableField> {
    public static final Logger logger = Logger.getLogger(RecycleDoc.class);
    List<Boolean> fieldEnabled = new ArrayList<Boolean>();
    List<SchemaField> schemaFields = new ArrayList<SchemaField>();
    List<IndexableField> fields = new ArrayList<IndexableField>();
    Map<String, List<Integer>> fieldOrder = new HashMap<String, List<Integer>>();
    int size = 0;
    IndexSchema schema;

    public RecycleDoc(IndexSchema schema) {
        this.schema = schema;
    }

    public void add(SchemaField schemaField, IndexableField field) {
        List<Integer> list = this.fieldOrder.get(field.name());
        if (list == null) {
            list = new ArrayList<Integer>();
            this.fieldOrder.put(field.name(), list);
        }
        list.add(this.fields.size());
        this.schemaFields.add(schemaField);
        this.fieldEnabled.add(true);
        this.fields.add(field);
        ++this.size;
    }

    public void reset() {
        for (int i = this.fieldEnabled.size() - 1; i >= 0; --i) {
            this.fieldEnabled.set(i, false);
        }
        this.size = 0;
    }

    public String[] get(String name) {
        List<Integer> idx = this.fieldOrder.get(name);
        if (idx != null) {
            int pos = 0;
            for (Integer i : idx) {
                if (!this.fieldEnabled.get(i).booleanValue()) continue;
                ++pos;
            }
            if (pos > 0) {
                String[] s = new String[pos];
                pos = 0;
                for (Integer i : idx) {
                    if (!this.fieldEnabled.get(i).booleanValue()) continue;
                    s[pos++] = this.fields.get(i).stringValue();
                }
                return s;
            }
        }
        return null;
    }

    public boolean setField(String name, Object value) {
        int count;
        boolean found = false;
        List<Integer> idx = this.fieldOrder.get(name);
        if (idx == null) {
            return false;
        }
        for (count = 0; count < idx.size() && this.fieldEnabled.get(idx.get(count)).booleanValue(); ++count) {
        }
        if (count < idx.size()) {
            int i = idx.get(count);
            SchemaField sf = this.schemaFields.get(i);
            FieldType ft = sf.getType();
            IndexableField f = this.fields.get(i);
            try {
                if (ft instanceof StrField) {
                    ((Field)f).setStringValue(String.valueOf(value));
                    found = true;
                } else if (ft instanceof TrieField) {
                    switch (((TrieField)ft).getType().ordinal()) {
                        case 0: {
                            ((Field)f).setIntValue(value instanceof Number ? ((Number)value).intValue() : Integer.parseInt((String)value));
                            found = true;
                            break;
                        }
                        case 1: {
                            ((Field)f).setLongValue(value instanceof Number ? ((Number)value).longValue() : Long.parseLong((String)value));
                            found = true;
                            break;
                        }
                        case 2: {
                            ((Field)f).setFloatValue(value instanceof Number ? ((Number)value).floatValue() : Float.parseFloat((String)value));
                            found = true;
                            break;
                        }
                        case 3: {
                            ((Field)f).setDoubleValue(value instanceof Number ? ((Number)value).doubleValue() : Double.parseDouble((String)value));
                            found = true;
                            break;
                        }
                        case 4: {
                            ((Field)f).setLongValue(value instanceof Date ? ((Date)value).getTime() : ((DateField)ft).parseMath(null, (String)value).getTime());
                            found = true;
                            break;
                        }
                    }
                } else if (ft instanceof TextField) {
                    ((Field)f).setStringValue((String)value);
                    found = true;
                } else if (ft instanceof TrieDateField) {
                    ((Field)f).setLongValue(value instanceof Date ? ((Date)value).getTime() : ((DateField)ft).parseMath(null, (String)value).getTime());
                    found = true;
                } else if (ft instanceof SpatialTermQueryPrefixTreeFieldType || ft instanceof SpatialRecursivePrefixTreeFieldType) {
                    PrefixTreeStrategy strategy = ft instanceof SpatialTermQueryPrefixTreeFieldType ? (PrefixTreeStrategy)((SpatialTermQueryPrefixTreeFieldType)ft).getStrategy(name) : (PrefixTreeStrategy)((SpatialRecursivePrefixTreeFieldType)ft).getStrategy(name);
                    Double distErrPct = strategy.getDistErrPct();
                    SpatialPrefixTree grid = strategy.getGrid();
                    SpatialContext ctx = strategy.getSpatialContext();
                    String str = String.valueOf(value);
                    Shape shape = null;
                    if (value instanceof Shape) {
                        shape = (Shape)value;
                    } else {
                        shape = LegacyShapeReadWriterFormat.readShapeOrNull((String)str, (SpatialContext)ctx);
                        Shape shape2 = shape = shape != null ? shape : ctx.readShapeFromWkt(value.toString());
                    }
                    if (shape != null) {
                        if (sf.indexed()) {
                            double distErr = SpatialArgs.calcDistanceFromErrPct((Shape)shape, (double)distErrPct, (SpatialContext)ctx);
                            int detailLevel = grid.getLevelForDistance(distErr);
                            List cells = grid.getCells(shape, detailLevel, true, false);
                            ((Field)f).setTokenStream((TokenStream)new SpatialTokenStream(cells.iterator()));
                            this.fieldEnabled.set(idx.get(count), true);
                            ++count;
                        }
                        if (sf.stored()) {
                            if (count < idx.size()) {
                                i = idx.get(count);
                                sf = this.schemaFields.get(i);
                                ft = sf.getType();
                                f = this.fields.get(i);
                            }
                            ((StoredField)f).setStringValue(String.valueOf(str));
                        }
                        found = true;
                    }
                } else {
                    logger.error((Object)("MISSING FIELD " + name + " = " + value.toString() + ", " + ft.getClass().getName()));
                }
            }
            catch (Exception e) {
                logger.error((Object)("FIELD EXCEPTION " + name + " = " + value.toString() + ", " + ft.getClass().getName() + " : " + e.getMessage()), (Throwable)e);
            }
        }
        if (found) {
            this.fieldEnabled.set(idx.get(count), true);
        }
        return found;
    }

    @Override
    public Iterator<IndexableField> iterator() {
        int i;
        final int len = this.fieldEnabled.size();
        for (i = 0; i < len && !this.fieldEnabled.get(i).booleanValue(); ++i) {
        }
        final int start = i;
        return new Iterator<IndexableField>(){
            int pos;
            {
                this.pos = start;
            }

            @Override
            public boolean hasNext() {
                return this.pos < len;
            }

            @Override
            public IndexableField next() {
                IndexableField f = RecycleDoc.this.fields.get(this.pos);
                while (++this.pos < len && !RecycleDoc.this.fieldEnabled.get(this.pos).booleanValue()) {
                }
                return f;
            }

            @Override
            public void remove() {
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SpatialTokenStream
    extends TokenStream {
        private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
        private Iterator<Cell> iter = null;
        CharSequence nextTokenStringNeedingLeaf = null;

        public SpatialTokenStream(Iterator<Cell> tokens) {
            this.iter = tokens;
        }

        public boolean incrementToken() {
            this.clearAttributes();
            if (this.nextTokenStringNeedingLeaf != null) {
                this.termAtt.append(this.nextTokenStringNeedingLeaf);
                this.termAtt.append('+');
                this.nextTokenStringNeedingLeaf = null;
                return true;
            }
            if (this.iter.hasNext()) {
                Cell cell = this.iter.next();
                String token = cell.getTokenString();
                this.termAtt.append(token);
                if (cell.isLeaf()) {
                    this.nextTokenStringNeedingLeaf = token;
                }
                return true;
            }
            return false;
        }
    }
}

