/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.index.lucene;

import au.com.bytecode.opencsv.CSVWriter;
import au.org.ala.biocache.index.lucene.DocBuilder;
import au.org.ala.biocache.index.lucene.RecycleDoc;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CheckIndex;
import org.apache.lucene.index.ConcurrentMergeScheduler;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Version;
import org.apache.solr.schema.IndexSchema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneIndexing {
    private static final Logger logger = Logger.getLogger(LuceneIndexing.class);
    private static final int MERGE_SEGMENTS = 8;
    private IndexSchema schema;
    private Long maxIndexSize;
    private String outputPath;
    private Integer ramBufferSize;
    private Integer docCacheSize;
    private Integer commitBatchSize;
    private Integer commitThreadCount;
    private List<File> outputDirectories = new ArrayList<File>();
    private int directoryCounter = 0;
    public LinkedBlockingQueue<RecycleDoc> documents;
    private LinkedBlockingQueue<RecycleDoc> docPool;
    private List<Consumer> consumers = new ArrayList<Consumer>();
    private IndexWriter writer = null;
    private Directory directory = null;
    public long count = 0L;
    List<RecycleDoc> noThreadBatch;
    AtomicLong time = new AtomicLong(0L);
    private AtomicInteger additionalDocs = new AtomicInteger(0);
    private AtomicInteger waitingForWriter = new AtomicInteger(0);
    private Object nextDocLock = new Object();
    private int noThreadBatchIdx = -1;
    private Object noThreadAddLock = new Object();
    private Object closeLock = new Object();
    private Object setupLock = new Object();

    public LuceneIndexing(IndexSchema solrSchema, Long maxIndexSize, String outputPath, Integer ramBufferSize, Integer docCacheSize, Integer commitBatchSize, Integer commitThreadCount) throws InterruptedException {
        this.schema = solrSchema;
        this.maxIndexSize = maxIndexSize;
        this.outputPath = outputPath;
        this.ramBufferSize = ramBufferSize;
        this.docCacheSize = docCacheSize;
        this.commitBatchSize = Math.min(docCacheSize, commitBatchSize);
        this.commitThreadCount = commitThreadCount;
        this.initDocumentQueues();
        if (commitThreadCount > 0) {
            Consumer c = new Consumer();
            this.consumers.add(c);
            c.start();
        } else {
            this.noThreadBatch = new ArrayList<RecycleDoc>(commitBatchSize);
        }
    }

    public LuceneIndexing(IndexSchema solrSchema, String outputPath) throws InterruptedException {
        this.schema = solrSchema;
        this.outputPath = outputPath;
        this.maxIndexSize = 2147483547L;
        this.ramBufferSize = 100;
        this.docCacheSize = 5000;
        this.commitBatchSize = 5000;
        this.commitThreadCount = 1;
        this.initDocumentQueues();
        Consumer c = new Consumer();
        this.consumers.add(c);
        c.start();
    }

    private void initDocumentQueues() throws InterruptedException {
        this.documents = new LinkedBlockingQueue(this.docCacheSize);
        this.docPool = new LinkedBlockingQueue(this.docCacheSize + this.commitThreadCount + 1);
        for (int i = 0; i < this.docCacheSize; ++i) {
            this.docPool.put(new RecycleDoc(this.schema));
        }
    }

    public long getCount() {
        return this.count;
    }

    public List<File> getOutputDirectories() {
        return this.outputDirectories;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void merge(List<File> directories, File outputDirectory, Integer ramBufferSize, Integer numberOfSegments, boolean skipTest) throws IOException {
        logger.info((Object)("Begin merge: " + outputDirectory.getPath()));
        ArrayList<File> validDirectories = new ArrayList<File>();
        for (int i = directories.size() - 1; i >= 0; --i) {
            File dir = directories.get(i);
            FSDirectory d = null;
            boolean valid = false;
            if (dir.isDirectory()) {
                if (skipTest) {
                    if (new File(directories.get(i).getPath() + "/segments.gen").exists()) {
                        logger.info((Object)("including '" + dir.getPath() + "' in index merge"));
                        validDirectories.add(dir);
                        valid = true;
                    }
                } else {
                    try {
                        d = FSDirectory.open((File)dir);
                        CheckIndex ci = new CheckIndex((Directory)d);
                        ci.setFailFast(true);
                        ci.checkIndex();
                        valid = true;
                        validDirectories.add(dir);
                        logger.info((Object)("including '" + dir.getPath() + "' in index merge"));
                    }
                    catch (Exception e) {
                    }
                    finally {
                        if (d != null) {
                            try {
                                d.close();
                            }
                            catch (Exception e) {
                                logger.error((Object)("Failed to close lucene directory '" + dir.getPath() + "'"));
                                valid = false;
                            }
                        }
                    }
                }
            }
            if (valid) continue;
            logger.error((Object)("not including '" + dir.getPath() + "' in index merge"));
        }
        if (!outputDirectory.exists()) {
            outputDirectory.mkdirs();
        }
        FSDirectory directory = FSDirectory.open((File)outputDirectory);
        IndexWriterConfig config = new IndexWriterConfig(Version.LATEST, null);
        config.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
        config.setRAMBufferSizeMB((double)ramBufferSize.intValue());
        config.setMergeScheduler((MergeScheduler)new ConcurrentMergeScheduler());
        ((ConcurrentMergeScheduler)config.getMergeScheduler()).setMaxMergesAndThreads(numberOfSegments.intValue(), numberOfSegments.intValue());
        ((ConcurrentMergeScheduler)config.getMergeScheduler()).setMergeThreadPriority(3);
        IndexWriter writer = new IndexWriter((Directory)directory, config);
        ArrayList<FSDirectory> dirs = new ArrayList<FSDirectory>();
        for (File f : validDirectories) {
            dirs.add(FSDirectory.open((File)f));
        }
        writer.addIndexes(dirs.toArray(new Directory[0]));
        if (numberOfSegments > directories.size()) {
            writer.forceMerge(numberOfSegments.intValue());
        }
        writer.commit();
        writer.close();
        directory.close();
        logger.info((Object)("Finished merge: " + outputDirectory.getPath()));
    }

    public DocBuilder getDocBuilder() {
        return new DocBuilder(this.schema, this);
    }

    public Long getTiming() {
        return this.time.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RecycleDoc nextDoc() throws InterruptedException {
        Object object = this.nextDocLock;
        synchronized (object) {
            RecycleDoc doc;
            int timeout = 0;
            boolean waiting = false;
            while (waiting || (doc = this.docPool.poll(timeout, TimeUnit.MILLISECONDS)) == null) {
                if (this.waitingForWriter.get() == 0 && this.documents.size() == 0) {
                    this.additionalDocs.incrementAndGet();
                    logger.debug((Object)("Memory leak. " + this.additionalDocs.get() + " additional RecycleDocs created. Are all DocBuilder.newDoc() objects released or indexed?"));
                    doc = new RecycleDoc(this.schema);
                    break;
                }
                timeout = 10;
                waiting = true;
            }
            return doc;
        }
    }

    protected void addDoc(RecycleDoc doc) throws InterruptedException, IOException {
        this.addDoc(doc, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addDoc(RecycleDoc doc, boolean force) throws InterruptedException, IOException {
        if (this.commitThreadCount > 0) {
            this.documents.put(doc);
        } else {
            Object object = this.noThreadAddLock;
            synchronized (object) {
                this.waitingForWriter.incrementAndGet();
                if (doc.get("id") != null) {
                    if (this.noThreadBatchIdx < 0) {
                        this.noThreadBatch.add(doc);
                    } else {
                        this.noThreadBatch.set(this.noThreadBatchIdx, doc);
                        ++this.noThreadBatchIdx;
                    }
                } else if (doc.schema != null) {
                    this.release(doc);
                }
                if (force || this.noThreadBatchIdx < 0 && this.noThreadBatch.size() >= this.commitBatchSize || this.noThreadBatchIdx >= this.commitBatchSize) {
                    long t1;
                    block22: {
                        this.count += (long)Math.min(this.noThreadBatch.size(), this.commitBatchSize);
                        if (force && this.noThreadBatchIdx >= 0 && this.noThreadBatchIdx < this.noThreadBatch.size()) {
                            while (this.noThreadBatch.size() > this.noThreadBatchIdx && this.noThreadBatch.size() > 0) {
                                this.noThreadBatch.remove(this.noThreadBatch.size() - 1);
                            }
                        }
                        t1 = System.nanoTime();
                        this.setup();
                        try {
                            this.writer.addDocuments(this.noThreadBatch);
                            if (!logger.isDebugEnabled()) break block22;
                            logger.debug((Object)(this.outputPath + " >>> numDocs=" + this.writer.numDocs() + " ramDocs=" + this.writer.numRamDocs() + " ramBytes=" + this.writer.ramBytesUsed()));
                        }
                        catch (IOException e) {
                            logger.error((Object)("Error committing batch. " + e.getMessage()), (Throwable)e);
                        }
                        catch (Exception e) {
                            logger.error((Object)("failed to index: " + e.getMessage()), (Throwable)e);
                            if (logger.isDebugEnabled()) {
                                this.logDebugError(this.noThreadBatch, e);
                            }
                        }
                        finally {
                            for (RecycleDoc d : this.noThreadBatch) {
                                this.release(d);
                            }
                        }
                    }
                    this.noThreadBatchIdx = 0;
                    this.newIndexTest(null);
                    this.time.addAndGet(System.nanoTime() - t1);
                }
                this.waitingForWriter.decrementAndGet();
            }
        }
    }

    private void writeDocString(File file, List<RecycleDoc> documents) throws IOException {
        OutputStream out = file.getName().endsWith(".gz") ? new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(file))) : new FileOutputStream(file);
        CSVWriter csv = new CSVWriter((Writer)new OutputStreamWriter(out));
        for (RecycleDoc d : documents) {
            ArrayList<String> line = new ArrayList<String>();
            Iterator<IndexableField> i = d.iterator();
            while (i.hasNext()) {
                line.add(i.next().stringValue());
            }
            csv.writeNext(line.toArray(new String[0]));
        }
        out.close();
    }

    private void logDebugError(List list, Exception e) {
        try {
            File f = File.createTempFile("indexing.error", "");
            FileUtils.writeStringToFile((File)f, (String)(e.getMessage() + "\n"));
            this.writeDocString(new File(f.getPath() + ".data.gz"), list);
            logger.error((Object)("ERROR indexing: see " + f.getPath() + " for error and " + f.getPath() + ".data for data: " + e.getMessage()));
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newIndexTest(Semaphore commitLock) throws InterruptedException {
        if ((long)this.writer.numDocs() > this.maxIndexSize) {
            try {
                if (commitLock != null) {
                    commitLock.acquire(this.commitThreadCount);
                }
                this.closeIndex();
            }
            catch (IOException e) {
                logger.error((Object)("Error committing batch. " + e.getMessage()), (Throwable)e);
            }
            finally {
                if (commitLock != null) {
                    commitLock.release(this.commitThreadCount);
                }
            }
        }
    }

    public void close(boolean wait) throws IOException, InterruptedException {
        this.close(wait, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean wait, boolean merge2) throws IOException, InterruptedException {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.commitThreadCount > 0) {
                if (this.consumers.size() > 0) {
                    DocBuilder db = this.getDocBuilder();
                    db.newDoc("exit");
                    db.addField("id", "exit");
                    int alive = 0;
                    for (Consumer t : this.consumers) {
                        if (!t.isAlive()) continue;
                        ++alive;
                    }
                    if (alive > 0) {
                        if (!wait) {
                            for (Consumer t : this.consumers) {
                                t.interrupt();
                            }
                        } else {
                            for (Consumer t : this.consumers) {
                                db.index();
                            }
                            for (Consumer t : this.consumers) {
                                t.join();
                            }
                        }
                    }
                }
            } else {
                this.addDoc(new RecycleDoc(null), true);
            }
            this.closeIndex();
            if (merge2 && this.outputDirectories.size() > 1) {
                this.setup();
                File output = new File(this.outputPath + "_merged");
                this.documents = null;
                this.docPool = null;
                this.consumers = null;
                System.gc();
                int mem = (int)Math.max((double)Runtime.getRuntime().freeMemory() * 0.75 / 1024.0 / 1024.0, (double)this.ramBufferSize.intValue());
                LuceneIndexing.merge(this.outputDirectories, output, mem, 8, true);
                for (File d : this.outputDirectories) {
                    d.delete();
                }
                this.outputDirectories.clear();
                this.outputDirectories.add(output);
            }
        }
    }

    private void closeIndex() throws IOException {
        if (this.writer != null) {
            this.writer.commit();
            this.writer.close();
            this.directory.close();
            this.writer = null;
            this.directory = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(RecycleDoc doc) throws InterruptedException {
        AtomicInteger atomicInteger = this.additionalDocs;
        synchronized (atomicInteger) {
            if (this.additionalDocs.get() > 0) {
                this.additionalDocs.decrementAndGet();
            } else {
                this.docPool.put(doc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setup() throws IOException {
        Object object = this.setupLock;
        synchronized (object) {
            if (this.directory == null || this.writer == null) {
                File file = this.directoryCounter == 0 ? new File(this.outputPath) : new File(this.outputPath + "_" + this.directoryCounter);
                file.mkdirs();
                this.directory = FSDirectory.open((File)file);
                ++this.directoryCounter;
                this.outputDirectories.add(file);
                IndexWriterConfig config = new IndexWriterConfig(Version.LATEST, this.schema.getIndexAnalyzer());
                config.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
                config.setRAMBufferSizeMB((double)this.ramBufferSize.intValue());
                this.writer = new IndexWriter(this.directory, config);
            }
        }
    }

    public int getThreadCount() {
        return this.commitThreadCount;
    }

    public int getQueueSize() {
        if (this.commitThreadCount > 0 && this.documents != null) {
            return this.documents.size();
        }
        return 0;
    }

    public int getBatchSize() {
        if (this.commitThreadCount > 0) {
            if (this.consumers == null || this.consumers.size() < 1 || this.consumers.get((int)0).batch == null) {
                return 0;
            }
            return this.consumers.get((int)0).batch.size();
        }
        if (this.noThreadBatch == null) {
            return 0;
        }
        return Math.max(this.noThreadBatchIdx, this.noThreadBatch.size());
    }

    public int ramDocs() {
        try {
            if (this.writer == null) {
                return 0;
            }
            return this.writer.numRamDocs();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public long ramBytes() {
        try {
            if (this.writer == null) {
                return 0L;
            }
            return this.writer.ramBytesUsed();
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public int getCommitThreadCount() {
        return this.commitThreadCount;
    }

    public static void main(String[] args) throws Exception {
        String dst;
        String src;
        System.out.println("usage: LuceneIndexing [-skipTest | -removeDuplicates] sourceDirectory destinationDirectory\n\nDefault: merge source subdirectories into destinationDirectory after testing each subdirectory index.\n\n");
        boolean skipTest = false;
        boolean merge2 = true;
        if ("-skipTest".equals(args[0])) {
            skipTest = true;
            src = args[1];
            dst = args[2];
        } else if ("-removeDuplicates".equals(args[0])) {
            src = args[1];
            dst = args[2];
            merge2 = false;
        } else {
            src = args[0];
            dst = args[1];
        }
        if (merge2) {
            int numThreads = 8;
            int mem = (int)((double)Runtime.getRuntime().freeMemory() * 0.75) / 1024 / 1024;
            LuceneIndexing.merge(Arrays.asList(new File(src).listFiles()), new File(dst), mem, numThreads, skipTest);
        } else {
            LuceneIndexing.removeDuplicates(src, dst);
        }
    }

    private static void removeDuplicates(String src, String dst) throws IOException {
        FSDirectory srcDir = FSDirectory.open((File)new File(src));
        DirectoryReader srcReader = DirectoryReader.open((Directory)srcDir);
        HashSet<String> srcIds = new HashSet<String>();
        for (int i = 0; i < srcReader.maxDoc(); ++i) {
            srcIds.add(srcReader.document(i).get("id"));
        }
        srcReader.close();
        srcDir.close();
        FSDirectory dstDir = FSDirectory.open((File)new File(dst));
        DirectoryReader dstReader = DirectoryReader.open((Directory)dstDir);
        HashSet<String> dstIds = new HashSet<String>();
        for (int i = 0; i < dstReader.maxDoc(); ++i) {
            Document doc = dstReader.document(i);
            if (!srcIds.contains(doc.get("id"))) continue;
            dstIds.add(doc.get("id"));
        }
        dstReader.close();
        System.out.println("DELETING " + dstIds.size() + " documents");
        IndexWriterConfig config = new IndexWriterConfig(Version.LATEST, null);
        config.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
        IndexWriter writer = new IndexWriter((Directory)dstDir, config);
        for (String id : dstIds) {
            writer.deleteDocuments(new Term[]{new Term("id", id)});
        }
        writer.commit();
        writer.close();
        dstDir.close();
    }

    class Consumer
    extends Thread {
        List<CommitThread> commitThreads = new ArrayList<CommitThread>();
        LinkedBlockingQueue<List<RecycleDoc>> batches = new LinkedBlockingQueue();
        Semaphore commitLock = new Semaphore(LuceneIndexing.access$000(LuceneIndexing.this), true);
        List<RecycleDoc> batch = new ArrayList<RecycleDoc>(LuceneIndexing.access$100(LuceneIndexing.this));

        Consumer() {
        }

        public void run() {
            for (int i = 0; i < LuceneIndexing.this.commitThreadCount; ++i) {
                CommitThread t = new CommitThread();
                this.commitThreads.add(t);
                t.start();
            }
            try {
                while (true) {
                    RecycleDoc d = LuceneIndexing.this.documents.take();
                    LuceneIndexing.this.waitingForWriter.incrementAndGet();
                    if (d.get("id") != null && d.get("id")[0].equals("exit")) {
                        if (this.batch.size() > 0) {
                            this.batches.put(this.batch);
                        }
                        for (CommitThread t : this.commitThreads) {
                            this.batches.put(new ArrayList());
                        }
                        for (CommitThread t : this.commitThreads) {
                            t.join();
                        }
                        LuceneIndexing.this.waitingForWriter.decrementAndGet();
                        break;
                    }
                    if (d.get("id") != null) {
                        this.batch.add(d);
                    } else {
                        LuceneIndexing.this.release(d);
                    }
                    if (this.batch.size() >= LuceneIndexing.this.commitBatchSize) {
                        LuceneIndexing.this.count += (long)LuceneIndexing.this.commitBatchSize.intValue();
                        this.batches.put(this.batch);
                        this.batch = new ArrayList<RecycleDoc>(LuceneIndexing.this.commitBatchSize);
                        continue;
                    }
                    LuceneIndexing.this.waitingForWriter.decrementAndGet();
                }
            }
            catch (InterruptedException e) {
                for (CommitThread t : this.commitThreads) {
                    if (!t.isAlive()) continue;
                    t.interrupt();
                }
            }
        }

        class CommitThread
        extends Thread {
            CommitThread() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    List<RecycleDoc> batch;
                    while ((batch = Consumer.this.batches.take()).size() != 0) {
                        long t1;
                        block13: {
                            t1 = System.nanoTime();
                            try {
                                Consumer.this.commitLock.acquire();
                                LuceneIndexing.this.setup();
                                LuceneIndexing.this.writer.addDocuments(batch);
                                if (!logger.isDebugEnabled()) break block13;
                                logger.debug((Object)(LuceneIndexing.this.outputPath + " >>> numDocs=" + LuceneIndexing.this.writer.numDocs() + " ramDocs=" + LuceneIndexing.this.writer.numRamDocs() + " ramBytes=" + LuceneIndexing.this.writer.ramBytesUsed()));
                            }
                            catch (IOException e) {
                                logger.error((Object)("Error committing batch. " + e.getMessage()), (Throwable)e);
                            }
                            catch (InterruptedException e) {
                                throw e;
                            }
                            catch (Exception e) {
                                if (logger.isDebugEnabled()) {
                                    LuceneIndexing.this.logDebugError(batch, e);
                                }
                            }
                            finally {
                                Consumer.this.commitLock.release();
                                for (RecycleDoc d : batch) {
                                    LuceneIndexing.this.release(d);
                                }
                            }
                        }
                        LuceneIndexing.this.waitingForWriter.decrementAndGet();
                        LuceneIndexing.this.newIndexTest(Consumer.this.commitLock);
                        LuceneIndexing.this.time.addAndGet(System.nanoTime() - t1);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

