/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.export;

import au.org.ala.biocache.Config$;
import au.org.ala.biocache.cmd.Tool;
import au.org.ala.biocache.cmd.Tool$class;
import au.org.ala.biocache.export.DwCACreator;
import au.org.ala.biocache.util.OptionParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.LinearSeqOptimized;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.util.matching.Regex;
import scala.util.parsing.json.JSON$;

public final class DwCACreator$
implements Tool {
    public static final DwCACreator$ MODULE$;
    private final Logger logger;
    private final Regex dataResourcePattern;

    static {
        new DwCACreator$();
    }

    @Override
    public String help() {
        return Tool$class.help(this);
    }

    @Override
    public String cmd() {
        return "createdwc";
    }

    @Override
    public String desc() {
        return "Create a Darwin Core Archive for a data resource";
    }

    public Logger logger() {
        return this.logger;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void main(String[] args) {
        ObjectRef resourceUid = new ObjectRef((Object)"");
        ObjectRef directory = new ObjectRef((Object)"");
        OptionParser parser = new OptionParser(resourceUid, directory){
            {
                this.arg("data-resource-uid", "The UID of the data resource to load or 'all' to generate for all", (Function1<String, BoxedUnit>)new Serializable(this, resourceUid$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef resourceUid$1;

                    public final void apply(String v) {
                        this.resourceUid$1.elem = v;
                    }
                    {
                        this.resourceUid$1 = resourceUid$1;
                    }
                });
                this.arg("directory-to-dump", "skip the download and use local file", (Function1<String, BoxedUnit>)new Serializable(this, directory$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef directory$1;

                    public final void apply(String v) {
                        this.directory$1.elem = v;
                    }
                    {
                        this.directory$1 = directory$1;
                    }
                });
            }
        };
        if (!parser.parse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args))) return;
        DwCACreator dwcc = new DwCACreator();
        if (!"all".equalsIgnoreCase((String)resourceUid.elem)) {
            dwcc.create((String)directory.elem, (String)resourceUid.elem);
            return;
        }
        try {
            this.getDataResourceUids().foreach((Function1)new Serializable(directory, dwcc){
                public static final long serialVersionUID = 0L;
                private final ObjectRef directory$1;
                private final DwCACreator dwcc$1;

                public final void apply(String x$1) {
                    this.dwcc$1.create((String)this.directory$1.elem, x$1);
                }
                {
                    this.directory$1 = directory$1;
                    this.dwcc$1 = dwcc$1;
                }
            });
            return;
        }
        catch (Exception exception) {
            this.logger().error(exception.getMessage(), (Throwable)exception);
        }
    }

    public Regex dataResourcePattern() {
        return this.dataResourcePattern;
    }

    public Seq<String> getDataResourceUids() {
        String url = new StringBuilder().append((Object)Config$.MODULE$.biocacheServiceUrl()).append((Object)"/occurrences/search?q=*:*&facets=data_resource_uid&pageSize=0&flimit=10000").toString();
        String jsonString = Source$.MODULE$.fromURL(url, Codec$.MODULE$.fallbackSystemCodec()).getLines().mkString();
        Map json = (Map)JSON$.MODULE$.parseFull(jsonString).get();
        List results = (List)((MapLike)((List)json.get((Object)"facetResults").get()).head()).get((Object)"fieldResult").get();
        return (Seq)((TraversableLike)results.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Map<String, String> facet) {
                String fq = (String)facet.get((Object)"fq").get();
                return DwCACreator$.MODULE$.parseFq(fq);
            }
        }, List$.MODULE$.canBuildFrom())).filterNot((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$2) {
                return x$2.equals("Unknown");
            }
        });
    }

    public String parseFq(String fq) {
        String dr;
        String string = fq;
        Option option = this.dataResourcePattern().unapplySeq((Object)string);
        String string2 = !option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0 ? (dr = (String)((LinearSeqOptimized)option.get()).apply(0)) : "Unknown";
        return string2;
    }

    private DwCACreator$() {
        MODULE$ = this;
        Tool$class.$init$(this);
        this.logger = LoggerFactory.getLogger((String)"DwCACreator");
        this.dataResourcePattern = new StringOps(Predef$.MODULE$.augmentString("(?:[\"]*)?(?:[a-z_]*_uid:\")([a-z0-9]*)(?:[\"]*)?")).r();
    }
}

