/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.caches;

import au.org.ala.biocache.Config$;
import au.org.ala.biocache.model.Location;
import org.apache.commons.collections.map.LRUMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class LocationDAO$ {
    public static final LocationDAO$ MODULE$;
    private final Logger logger;
    private final String columnFamily;
    private final Object lock;
    private final LRUMap lru;
    private final String latitudeCol;
    private final String longitudeCol;

    static {
        new LocationDAO$();
    }

    public Logger logger() {
        return this.logger;
    }

    private String columnFamily() {
        return this.columnFamily;
    }

    private Object lock() {
        return this.lock;
    }

    private LRUMap lru() {
        return this.lru;
    }

    private final String latitudeCol() {
        return "lat";
    }

    private final String longitudeCol() {
        return "lon";
    }

    public Tuple2<String, scala.collection.immutable.Map<String, String>> addLayerIntersects(String latitude, String longitude, scala.collection.immutable.Map<String, String> contextual, scala.collection.immutable.Map<String, Object> environmental, boolean batch) {
        Tuple2 tuple2;
        if (latitude != null && latitude.trim().length() > 0 && longitude != null && longitude.trim().length() > 0) {
            String guid = this.getLatLongKey(latitude, longitude);
            HashMap mapBuffer = new HashMap();
            mapBuffer.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"lat"), (Object)latitude));
            mapBuffer.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"lon"), (Object)longitude));
            mapBuffer.$plus$plus$eq(contextual);
            mapBuffer.$plus$plus$eq((TraversableOnce)environmental.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple2<String, String> apply(Tuple2<String, Object> x) {
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc(x._1()), (Object)x._2().toString());
                }
            }, Map$.MODULE$.canBuildFrom()));
            if (batch) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)guid), (Object)mapBuffer.toMap(Predef$.MODULE$.conforms()));
            } else {
                Config$.MODULE$.persistenceManager().put(guid, this.columnFamily(), (scala.collection.immutable.Map<String, String>)mapBuffer.toMap(Predef$.MODULE$.conforms()), false);
                tuple2 = null;
            }
        } else {
            tuple2 = null;
        }
        return tuple2;
    }

    public boolean addLayerIntersects$default$5() {
        return false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeLocBatch(Map<String, scala.collection.immutable.Map<String, String>> batch) {
        int retries = 0;
        boolean processedOK = false;
        if (processedOK) return;
        if (retries >= 6) return;
        {
            Config$.MODULE$.persistenceManager().putBatch(this.columnFamily(), batch, false);
            return;
        }
    }

    public String getLatLongKey(String latitude, String longitude) {
        return new StringBuilder().append((Object)((Object)BoxesRunTime.boxToFloat((float)new StringOps(Predef$.MODULE$.augmentString(latitude)).toFloat())).toString().trim()).append((Object)"|").append((Object)((Object)BoxesRunTime.boxToFloat((float)new StringOps(Predef$.MODULE$.augmentString(longitude)).toFloat())).toString()).toString();
    }

    private String getLatLongKey(float latitude, float longitude) {
        return new StringBuilder().append((Object)((Object)BoxesRunTime.boxToFloat((float)latitude)).toString().trim()).append((Object)"|").append((Object)((Object)BoxesRunTime.boxToFloat((float)longitude)).toString()).toString();
    }

    private String getLatLongKey(double latitude, double longitude) {
        return new StringBuilder().append((Object)((Object)BoxesRunTime.boxToDouble((double)latitude)).toString().trim()).append((Object)"|").append((Object)((Object)BoxesRunTime.boxToDouble((double)longitude)).toString()).toString();
    }

    /*
     * WARNING - void declaration
     */
    public String storePointForSampling(String latitude, String longitude) {
        void var3_3;
        String uuid = this.getLatLongKey(latitude, longitude);
        scala.collection.immutable.Map map = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"lat"), (Object)latitude), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"lon"), (Object)longitude)}));
        Config$.MODULE$.persistenceManager().put(uuid, this.columnFamily(), (scala.collection.immutable.Map<String, String>)map, false);
        return var3_3;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<Tuple3<Location, Map<String, String>, Map<String, String>>> getSamplesForLatLon(String latitude, String longitude) {
        Option option;
        Object cachedObject;
        block10: {
            None$ none$;
            if (latitude == null || longitude == null || latitude.trim().length() == 0 || longitude.trim().length() == 0) {
                return None$.MODULE$;
            }
            String uuid = this.getLatLongKey(latitude, longitude);
            Object object = this.lock();
            synchronized (object) {
                Object object2 = this.lru().get((Object)uuid);
                // MONITOREXIT @DISABLED, blocks:[0, 2] lbl8 : MonitorExitStatement: MONITOREXIT : var5_4
                cachedObject = object2;
                if (cachedObject != null) break block10;
            }
            Option<scala.collection.immutable.Map<String, String>> map = Config$.MODULE$.persistenceManager().get(uuid, this.columnFamily());
            Option<scala.collection.immutable.Map<String, String>> option2 = map;
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                scala.collection.immutable.Map map2 = (scala.collection.immutable.Map)some.x();
                Location location = new Location();
                location.decimalLatitude_$eq(latitude);
                location.decimalLongitude_$eq(longitude);
                scala.collection.immutable.Map el = (scala.collection.immutable.Map)map2.filter((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<String, String> x) {
                        return ((String)x._1()).startsWith("el");
                    }
                });
                scala.collection.immutable.Map cl = (scala.collection.immutable.Map)map2.filter((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<String, String> x) {
                        return ((String)x._1()).startsWith("cl");
                    }
                });
                Some returnValue = new Some((Object)new Tuple3((Object)location, (Object)el, (Object)cl));
                Object object3 = this.lock();
                synchronized (object3) {
                    this.lru().put((Object)uuid, (Object)returnValue);
                    // MONITOREXIT @DISABLED, blocks:[1, 3, 8] lbl27 : MonitorExitStatement: MONITOREXIT : var16_15
                    none$ = returnValue;
                }
            } else {
                None$ none$2 = None$.MODULE$;
                Option<scala.collection.immutable.Map<String, String>> option3 = option2;
                if (none$2 != null ? !none$2.equals(option3) : option3 != null) throw new MatchError(option2);
                if (!Predef$.MODULE$.refArrayOps((Object[])Config$.MODULE$.fieldsToSample(false)).isEmpty()) {
                    this.logger().warn(new StringBuilder().append((Object)"Location lookup failed for [").append((Object)latitude).append((Object)",").append((Object)longitude).append((Object)"] - Sampling may need to be re-ran").toString());
                }
                none$ = None$.MODULE$;
            }
            option = none$;
            return option;
        }
        option = (Option)cachedObject;
        return option;
        {
            catch (Throwable throwable) {
                throw throwable;
            }
        }
        {
            catch (Throwable throwable) {
                throw throwable;
            }
        }
    }

    private LocationDAO$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger((String)"LocationDAO");
        this.columnFamily = "loc";
        this.lock = new Object();
        this.lru = new LRUMap(10000);
    }
}

