/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.registry.metadata;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import freemarker.template.Configuration;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.gbif.api.model.registry.Contact;
import org.gbif.api.model.registry.Dataset;
import org.gbif.api.model.registry.eml.temporal.DateRange;
import org.gbif.api.model.registry.eml.temporal.SingleDate;
import org.gbif.api.model.registry.eml.temporal.TemporalCoverage;
import org.gbif.api.model.registry.eml.temporal.VerbatimTimePeriod;
import org.gbif.api.model.registry.eml.temporal.VerbatimTimePeriodType;
import org.gbif.api.vocabulary.ContactType;
import org.gbif.registry.metadata.DatasetXMLWriterConfigurationProvider;
import org.gbif.registry.metadata.EMLProfileVersion;
import org.gbif.registry.metadata.contact.ContactAdapter;

@ThreadSafe
public class EMLWriter {
    private static final String TEMPLATE_PATH = "/gbif-eml-profile-template";
    private static final String EML_TEMPLATE = String.format("eml-dataset-%s.ftl", EMLProfileVersion.GBIF_1_1.getVersion());
    private final Configuration freemarkerConfig;
    private final boolean useDoiAsIdentifier;
    private final boolean omitXmlDeclaration;
    private static final EMLWriter LEGACY_METHOD_INSTANCE_NO_DOI = EMLWriter.newInstance();
    private static final EMLWriter LEGACY_METHOD_INSTANCE_WITH_DOI = EMLWriter.newInstance(true);

    private EMLWriter(Configuration cfg, boolean useDoiAsIdentifier, boolean omitXmlDeclaration) {
        this.freemarkerConfig = cfg;
        this.useDoiAsIdentifier = useDoiAsIdentifier;
        this.omitXmlDeclaration = omitXmlDeclaration;
    }

    public static EMLWriter newInstance() {
        return new EMLWriter(DatasetXMLWriterConfigurationProvider.provideFreemarker(TEMPLATE_PATH), false, false);
    }

    public static EMLWriter newInstance(boolean useDoiAsIdentifier) {
        return new EMLWriter(DatasetXMLWriterConfigurationProvider.provideFreemarker(TEMPLATE_PATH), useDoiAsIdentifier, false);
    }

    public static EMLWriter newInstance(boolean useDoiAsIdentifier, boolean omitXmlDeclaration) {
        return new EMLWriter(DatasetXMLWriterConfigurationProvider.provideFreemarker(TEMPLATE_PATH), useDoiAsIdentifier, omitXmlDeclaration);
    }

    public void writeTo(Dataset dataset, Writer writer) throws IOException {
        this.innerWrite(dataset, writer);
    }

    private void innerWrite(Dataset dataset, Writer writer) throws IOException {
        Preconditions.checkNotNull(dataset, "Dataset can't be null");
        ImmutableMap<String, Boolean> map = ImmutableMap.of("dataset", dataset, "eml", new EmlDatasetWrapper(dataset), "useDoiAsIdentifier", this.useDoiAsIdentifier, "omitXmlDeclaration", this.omitXmlDeclaration);
        try {
            this.freemarkerConfig.getTemplate(EML_TEMPLATE).process(map, writer);
        }
        catch (TemplateException e) {
            throw new IOException("Error while processing the EML Freemarker template for dataset " + dataset.getKey(), e);
        }
    }

    @Deprecated
    public static void write(Dataset dataset, Writer writer) throws IOException {
        EMLWriter.write(dataset, writer, false);
    }

    @Deprecated
    public static void write(Dataset dataset, Writer writer, boolean _useDoiAsIdentifier) throws IOException {
        Preconditions.checkNotNull(dataset, "Dataset can't be null");
        if (_useDoiAsIdentifier) {
            LEGACY_METHOD_INSTANCE_WITH_DOI.writeTo(dataset, writer);
        } else {
            LEGACY_METHOD_INSTANCE_NO_DOI.writeTo(dataset, writer);
        }
    }

    public static class EmlDatasetWrapper {
        private final Dataset dataset;
        private final ContactAdapter contactAdapter;

        public EmlDatasetWrapper(Dataset dataset) {
            this.dataset = dataset;
            this.contactAdapter = new ContactAdapter(dataset.getContacts());
        }

        public List<Contact> getAssociatedParties() {
            return this.contactAdapter.getAssociatedParties();
        }

        public Contact getResourceCreator() {
            return this.contactAdapter.getResourceCreator();
        }

        public List<Contact> getCreators() {
            return this.contactAdapter.getCreators();
        }

        public Contact getAdministrativeContact() {
            return this.contactAdapter.getAdministrativeContact();
        }

        public List<Contact> getContacts() {
            return this.contactAdapter.getContacts();
        }

        public Contact getMetadataProvider() {
            return this.contactAdapter.getFirstPreferredType(ContactType.METADATA_AUTHOR);
        }

        public List<Contact> getMetadataProviders() {
            return this.contactAdapter.getMetadataProviders();
        }

        public List<VerbatimTimePeriod> getFormationPeriods() {
            return this.getTimePeriods(VerbatimTimePeriodType.FORMATION_PERIOD);
        }

        public List<VerbatimTimePeriod> getLivingTimePeriods() {
            return this.getTimePeriods(VerbatimTimePeriodType.LIVING_TIME_PERIOD);
        }

        private List<VerbatimTimePeriod> getTimePeriods(VerbatimTimePeriodType type) {
            ArrayList<VerbatimTimePeriod> periods = Lists.newArrayList();
            for (TemporalCoverage tc : this.dataset.getTemporalCoverages()) {
                VerbatimTimePeriod tp;
                if (!(tc instanceof VerbatimTimePeriod) || !type.equals((Object)(tp = (VerbatimTimePeriod)tc).getType())) continue;
                periods.add(tp);
            }
            return periods;
        }

        public List<TemporalCoverage> getSingleDateAndDateRangeCoverages() {
            ArrayList<TemporalCoverage> periods = Lists.newArrayList();
            for (TemporalCoverage tc : this.dataset.getTemporalCoverages()) {
                if (!(tc instanceof DateRange) && !(tc instanceof SingleDate)) continue;
                periods.add(tc);
            }
            return periods;
        }
    }
}

