/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.framework.recipes.leader;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.Closeable;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.leader.LeaderSelectorListener;
import org.apache.curator.framework.recipes.leader.Participant;
import org.apache.curator.framework.recipes.locks.InterProcessMutex;
import org.apache.curator.utils.ThreadUtils;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeaderSelector
implements Closeable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final CuratorFramework client;
    private final LeaderSelectorListener listener;
    private final ExecutorService executorService;
    private final Executor executor;
    private final InterProcessMutex mutex;
    private final AtomicReference<State> state = new AtomicReference<State>(State.LATENT);
    private final AtomicBoolean autoRequeue = new AtomicBoolean(false);
    private volatile boolean hasLeadership;
    private volatile String id = "";
    private boolean isQueued = false;
    private static final ThreadFactory defaultThreadFactory = ThreadUtils.newThreadFactory((String)"LeaderSelector");

    public LeaderSelector(CuratorFramework client, String leaderPath, LeaderSelectorListener listener) {
        this(client, leaderPath, defaultThreadFactory, (Executor)MoreExecutors.sameThreadExecutor(), listener);
    }

    public LeaderSelector(CuratorFramework client, String leaderPath, ThreadFactory threadFactory, Executor executor, LeaderSelectorListener listener) {
        Preconditions.checkNotNull((Object)client, (Object)"client cannot be null");
        Preconditions.checkNotNull((Object)leaderPath, (Object)"leaderPath cannot be null");
        Preconditions.checkNotNull((Object)listener, (Object)"listener cannot be null");
        this.client = client;
        this.listener = listener;
        this.executor = executor;
        this.hasLeadership = false;
        this.executorService = Executors.newFixedThreadPool(1, threadFactory);
        this.mutex = new InterProcessMutex(client, leaderPath){

            @Override
            protected byte[] getLockNodeBytes() {
                return LeaderSelector.this.id.length() > 0 ? LeaderSelector.getIdBytes(LeaderSelector.this.id) : null;
            }
        };
    }

    static byte[] getIdBytes(String id) {
        try {
            return id.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
    }

    public void autoRequeue() {
        this.autoRequeue.set(true);
    }

    public void setId(String id) {
        Preconditions.checkNotNull((Object)id, (Object)"id cannot be null");
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void start() {
        Preconditions.checkState((boolean)this.state.compareAndSet(State.LATENT, State.STARTED), (Object)"Cannot be started more than once");
        Preconditions.checkState((!this.executorService.isShutdown() ? 1 : 0) != 0, (Object)"Already started");
        Preconditions.checkState((!this.hasLeadership ? 1 : 0) != 0, (Object)"Already has leadership");
        this.client.getConnectionStateListenable().addListener((Object)this.listener);
        this.requeue();
    }

    public synchronized boolean requeue() {
        Preconditions.checkState((this.state.get() == State.STARTED ? 1 : 0) != 0, (Object)"close() has already been called");
        if (!this.isQueued) {
            this.isQueued = true;
            this.executorService.submit(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    LeaderSelector.this.doWorkLoop();
                    return null;
                }
            });
            return true;
        }
        return false;
    }

    @Override
    public void close() {
        Preconditions.checkState((boolean)this.state.compareAndSet(State.STARTED, State.CLOSED), (Object)"Already closed or has not been started");
        this.client.getConnectionStateListenable().removeListener((Object)this.listener);
        this.executorService.shutdownNow();
    }

    public Collection<Participant> getParticipants() throws Exception {
        Collection<String> participantNodes = this.mutex.getParticipantNodes();
        return LeaderSelector.getParticipants(this.client, participantNodes);
    }

    static Collection<Participant> getParticipants(CuratorFramework client, Collection<String> participantNodes) throws Exception {
        ImmutableList.Builder builder = ImmutableList.builder();
        boolean isLeader = true;
        for (String path : participantNodes) {
            try {
                Participant participant = LeaderSelector.participantForPath(client, path, isLeader);
                builder.add((Object)participant);
            }
            catch (KeeperException.NoNodeException ignore) {
                // empty catch block
            }
            isLeader = false;
        }
        return builder.build();
    }

    public Participant getLeader() throws Exception {
        Collection<String> participantNodes = this.mutex.getParticipantNodes();
        return LeaderSelector.getLeader(this.client, participantNodes);
    }

    static Participant getLeader(CuratorFramework client, Collection<String> participantNodes) throws Exception {
        if (participantNodes.size() > 0) {
            return LeaderSelector.participantForPath(client, participantNodes.iterator().next(), true);
        }
        return new Participant();
    }

    public boolean hasLeadership() {
        return this.hasLeadership;
    }

    private static Participant participantForPath(CuratorFramework client, String path, boolean markAsLeader) throws Exception {
        byte[] bytes = (byte[])client.getData().forPath(path);
        String thisId = new String(bytes, "UTF-8");
        return new Participant(thisId, markAsLeader);
    }

    @VisibleForTesting
    void doWork() throws Exception {
        this.hasLeadership = false;
        try {
            this.mutex.acquire();
            this.hasLeadership = true;
            this.executor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        LeaderSelector.this.listener.takeLeadership(LeaderSelector.this.client);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    catch (Throwable e) {
                        LeaderSelector.this.log.error("The leader threw an exception", e);
                    }
                    finally {
                        LeaderSelector.this.clearIsQueued();
                    }
                }
            });
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            this.log.error("mutex.acquire() threw an exception", (Throwable)e);
            throw e;
        }
        finally {
            this.hasLeadership = false;
            try {
                this.mutex.release();
            }
            catch (Exception ignore) {}
        }
    }

    private void doWorkLoop() throws Exception {
        do {
            Throwable exception = null;
            try {
                this.doWork();
            }
            catch (KeeperException.ConnectionLossException e) {
                exception = e;
            }
            catch (KeeperException.SessionExpiredException e) {
                exception = e;
            }
            catch (InterruptedException ignore) {
                Thread.currentThread().interrupt();
                break;
            }
            if (exception == null || this.autoRequeue.get()) continue;
            throw exception;
        } while (this.autoRequeue.get() && this.state.get() == State.STARTED && !Thread.currentThread().isInterrupted());
    }

    private synchronized void clearIsQueued() {
        this.isQueued = false;
    }

    private static enum State {
        LATENT,
        STARTED,
        CLOSED;

    }
}

