/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata;

import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.geotools.metadata.AbstractMetadata;
import org.geotools.metadata.MetadataStandard;
import org.geotools.metadata.PropertyAccessor;
import org.geotools.metadata.PropertyMap;
import org.geotools.resources.Classes;
import org.geotools.resources.OptionalDependencies;
import org.geotools.util.Utilities;
import org.opengis.util.CodeList;
import org.opengis.util.InternationalString;

final class PropertyTree {
    private static final int PRECISION = 12;
    private final MetadataStandard standard;
    private final Locale locale;
    private transient NumberFormat numberFormat;
    private transient DateFormat dateFormat;

    public PropertyTree(MetadataStandard standard) {
        this(standard, Locale.getDefault());
    }

    public PropertyTree(MetadataStandard standard, Locale locale) {
        this.standard = standard;
        this.locale = locale;
    }

    public MutableTreeNode asTree(Object metadata) {
        String name = Classes.getShortName(this.standard.getInterface(metadata.getClass()));
        DefaultMutableTreeNode root = OptionalDependencies.createTreeNode(this.localize(name), metadata, true);
        this.append(root, metadata);
        return root;
    }

    private void append(DefaultMutableTreeNode branch, Object value) {
        PropertyAccessor accessor;
        if (value instanceof Map) {
            this.appendMap(branch, (Map)value);
            return;
        }
        if (value instanceof AbstractMetadata) {
            this.appendMap(branch, ((AbstractMetadata)value).asMap());
            return;
        }
        if (value != null && (accessor = this.standard.getAccessorOptional(value.getClass())) != null) {
            this.appendMap(branch, new PropertyMap(value, accessor));
            return;
        }
        if (value instanceof Collection) {
            for (Object element : (Collection)value) {
                if (PropertyAccessor.isEmpty(element)) continue;
                this.append(branch, element);
            }
            return;
        }
        String asText = value instanceof CodeList ? this.localize((CodeList)value) : (value instanceof Date ? this.format((Date)value) : (value instanceof Number ? this.format((Number)value) : (value instanceof InternationalString ? ((InternationalString)value).toString(this.locale) : String.valueOf(value))));
        branch.add(OptionalDependencies.createTreeNode(asText, value, false));
    }

    private void appendMap(DefaultMutableTreeNode branch, Map asMap) {
        for (Map.Entry entry : asMap.entrySet()) {
            Object value = entry.getValue();
            if (PropertyAccessor.isEmpty(value)) continue;
            String name = this.localize((String)entry.getKey());
            DefaultMutableTreeNode child = OptionalDependencies.createTreeNode(name, value, true);
            this.append(child, value);
            branch.add(child);
        }
    }

    private String format(Number value) {
        if (this.numberFormat == null) {
            this.numberFormat = NumberFormat.getNumberInstance(this.locale);
            this.numberFormat.setMinimumFractionDigits(0);
        }
        int precision = 0;
        if (!Classes.isInteger(value.getClass())) {
            precision = 12;
            double v = Math.abs(value.doubleValue());
            if (v > 0.0) {
                int digits = (int)Math.log10(v);
                if (Math.abs(digits) >= 12) {
                    return value.toString();
                }
                if (digits >= 0) {
                    precision -= digits;
                }
                precision = Math.max(0, 12 - precision);
            }
        }
        this.numberFormat.setMaximumFractionDigits(precision);
        return this.numberFormat.format(value);
    }

    private String format(Date value) {
        if (this.dateFormat == null) {
            this.dateFormat = DateFormat.getDateTimeInstance(1, 1, this.locale);
        }
        return this.dateFormat.format(value);
    }

    private String localize(String name) {
        int length = (name = name.trim()).length();
        if (length != 0) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(Character.toUpperCase(name.charAt(0)));
            boolean previousIsUpper = true;
            int base = 1;
            for (int i = 1; i < length; ++i) {
                boolean currentIsUpper = Character.isUpperCase(name.charAt(i));
                if (currentIsUpper != previousIsUpper) {
                    int split = i;
                    if (previousIsUpper) {
                        --split;
                    }
                    if (split > base) {
                        buffer.append(name.substring(base, split)).append(' ');
                        base = split;
                    }
                }
                previousIsUpper = currentIsUpper;
            }
            String candidate = buffer.append(name.substring(base)).toString();
            if (!candidate.equals(name)) {
                name = candidate;
            }
        }
        return name;
    }

    private String localize(CodeList code) {
        return code.name().trim().replace('_', ' ').toLowerCase(this.locale);
    }

    public static String toString(TreeNode node) {
        StringBuilder buffer = new StringBuilder();
        PropertyTree.toString(node, buffer, 0, System.getProperty("line.separator", "\n"));
        return buffer.toString();
    }

    private static void toString(TreeNode node, StringBuilder buffer, int indent, String lineSeparator) {
        TreeNode child;
        int count = node.getChildCount();
        if (count == 0) {
            if (node.isLeaf()) {
                buffer.append(Utilities.spaces(indent)).append(node).append(lineSeparator);
            }
            return;
        }
        buffer.append(Utilities.spaces(indent)).append(node).append(':');
        if (count == 1 && (child = node.getChildAt(0)).isLeaf()) {
            buffer.append(' ').append(child).append(lineSeparator);
            return;
        }
        for (int i = 0; i < count; ++i) {
            TreeNode child2 = node.getChildAt(i);
            if (i == 0) {
                buffer.append(lineSeparator);
            }
            PropertyTree.toString(child2, buffer, indent + 2, lineSeparator);
        }
    }
}

