/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ecat.voc;

import org.gbif.ecat.voc.KnownTerm;
import org.gbif.ecat.voc.TermType;

public enum TaxonomicStatus implements KnownTerm
{
    Accepted,
    Synonym,
    Heterotypic_Synonym,
    Homotypic_Synonym,
    Proparte_Synonym,
    Misapplied,
    IntermediateRankSynonym,
    DeterminationSynonym,
    Doubtful;

    private static final int ID_BASE = 9000;

    public boolean isSynonym() {
        return !this.equals(Accepted) && !this.equals(Doubtful);
    }

    @Override
    public int termID() {
        return 9000 + this.ordinal();
    }

    @Override
    public TermType type() {
        return TermType.TAXONOMIC_STATUS;
    }

    @Deprecated
    public static TaxonomicStatus valueOf(int termID) {
        return TaxonomicStatus.valueOfTermID(termID);
    }

    public static TaxonomicStatus valueOfTermID(Integer termID) {
        for (TaxonomicStatus term : TaxonomicStatus.values()) {
            if (termID == null || term.termID() != termID.intValue()) continue;
            return term;
        }
        return null;
    }

    public static TaxonomicStatus fromString(String x) {
        if (x == null) {
            return null;
        }
        if ((x = x.toLowerCase().trim()).isEmpty()) {
            return null;
        }
        for (TaxonomicStatus term : TaxonomicStatus.values()) {
            if (!term.toString().toLowerCase().equals(x)) continue;
            return term;
        }
        if (x.startsWith("acc")) {
            return Accepted;
        }
        if (x.startsWith("syn")) {
            return Synonym;
        }
        return null;
    }
}

