/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ecat.voc;

import org.gbif.ecat.voc.KnownTerm;
import org.gbif.ecat.voc.TermType;

public enum NomenclaturalCode implements KnownTerm
{
    Botanical("ICBN"),
    Zoological("ICZN"),
    Virus("ICVCN"),
    Bacterial("ICNB"),
    Cultivars("ICNCP");

    public final String acronym;
    public static final int ID_BASE = 11000;

    private NomenclaturalCode(String acronym) {
        this.acronym = acronym;
    }

    @Override
    public int termID() {
        return 11000 + this.ordinal() * 10;
    }

    @Override
    public TermType type() {
        return TermType.NOMENCLATURAL_CODE;
    }

    @Deprecated
    public static NomenclaturalCode valueOf(int termID) {
        return NomenclaturalCode.valueOfTermID(termID);
    }

    public static NomenclaturalCode valueOfTermID(Integer termID) {
        for (NomenclaturalCode term : NomenclaturalCode.values()) {
            if (termID == null || term.termID() != termID.intValue()) continue;
            return term;
        }
        return null;
    }

    public static NomenclaturalCode valueOfOrdinal(Integer ordinal) {
        for (NomenclaturalCode term : NomenclaturalCode.values()) {
            if (ordinal == null || term.ordinal() != ordinal.intValue()) continue;
            return term;
        }
        return null;
    }

    public static NomenclaturalCode fromString(String code) {
        if (code != null && code.length() > 2) {
            for (NomenclaturalCode term : NomenclaturalCode.values()) {
                if (term.name().toLowerCase().startsWith(code.toLowerCase())) {
                    return term;
                }
                if (!term.acronym.toLowerCase().equalsIgnoreCase(code.toLowerCase())) continue;
                return term;
            }
        }
        return null;
    }
}

