/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.crawler.protocol.tapir;

import com.google.common.base.Optional;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.codehaus.stax2.XMLStreamReader2;
import org.gbif.crawler.exception.ProtocolException;
import org.gbif.crawler.protocol.AbstractResponseHandler;

@NotThreadSafe
public class TapirResponseHandler
extends AbstractResponseHandler {
    private static final String CONTENT_ELEMENT = "search";
    private static final String INFO_ELEMENT = "summary";
    private boolean insideContent;
    private boolean seenContent;

    @Override
    protected boolean shouldHash(XMLStreamReader2 reader) {
        boolean infoElement;
        if (TapirResponseHandler.isElement((XMLStreamReader)reader, CONTENT_ELEMENT, true)) {
            this.insideContent = true;
            return false;
        }
        boolean bl = infoElement = TapirResponseHandler.isElement((XMLStreamReader)reader, INFO_ELEMENT, true) || TapirResponseHandler.isElement((XMLStreamReader)reader, INFO_ELEMENT, false);
        if (this.insideContent && !infoElement && reader.getEventType() == 1) {
            this.seenContent = true;
        }
        if (TapirResponseHandler.isElement((XMLStreamReader)reader, CONTENT_ELEMENT, false)) {
            this.insideContent = false;
        }
        return this.insideContent && this.seenContent && !infoElement;
    }

    @Override
    protected void initialize() {
        this.insideContent = false;
        this.seenContent = false;
    }

    @Override
    protected void process(XMLStreamReader2 reader) throws XMLStreamException, ProtocolException {
        if (TapirResponseHandler.isElement((XMLStreamReader)reader, INFO_ELEMENT, true)) {
            int index = reader.getAttributeIndex(null, "totalReturned");
            if (index == -1) {
                this.setRecordCount((Optional<Integer>)Optional.absent());
            } else {
                this.setRecordCount((Optional<Integer>)Optional.of((Object)reader.getAttributeAsInt(index)));
            }
            if (reader.getAttributeIndex(null, "next") == -1) {
                this.setEndOfRecords((Optional<Boolean>)Optional.absent());
            } else {
                this.setEndOfRecords((Optional<Boolean>)Optional.of((Object)false));
            }
        }
    }
}

