/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.crawler.protocol.digir;

import com.google.common.base.Optional;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.codehaus.stax2.XMLStreamReader2;
import org.gbif.crawler.exception.FatalCrawlException;
import org.gbif.crawler.protocol.AbstractResponseHandler;

@NotThreadSafe
public class DigirResponseHandler
extends AbstractResponseHandler {
    private static final String CONTENT_ELEMENT = "content";
    private static final String INFO_ELEMENT = "diagnostic";
    private static final String DIAGNOSITC_ELEMENT_ATTRIBUTE_NAME = "code";
    private static final String RESOURCE_NOT_FOUND = "RESOURCE_NOT_FOUND";
    private static final String RECORD_COUNT = "RECORD_COUNT";
    private static final String END_OF_RECORDS = "END_OF_RECORDS";
    private boolean insideContent;
    private boolean seenContent;

    @Override
    protected boolean shouldHash(XMLStreamReader2 reader) {
        if (DigirResponseHandler.isElement((XMLStreamReader)reader, CONTENT_ELEMENT, true)) {
            this.insideContent = true;
            return false;
        }
        if (this.insideContent && reader.getEventType() == 1) {
            this.seenContent = true;
        }
        if (DigirResponseHandler.isElement((XMLStreamReader)reader, CONTENT_ELEMENT, false)) {
            this.insideContent = false;
        }
        return this.insideContent && this.seenContent;
    }

    @Override
    protected void initialize() {
        this.insideContent = false;
        this.seenContent = false;
    }

    @Override
    protected void process(XMLStreamReader2 reader) throws XMLStreamException, FatalCrawlException {
        if (DigirResponseHandler.isElement((XMLStreamReader)reader, INFO_ELEMENT, true)) {
            if (reader.getAttributeValue(null, DIAGNOSITC_ELEMENT_ATTRIBUTE_NAME).equals(RECORD_COUNT)) {
                this.setRecordCount((Optional<Integer>)Optional.of((Object)reader.getElementAsInt()));
            } else if (reader.getAttributeValue(null, DIAGNOSITC_ELEMENT_ATTRIBUTE_NAME).equals(END_OF_RECORDS)) {
                this.setEndOfRecords((Optional<Boolean>)Optional.of((Object)reader.getElementAsBoolean()));
            } else if (reader.getAttributeValue(null, DIAGNOSITC_ELEMENT_ATTRIBUTE_NAME).equals(RESOURCE_NOT_FOUND)) {
                throw new FatalCrawlException("Requested resource could not be found");
            }
        }
    }
}

