/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.crawler.protocol.biocase;

import com.google.common.base.Optional;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.codehaus.stax2.XMLStreamReader2;
import org.gbif.crawler.exception.ProtocolException;
import org.gbif.crawler.protocol.AbstractResponseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class BiocaseResponseHandler
extends AbstractResponseHandler {
    private static final Logger LOG = LoggerFactory.getLogger(BiocaseResponseHandler.class);
    private static final String CONTENT_ELEMENT = "content";
    private boolean insideContent;
    private boolean seenContent;

    @Override
    protected boolean shouldHash(XMLStreamReader2 reader) {
        if (BiocaseResponseHandler.isElement((XMLStreamReader)reader, CONTENT_ELEMENT, true)) {
            this.insideContent = true;
            return false;
        }
        if (this.insideContent && reader.getEventType() == 1) {
            this.seenContent = true;
        }
        if (BiocaseResponseHandler.isElement((XMLStreamReader)reader, CONTENT_ELEMENT, false)) {
            this.insideContent = false;
        }
        return this.insideContent && this.seenContent;
    }

    @Override
    protected void initialize() {
        this.insideContent = false;
        this.seenContent = false;
    }

    @Override
    protected void process(XMLStreamReader2 reader) throws XMLStreamException, ProtocolException {
        if (reader.getEventType() == 1 && reader.getLocalName().equals(CONTENT_ELEMENT)) {
            Optional<Integer> recordStart = this.getAttribute(reader, "recordStart");
            Optional<Integer> recordCount = this.getAttribute(reader, "recordCount");
            Optional<Integer> recordDropped = this.getAttribute(reader, "recordDropped");
            Optional<Integer> totalHits = this.getAttribute(reader, "totalSearchHits");
            this.setRecordCount(recordCount);
            if (recordCount.isPresent() && recordStart.isPresent() && recordDropped.isPresent() && totalHits.isPresent()) {
                this.setEndOfRecords((Optional<Boolean>)Optional.of((Object)((Integer)recordCount.get() + (Integer)recordStart.get() + (Integer)recordDropped.get() >= (Integer)totalHits.get() ? 1 : 0)));
            }
            LOG.debug("Found content element. [{}] records, [{}] records dropped, [{}] record start, [{}] total search hits", new Object[]{recordCount, recordDropped, recordStart, totalHits});
        }
    }

    private Optional<Integer> getAttribute(XMLStreamReader2 reader, String attribute) throws XMLStreamException {
        int index = reader.getAttributeIndex(null, attribute);
        if (index == -1) {
            return Optional.absent();
        }
        return Optional.of((Object)reader.getAttributeAsInt(index));
    }
}

