/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.rest.schema;

import org.apache.solr.common.SolrException;
import org.apache.solr.rest.BaseSolrResource;
import org.apache.solr.rest.GETable;
import org.restlet.representation.Representation;
import org.restlet.resource.ResourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaNameResource
extends BaseSolrResource
implements GETable {
    private static final Logger log = LoggerFactory.getLogger(SchemaNameResource.class);

    @Override
    public void doInit() throws ResourceException {
        super.doInit();
    }

    @Override
    public Representation get() {
        try {
            String schemaName = this.getSchema().getSchemaName();
            if (null == schemaName) {
                String message = "Schema has no name";
                throw new SolrException(SolrException.ErrorCode.NOT_FOUND, "Schema has no name");
            }
            this.getSolrResponse().add("name", schemaName);
        }
        catch (Exception e) {
            this.getSolrResponse().setException(e);
        }
        this.handlePostExecution(log);
        return new BaseSolrResource.SolrOutputRepresentation();
    }
}

