/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.html;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import org.owasp.html.AttributePolicy;
import org.owasp.html.CssGrammar;
import org.owasp.html.CssSchema;
import org.owasp.html.Strings;
import org.owasp.html.TCB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TCB
final class StylingPolicy
implements AttributePolicy {
    final CssSchema cssSchema;
    final Function<String, String> urlRewriter;

    StylingPolicy(CssSchema cssSchema, Function<String, String> urlRewriter) {
        this.cssSchema = cssSchema;
        this.urlRewriter = urlRewriter;
    }

    @Override
    @Nullable
    public String apply(String elementName, String attributeName, String value) {
        return value != null ? this.sanitizeCssProperties(value) : null;
    }

    @VisibleForTesting
    String sanitizeCssProperties(String style) {
        final StringBuilder sanitizedCss = new StringBuilder();
        CssGrammar.parsePropertyGroup(style, new CssGrammar.PropertyHandler(){
            CssSchema.Property cssProperty = CssSchema.DISALLOWED;
            List<CssSchema.Property> cssProperties = null;
            int propertyStart = 0;
            boolean hasTokens;
            boolean inQuotedIdents;
            private static final int IDENT_TO_STRING = 72;

            private void emitToken(String token) {
                this.closeQuotedIdents();
                if (this.hasTokens) {
                    sanitizedCss.append(' ');
                }
                sanitizedCss.append(token);
                this.hasTokens = true;
            }

            private void closeQuotedIdents() {
                if (this.inQuotedIdents) {
                    sanitizedCss.append('\'');
                    this.inQuotedIdents = false;
                }
            }

            private void sanitizeAndAppendUrl(String urlContent) {
                String rewrittenUrl;
                if (urlContent.length() < 1024 && (rewrittenUrl = (String)StylingPolicy.this.urlRewriter.apply((Object)urlContent)) != null && !rewrittenUrl.isEmpty()) {
                    if (this.hasTokens) {
                        sanitizedCss.append(' ');
                    }
                    sanitizedCss.append("url('").append(rewrittenUrl).append("')");
                    this.hasTokens = true;
                }
            }

            public void url(String token) {
                this.closeQuotedIdents();
                if (this.cssProperty != null && (this.cssProperty.bits & 0x10) != 0) {
                    String urlContent = CssGrammar.cssContent(Strings.stripHtmlSpaces(token.substring(4, token.length() - 1)));
                    this.sanitizeAndAppendUrl(urlContent);
                }
            }

            public void startProperty(String propertyName) {
                if (this.cssProperties != null) {
                    this.cssProperties.clear();
                }
                this.cssProperty = StylingPolicy.this.cssSchema.forKey(propertyName);
                this.hasTokens = false;
                this.propertyStart = sanitizedCss.length();
                if (sanitizedCss.length() != 0) {
                    sanitizedCss.append(';');
                }
                sanitizedCss.append(propertyName).append(':');
            }

            public void startFunction(String uncanonToken) {
                this.closeQuotedIdents();
                if (this.cssProperties == null) {
                    this.cssProperties = Lists.newArrayList();
                }
                this.cssProperties.add(this.cssProperty);
                String token = Strings.toLowerCase(uncanonToken);
                String key = (String)this.cssProperty.fnKeys.get((Object)token);
                CssSchema.Property property = this.cssProperty = key != null ? StylingPolicy.this.cssSchema.forKey(key) : CssSchema.DISALLOWED;
                if (this.cssProperty != CssSchema.DISALLOWED) {
                    this.emitToken(token);
                }
            }

            public void quotedString(String token) {
                this.closeQuotedIdents();
                int meaning = this.cssProperty.bits & 0x50;
                if ((meaning & meaning - 1) == 0) {
                    if (meaning == 64 && token.length() > 2 && StylingPolicy.isAlphanumericOrSpace(token, 1, token.length() - 1)) {
                        this.emitToken(Strings.toLowerCase(token));
                    } else if (meaning == 16) {
                        this.sanitizeAndAppendUrl(CssGrammar.cssContent(token));
                    }
                }
            }

            public void quantity(String token) {
                int test;
                int n = test = token.startsWith("-") ? 4 : 1;
                if ((this.cssProperty.bits & test) != 0 || this.cssProperty.literals.contains((Object)token)) {
                    this.emitToken(token);
                }
            }

            public void punctuation(String token) {
                this.closeQuotedIdents();
                if (this.cssProperty.literals.contains((Object)token)) {
                    this.emitToken(token);
                }
            }

            public void identifier(String uncanonToken) {
                String token = Strings.toLowerCase(uncanonToken);
                if (this.cssProperty.literals.contains((Object)token)) {
                    this.emitToken(token);
                } else if ((this.cssProperty.bits & 0x48) == 72) {
                    if (!this.inQuotedIdents) {
                        this.inQuotedIdents = true;
                        if (this.hasTokens) {
                            sanitizedCss.append(' ');
                        }
                        sanitizedCss.append('\'');
                        this.hasTokens = true;
                    } else {
                        sanitizedCss.append(' ');
                    }
                    sanitizedCss.append(Strings.toLowerCase(token));
                }
            }

            public void hash(String token) {
                this.closeQuotedIdents();
                if ((this.cssProperty.bits & 2) != 0) {
                    this.emitToken(Strings.toLowerCase(token));
                }
            }

            public void endProperty() {
                if (!this.hasTokens) {
                    sanitizedCss.setLength(this.propertyStart);
                } else {
                    this.closeQuotedIdents();
                }
            }

            public void endFunction(String token) {
                if (this.cssProperty != CssSchema.DISALLOWED) {
                    this.emitToken(")");
                }
                this.cssProperty = this.cssProperties.remove(this.cssProperties.size() - 1);
            }
        });
        return sanitizedCss.length() == 0 ? null : sanitizedCss.toString();
    }

    static boolean isAlphanumericOrSpace(String token, int start, int end) {
        for (int i = start; i < end; ++i) {
            int chLower;
            char ch = token.charAt(i);
            if (!(ch <= ' ' ? ch != '\t' && ch != ' ' : !(48 <= (chLower = ch | 0x20) && chLower <= 57 || 97 <= chLower && chLower <= 122))) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        return o != null && this.getClass() == o.getClass() && this.cssSchema.equals(((StylingPolicy)o).cssSchema);
    }

    public int hashCode() {
        return this.cssSchema.hashCode();
    }
}

