/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import com.vividsolutions.jts.geom.Point;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureEvent;
import org.geotools.data.FeatureListener;
import org.geotools.data.FeatureReader;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.data.store.ContentFeatureStore;
import org.geotools.data.store.ContentState;
import org.geotools.feature.CollectionEvent;
import org.geotools.feature.CollectionListener;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.SortBy;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.identity.FeatureId;
import org.opengis.util.ProgressListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentFeatureCollection
implements SimpleFeatureCollection {
    protected ContentFeatureSource featureSource;
    protected Query query;
    protected SimpleFeatureType featureType;
    protected ContentState state;
    protected List<CollectionListener> listeners = new ArrayList<CollectionListener>(2);
    protected final Set open = new HashSet();
    FeatureListener listener = new FeatureListener(){

        public void changed(FeatureEvent featureEvent) {
            if (ContentFeatureCollection.this.listeners.isEmpty()) {
                return;
            }
            ContentFeatureCollection collection = ContentFeatureCollection.this;
            CollectionEvent event = new CollectionEvent(collection, featureEvent);
            CollectionListener[] notify = ContentFeatureCollection.this.listeners.toArray(new CollectionListener[ContentFeatureCollection.this.listeners.size()]);
            for (int i = 0; i < notify.length; ++i) {
                CollectionListener listener = notify[i];
                try {
                    listener.collectionChanged(event);
                    continue;
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
        }
    };

    protected ContentFeatureCollection(ContentFeatureSource featureSource, Query query) {
        this.featureSource = featureSource;
        this.query = query;
        this.featureType = query.getPropertyNames() != Query.ALL_NAMES ? SimpleFeatureTypeBuilder.retype(featureSource.getSchema(), query.getPropertyNames()) : featureSource.getSchema();
    }

    @Override
    public SimpleFeatureType getSchema() {
        return this.featureType;
    }

    @Override
    public void accepts(FeatureVisitor visitor, ProgressListener progress) throws IOException {
        this.featureSource.accepts(this.query, visitor, progress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(CollectionListener listener) {
        List<CollectionListener> list = this.listeners;
        synchronized (list) {
            if (this.listeners.size() == 0) {
                this.featureSource.addFeatureListener(this.listener);
            }
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(CollectionListener listener) {
        List<CollectionListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
            if (this.listeners.size() == 0) {
                this.featureSource.removeFeatureListener(this.listener);
            }
        }
    }

    @Override
    public SimpleFeatureIterator features() {
        try {
            return new WrappingFeatureIterator(this.featureSource.getReader(this.query));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close(FeatureIterator<SimpleFeature> iterator) {
        iterator.close();
    }

    @Override
    public Iterator iterator() {
        try {
            return new WrappingIterator(this.featureSource.getReader(this.query));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close(Iterator close) {
        try {
            ((WrappingIterator)close).delegate.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ReferencedEnvelope getBounds() {
        FeatureReader<SimpleFeatureType, SimpleFeature> reader = null;
        try {
            ReferencedEnvelope referencedEnvelope;
            ReferencedEnvelope result = this.featureSource.getBounds(this.query);
            if (result != null) {
                ReferencedEnvelope referencedEnvelope2 = result;
                return referencedEnvelope2;
            }
            Query q = new Query(this.query);
            ArrayList<String> geometries = new ArrayList<String>();
            for (AttributeDescriptor ad : this.getSchema().getAttributeDescriptors()) {
                if (!(ad instanceof GeometryDescriptor)) continue;
                geometries.add(ad.getLocalName());
            }
            if (geometries.size() == 0) {
                Object i$ = new ReferencedEnvelope();
                return i$;
            }
            q.setPropertyNames(geometries);
            reader = this.featureSource.getReader(q);
            while (reader.hasNext()) {
                SimpleFeature f = reader.next();
                ReferencedEnvelope featureBounds = ReferencedEnvelope.reference(f.getBounds());
                if (result == null) {
                    result = featureBounds;
                    continue;
                }
                if (featureBounds == null) continue;
                result.expandToInclude(featureBounds);
            }
            if (result != null) {
                referencedEnvelope = result;
                return referencedEnvelope;
            }
            referencedEnvelope = new ReferencedEnvelope(this.getSchema().getCoordinateReferenceSystem());
            return referencedEnvelope;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    @Override
    public int size() {
        FeatureReader<SimpleFeatureType, SimpleFeature> fr = null;
        try {
            int size = this.featureSource.getCount(this.query);
            if (size >= 0) {
                int n = size;
                return n;
            }
            AttributeDescriptor chosen = null;
            for (AttributeDescriptor ad : this.getSchema().getAttributeDescriptors()) {
                if (chosen != null && this.size(ad) >= this.size(chosen)) continue;
                chosen = ad;
            }
            Query q = new Query(this.query);
            if (chosen != null) {
                q.setPropertyNames(Collections.singletonList(chosen.getLocalName()));
            }
            fr = this.featureSource.getReader(q);
            int count = 0;
            while (fr.hasNext()) {
                fr.next();
                ++count;
            }
            int n = count;
            return n;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    int size(AttributeDescriptor ad) {
        Class binding = ad.getType().getBinding();
        if (binding.isPrimitive() || Number.class.isAssignableFrom(binding) || Date.class.isAssignableFrom(binding)) {
            return 4;
        }
        if (binding.equals(String.class)) {
            int fieldLen = FeatureTypes.getFieldLength((PropertyDescriptor)ad);
            if (fieldLen > 0) {
                return fieldLen * 2;
            }
            return Integer.MAX_VALUE;
        }
        if (Point.class.isAssignableFrom(binding)) {
            return 12;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean add(SimpleFeature o) {
        return this.addAll(Collections.singletonList(o));
    }

    ContentFeatureStore ensureFeatureStore() {
        if (this.featureSource instanceof ContentFeatureStore) {
            return (ContentFeatureStore)this.featureSource;
        }
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public boolean addAll(Collection c) {
        ContentFeatureStore featureStore = this.ensureFeatureStore();
        try {
            List<FeatureId> ids = featureStore.addFeatures(c);
            return ids.size() == c.size();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean addAll(FeatureCollection c) {
        ContentFeatureStore featureStore = this.ensureFeatureStore();
        try {
            List<FeatureId> ids = featureStore.addFeatures(c);
            return ids.size() == c.size();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void clear() {
        ContentFeatureStore featureStore = this.ensureFeatureStore();
        try {
            featureStore.removeFeatures(this.query.getFilter());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void purge() {
    }

    public SimpleFeatureCollection sort(SortBy order) {
        return this.sort((org.opengis.filter.sort.SortBy)order);
    }

    @Override
    public SimpleFeatureCollection sort(org.opengis.filter.sort.SortBy sort) {
        Query query = new DefaultQuery();
        query.setSortBy(new org.opengis.filter.sort.SortBy[]{sort});
        query = DataUtilities.mixQueries(this.query, query, null);
        return new ContentFeatureCollection(this.featureSource, query);
    }

    @Override
    public SimpleFeatureCollection subCollection(Filter filter) {
        Query query = new DefaultQuery();
        query.setFilter(filter);
        query = DataUtilities.mixQueries(this.query, query, null);
        return new ContentFeatureCollection(this.featureSource, query);
    }

    @Override
    public boolean contains(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray(Object[] array) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getID() {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WrappingIterator
    implements Iterator {
        FeatureReader<SimpleFeatureType, SimpleFeature> delegate;

        public WrappingIterator(FeatureReader<SimpleFeatureType, SimpleFeature> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            try {
                return this.delegate.hasNext();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public Object next() {
            try {
                return this.delegate.next();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WrappingFeatureIterator
    implements SimpleFeatureIterator {
        FeatureReader<SimpleFeatureType, SimpleFeature> delegate;

        public WrappingFeatureIterator(FeatureReader<SimpleFeatureType, SimpleFeature> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            try {
                return this.delegate.hasNext();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public SimpleFeature next() throws NoSuchElementException {
            try {
                return this.delegate.next();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void close() {
            try {
                this.delegate.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

