/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverageio;

import com.vividsolutions.jts.geom.Envelope;
import it.geosolutions.imageio.imageioimpl.EnhancedImageReadParam;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageReadParam;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.OverviewPolicy;
import org.geotools.coverageio.BaseGridCoverage2DReader;
import org.geotools.coverageio.GridCoverageUtilities;
import org.geotools.coverageio.gdal.BaseGDALGridFormat;
import org.geotools.data.DataSourceException;
import org.geotools.factory.Hints;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.metadata.iso.extent.GeographicBoundingBoxImpl;
import org.geotools.metadata.iso.spatial.PixelTranslation;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.builder.GridToEnvelopeMapper;
import org.geotools.resources.coverage.CoverageUtilities;
import org.geotools.resources.geometry.XRectangle2D;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.geometry.BoundingBox;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValue;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.TransformException;

class RasterLayerRequest {
    static boolean useDestinationRegion = true;
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.coverageio");
    private ReadType readType = ReadType.UNSPECIFIED;
    private GeneralEnvelope coverageEnvelope = null;
    private ReferencedEnvelope coverageBBox;
    private ReferencedEnvelope coverageGeographicBBox;
    private CoordinateReferenceSystem coverageCRS;
    private CoordinateReferenceSystem coverageCRS2D;
    private String coverageName;
    private Rectangle coverageRasterArea;
    private double[] coverageFullResolution;
    private MathTransform2D coverageGridToWorld2D;
    private BoundingBox requestedBBox;
    private OverviewPolicy overviewPolicy;
    private Rectangle requestedRasterArea;
    private Hints hints;
    private boolean useMultithreading = false;
    private EnhancedImageReadParam imageReadParam = null;
    private Rectangle coverageRequestedRasterArea;
    private boolean adjustGridToWorldSet;
    private boolean emptyRequest;
    private File input;
    private boolean useJAI;
    private ImageLayout layout = null;
    private double[] approximateCoverageWGS84FullResolution;
    private double[] approximateWGS84RequestedResolution;
    private double[] requestedResolution;

    public RasterLayerRequest(GeneralParameterValue[] params, BaseGridCoverage2DReader reader) {
        if (params != null) {
            for (GeneralParameterValue gParam : params) {
                ParameterValue param = (ParameterValue)gParam;
                ReferenceIdentifier name = param.getDescriptor().getName();
                this.extractParameter(param, (Identifier)name);
            }
        }
        this.setDefaultParameters();
        this.setBaseParameters(reader);
    }

    private void setDefaultParameters() {
        if (this.layout == null) {
            this.setTileSize(BaseGDALGridFormat.SUGGESTED_TILE_SIZE.createValue());
        }
    }

    private void extractParameter(ParameterValue<?> param, Identifier name) {
        if (name.equals(AbstractGridFormat.READ_GRIDGEOMETRY2D.getName())) {
            GridGeometry2D gg = (GridGeometry2D)param.getValue();
            if (gg == null) {
                return;
            }
            this.requestedBBox = new ReferencedEnvelope((org.opengis.geometry.Envelope)gg.getEnvelope2D());
            this.requestedRasterArea = gg.getGridRange2D().getBounds();
            return;
        }
        if (name.equals(AbstractGridFormat.USE_JAI_IMAGEREAD.getName())) {
            Object value = param.getValue();
            if (value == null) {
                return;
            }
            this.readType = param.booleanValue() ? ReadType.JAI_IMAGEREAD : ReadType.DIRECT_READ;
            return;
        }
        if (name.equals(BaseGDALGridFormat.USE_MULTITHREADING.getName())) {
            Object value = param.getValue();
            if (value == null) {
                return;
            }
            this.useMultithreading = param.booleanValue();
            return;
        }
        if (name.equals(AbstractGridFormat.OVERVIEW_POLICY.getName())) {
            Object value = param.getValue();
            if (value == null) {
                return;
            }
            this.overviewPolicy = (OverviewPolicy)param.getValue();
            return;
        }
        if (name.equals(BaseGDALGridFormat.SUGGESTED_TILE_SIZE.getName())) {
            this.setTileSize(param);
        }
    }

    private void setTileSize(ParameterValue<?> param) {
        block3: {
            String[] tilesSize;
            String suggestedTileSize = (String)param.getValue();
            if (suggestedTileSize != null && suggestedTileSize.trim().length() > 0 && suggestedTileSize.contains(",") && (tilesSize = suggestedTileSize.split(",")).length == 2) {
                try {
                    int tileWidth = Integer.parseInt(tilesSize[0].trim());
                    int tileHeight = Integer.parseInt(tilesSize[1].trim());
                    this.layout = new ImageLayout();
                    this.layout.setTileGridXOffset(0).setTileGridYOffset(0).setTileHeight(tileHeight).setTileWidth(tileWidth);
                }
                catch (NumberFormatException nfe) {
                    this.layout = null;
                    if (!LOGGER.isLoggable(Level.WARNING)) break block3;
                    LOGGER.log(Level.WARNING, "Unable to parse suggested tile size parameter", nfe);
                }
            }
        }
    }

    public synchronized void prepare() {
        try {
            this.prepareCoverageSpatialElements();
            this.prepareRequestResponseSpatialElements();
            this.useJAI = this.requestUsesJaiImageread();
            this.imageReadParam = new EnhancedImageReadParam();
            if (this.requestedBBox != null && !this.requestedBBox.isEmpty()) {
                this.setReadParameters();
                this.adjustGridToWorldSet = true;
                return;
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
            this.requestedBBox = null;
            this.coverageRequestedRasterArea = null;
        }
        catch (TransformException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
            this.requestedBBox = null;
            this.coverageRequestedRasterArea = null;
        }
        catch (FactoryException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
            this.requestedBBox = null;
            this.coverageRequestedRasterArea = null;
        }
        this.emptyRequest = true;
    }

    private boolean requestUsesJaiImageread() {
        Object o;
        if (this.readType != ReadType.UNSPECIFIED) {
            return this.readType == ReadType.JAI_IMAGEREAD;
        }
        if (this.hints != null && (o = this.hints.get((Object)Hints.USE_JAI_IMAGEREAD)) != null) {
            return (Boolean)o;
        }
        this.readType = ReadType.getDefault();
        return this.readType == ReadType.JAI_IMAGEREAD;
    }

    private Rectangle getCropRegion() throws TransformException {
        MathTransform gridToWorldTransform = this.getOriginalGridToWorld(PixelInCell.CELL_CORNER);
        MathTransform worldToGridTransform = gridToWorldTransform.inverse();
        GeneralEnvelope rasterArea = CRS.transform((MathTransform)worldToGridTransform, (org.opengis.geometry.Envelope)this.requestedBBox);
        Rectangle2D ordinates = rasterArea.toRectangle2D();
        return ordinates.getBounds();
    }

    protected void setReadParameters() throws IOException, TransformException {
        if (!this.coverageRequestedRasterArea.isEmpty()) {
            this.imageReadParam.setSourceRegion(this.coverageRequestedRasterArea);
        } else {
            this.emptyRequest = true;
        }
        if (this.overviewPolicy == null) {
            this.overviewPolicy = OverviewPolicy.getDefaultPolicy();
        }
        this.imageReadParam.setSourceSubsampling(1, 1, 0, 0);
        if (this.overviewPolicy.equals((Object)OverviewPolicy.IGNORE)) {
            return;
        }
        double[] requestedRes = null;
        double[] fullRes = null;
        if (this.approximateWGS84RequestedResolution == null) {
            requestedRes = this.requestedResolution;
            fullRes = this.coverageFullResolution;
        } else {
            requestedRes = this.approximateWGS84RequestedResolution;
            fullRes = this.approximateCoverageWGS84FullResolution;
        }
        if (requestedRes[0] > fullRes[0] || requestedRes[1] > fullRes[1]) {
            this.setDecimationParameters(requestedRes, fullRes);
        }
    }

    private void prepareRequestResponseSpatialElements() throws DataSourceException {
        try {
            if (this.requestedBBox != null) {
                this.adjustRequestedBBox();
                if (this.requestedBBox == null || this.requestedBBox.isEmpty()) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "RequestedBBox empty or null");
                    }
                    this.emptyRequest = true;
                    return;
                }
                this.coverageRequestedRasterArea.setRect(this.getCropRegion());
                if (this.coverageRequestedRasterArea.isEmpty()) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "Requested envelope too small resulting in empty cropped raster region");
                    }
                    this.emptyRequest = true;
                    return;
                }
                if (!this.coverageRequestedRasterArea.intersects(this.coverageRasterArea)) {
                    throw new DataSourceException("The crop region is invalid.");
                }
                XRectangle2D.intersect((Rectangle2D)this.coverageRequestedRasterArea, (Rectangle2D)this.coverageRasterArea, (Rectangle2D)this.coverageRequestedRasterArea);
                if (LOGGER.isLoggable(Level.FINE)) {
                    StringBuffer sb = new StringBuffer("Adjusted Requested Envelope = ").append(this.requestedBBox.toString()).append("\n").append("Requested raster dimension = ").append(this.requestedRasterArea.toString()).append("\n").append("Corresponding raster source region = ").append(this.coverageRequestedRasterArea.toString());
                    LOGGER.log(Level.FINE, sb.toString());
                }
                return;
            }
        }
        catch (TransformException e) {
            throw new DataSourceException("Unable to create a coverage for this source", (Throwable)e);
        }
        catch (FactoryException e) {
            throw new DataSourceException("Unable to create a coverage for this source", (Throwable)e);
        }
        this.requestedBBox = this.coverageBBox;
        this.requestedRasterArea = (Rectangle)this.coverageRasterArea.clone();
        this.coverageRequestedRasterArea = (Rectangle)this.coverageRasterArea.clone();
        this.requestedResolution = (double[])this.coverageFullResolution.clone();
    }

    private void prepareCoverageSpatialElements() throws FactoryException, TransformException {
        this.coverageGeographicBBox = GridCoverageUtilities.getReferencedEnvelopeFromGeographicBoundingBox((GeographicBoundingBox)new GeographicBoundingBoxImpl((org.opengis.geometry.Envelope)this.coverageEnvelope));
        this.coverageRequestedRasterArea = new Rectangle();
        this.coverageCRS2D = CRS.getHorizontalCRS((CoordinateReferenceSystem)this.coverageCRS);
        assert (this.coverageCRS2D.getCoordinateSystem().getDimension() == 2);
        if (this.coverageCRS.getCoordinateSystem().getDimension() != 2) {
            MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)this.coverageCRS, (CoordinateReferenceSystem)this.coverageCRS2D);
            GeneralEnvelope bbox = CRS.transform((MathTransform)transform, (org.opengis.geometry.Envelope)this.coverageEnvelope);
            bbox.setCoordinateReferenceSystem(this.coverageCRS2D);
            this.coverageBBox = new ReferencedEnvelope((org.opengis.geometry.Envelope)bbox);
        } else {
            this.coverageBBox = new ReferencedEnvelope((org.opengis.geometry.Envelope)this.coverageEnvelope);
        }
        GridToEnvelopeMapper geMapper = new GridToEnvelopeMapper((GridEnvelope)new GridEnvelope2D(this.coverageRasterArea), (org.opengis.geometry.Envelope)this.coverageGeographicBBox);
        this.approximateCoverageWGS84FullResolution = CoverageUtilities.getResolution((AffineTransform)geMapper.createAffineTransform());
    }

    protected void setDecimationParameters(double[] requestedRes, double[] fullResolution) {
        int w = this.coverageRasterArea.width;
        int h = this.coverageRasterArea.height;
        if (requestedRes == null) {
            this.imageReadParam.setSourceSubsampling(1, 1, 0, 0);
        } else if (useDestinationRegion && !this.useJAI) {
            double xRatio = fullResolution[0] / requestedRes[0];
            double yRatio = fullResolution[1] / requestedRes[1];
            this.imageReadParam.setDestinationRegion(new Rectangle(0, 0, (int)Math.floor((double)this.coverageRequestedRasterArea.width * xRatio), (int)Math.floor((double)this.coverageRequestedRasterArea.height * yRatio)));
        } else {
            int subSamplingFactorX = (int)Math.floor(requestedRes[0] / fullResolution[0]);
            int n = subSamplingFactorX = subSamplingFactorX == 0 ? 1 : subSamplingFactorX;
            while (w / subSamplingFactorX <= 0 && subSamplingFactorX >= 0) {
                --subSamplingFactorX;
            }
            subSamplingFactorX = subSamplingFactorX == 0 ? 1 : subSamplingFactorX;
            int subSamplingFactorY = (int)Math.floor(requestedRes[1] / fullResolution[1]);
            int n2 = subSamplingFactorY = subSamplingFactorY == 0 ? 1 : subSamplingFactorY;
            while (h / subSamplingFactorY <= 0 && subSamplingFactorY >= 0) {
                --subSamplingFactorY;
            }
            subSamplingFactorY = subSamplingFactorY == 0 ? 1 : subSamplingFactorY;
            this.imageReadParam.setSourceSubsampling(subSamplingFactorX, subSamplingFactorY, 0, 0);
        }
    }

    public MathTransform getOriginalGridToWorld(PixelInCell pixInCell) {
        return PixelTranslation.translate((MathTransform)this.coverageGridToWorld2D, (PixelInCell)PixelInCell.CELL_CENTER, (PixelInCell)pixInCell);
    }

    private void adjustRequestedBBox() throws TransformException, FactoryException {
        block9: {
            CoordinateReferenceSystem requestedBBoxCRS2D = this.requestedBBox.getCoordinateReferenceSystem();
            try {
                MathTransform destinationToSourceTransform = null;
                if (!CRS.equalsIgnoreMetadata((Object)requestedBBoxCRS2D, (Object)this.coverageCRS2D)) {
                    destinationToSourceTransform = CRS.findMathTransform((CoordinateReferenceSystem)requestedBBoxCRS2D, (CoordinateReferenceSystem)this.coverageCRS2D, (boolean)true);
                }
                if (destinationToSourceTransform != null && !destinationToSourceTransform.isIdentity()) {
                    GeneralEnvelope temp = CRS.transform((MathTransform)destinationToSourceTransform, (org.opengis.geometry.Envelope)this.requestedBBox);
                    temp.setCoordinateReferenceSystem(this.coverageCRS2D);
                    this.requestedBBox = new ReferencedEnvelope((org.opengis.geometry.Envelope)temp);
                } else {
                    this.requestedBBox = new ReferencedEnvelope(this.requestedBBox.getMinX(), this.requestedBBox.getMaxX(), this.requestedBBox.getMinY(), this.requestedBBox.getMaxY(), this.coverageCRS2D);
                }
                if (!this.requestedBBox.intersects((BoundingBox)this.coverageBBox)) {
                    this.requestedBBox = null;
                    return;
                }
                this.requestedBBox = new ReferencedEnvelope(((ReferencedEnvelope)this.requestedBBox).intersection((Envelope)this.coverageBBox), this.coverageCRS2D);
                GridToEnvelopeMapper geMapper = new GridToEnvelopeMapper((GridEnvelope)new GridEnvelope2D(this.requestedRasterArea), (org.opengis.geometry.Envelope)this.requestedBBox);
                this.requestedResolution = CoverageUtilities.getResolution((AffineTransform)geMapper.createAffineTransform());
                return;
            }
            catch (TransformException te) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, te.getLocalizedMessage(), te);
                }
            }
            catch (FactoryException fe) {
                if (!LOGGER.isLoggable(Level.FINE)) break block9;
                LOGGER.log(Level.FINE, fe.getLocalizedMessage(), fe);
            }
        }
        GeographicBoundingBoxImpl geographicRequestedBBox = new GeographicBoundingBoxImpl((org.opengis.geometry.Envelope)this.requestedBBox);
        ReferencedEnvelope approximateWGS84requestedBBox = GridCoverageUtilities.getReferencedEnvelopeFromGeographicBoundingBox((GeographicBoundingBox)geographicRequestedBBox);
        if (!approximateWGS84requestedBBox.intersects((BoundingBox)this.coverageGeographicBBox)) {
            this.requestedBBox = null;
            return;
        }
        GridToEnvelopeMapper geMapper = new GridToEnvelopeMapper((GridEnvelope)new GridEnvelope2D(this.requestedRasterArea), (org.opengis.geometry.Envelope)approximateWGS84requestedBBox);
        this.approximateWGS84RequestedResolution = CoverageUtilities.getResolution((AffineTransform)geMapper.createAffineTransform());
        approximateWGS84requestedBBox = new ReferencedEnvelope(approximateWGS84requestedBBox.intersection((Envelope)this.coverageGeographicBBox), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (CoordinateReferenceSystem)this.coverageCRS2D, (boolean)true);
        GeneralEnvelope approximateRequestedBBoInNativeCRS = CRS.transform((MathTransform)transform, (org.opengis.geometry.Envelope)approximateWGS84requestedBBox);
        approximateRequestedBBoInNativeCRS.setCoordinateReferenceSystem(this.coverageCRS2D);
        this.requestedBBox = new ReferencedEnvelope((org.opengis.geometry.Envelope)approximateRequestedBBoInNativeCRS);
    }

    private void setBaseParameters(BaseGridCoverage2DReader reader) {
        this.input = reader.getInputFile();
        this.coverageEnvelope = reader.getOriginalEnvelope().clone();
        this.coverageRasterArea = (GridEnvelope2D)reader.getOriginalGridRange();
        this.coverageCRS = reader.getCrs();
        this.coverageName = reader.getCoverageName();
        this.coverageGridToWorld2D = (MathTransform2D)reader.getRaster2Model();
        this.coverageFullResolution = reader.getHighestRes();
        this.hints = reader.getHints().clone();
        if (this.layout != null) {
            this.hints.add(new RenderingHints(JAI.KEY_IMAGE_LAYOUT, this.layout));
        }
    }

    public Hints getHints() {
        return this.hints;
    }

    public boolean useMultithreading() {
        return this.useMultithreading;
    }

    public ImageReadParam getImageReadParam() {
        return this.imageReadParam;
    }

    public boolean useJAI() {
        return this.useJAI;
    }

    public synchronized boolean isEmptyRequest() {
        return this.emptyRequest;
    }

    public File getInput() {
        return this.input;
    }

    public MathTransform getRaster2Model() {
        return this.coverageGridToWorld2D;
    }

    public GeneralEnvelope getCoverageEnvelope() {
        return this.coverageEnvelope;
    }

    public CoordinateReferenceSystem getCoverageCRS() {
        return this.coverageCRS;
    }

    public String getCoverageName() {
        return this.coverageName;
    }

    public boolean isAdjustGridToWorldSet() {
        return this.adjustGridToWorldSet;
    }

    static enum ReadType {
        DIRECT_READ,
        JAI_IMAGEREAD,
        UNSPECIFIED;


        public static ReadType getDefault() {
            return DIRECT_READ;
        }
    }
}

