/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.tabular;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.InputStream;
import java.util.List;
import org.gbif.dwc.terms.Term;
import org.gbif.dwca.io.ArchiveFile;
import org.gbif.tabular.DwcTabularDataFileReader;
import org.gbif.tabular.TermTabularDataFileReader;
import org.gbif.utils.file.tabular.TabularDataFileReader;
import org.gbif.utils.file.tabular.TabularFiles;

public class TermTabularFiles {
    public static TermTabularDataFileReader newTermMappedTabularFileReader(InputStream in, char delimiterChar, boolean headerLine, Term[] columnMapping) {
        Preconditions.checkNotNull((Object)columnMapping, (Object)"columnMapping must be provided");
        TabularDataFileReader tabularFileReader = TabularFiles.newTabularFileReader((InputStream)in, (char)delimiterChar, (boolean)headerLine);
        return new TermTabularDataFileReader((TabularDataFileReader<List<String>>)tabularFileReader, columnMapping);
    }

    public static TermTabularDataFileReader newDwcTabularFileReader(InputStream in, ArchiveFile archiveFile, boolean headerLine) {
        Preconditions.checkNotNull((Object)archiveFile, (Object)"DarwinCore archive fields must be provided");
        Preconditions.checkArgument((archiveFile.getFieldsTerminatedBy().length() == 1 ? 1 : 0) != 0, (Object)"DarwinCore archive getFieldsTerminatedBy must be 1 char");
        TabularDataFileReader tabularFileReader = TabularFiles.newTabularFileReader((InputStream)in, (char)archiveFile.getFieldsTerminatedBy().charAt(0), (boolean)headerLine);
        return new DwcTabularDataFileReader((TabularDataFileReader<List<String>>)tabularFileReader, archiveFile.getId(), Lists.newArrayList(archiveFile.getFields().values()));
    }
}

