/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.tabular;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.gbif.dwc.terms.Term;
import org.gbif.tabular.TermTabularDataLine;
import org.gbif.utils.file.tabular.TabularDataFileReader;

public class TermTabularDataFileReader
implements TabularDataFileReader<TermTabularDataLine> {
    private final TabularDataFileReader<List<String>> tabularDataFileReader;
    private final Term[] columnMapping;
    private int lineNumber = 0;

    public TermTabularDataFileReader(TabularDataFileReader<List<String>> tabularDataFileReader, Term[] columnMapping) {
        this.tabularDataFileReader = tabularDataFileReader;
        this.columnMapping = columnMapping;
    }

    public List<String> getHeaderLine() throws IOException {
        return this.tabularDataFileReader.getHeaderLine();
    }

    public TermTabularDataLine read() throws IOException {
        List tabularLine = (List)this.tabularDataFileReader.read();
        if (tabularLine == null) {
            return null;
        }
        int numOfColumns = Math.min(this.columnMapping.length, tabularLine.size());
        HashMap line = Maps.newHashMapWithExpectedSize((int)numOfColumns);
        for (int i = 0; i < numOfColumns; ++i) {
            line.put(this.columnMapping[i], tabularLine.get(i));
        }
        ++this.lineNumber;
        if (tabularLine.size() > this.columnMapping.length) {
            return new TermTabularDataLine(this.lineNumber, line, tabularLine.size(), tabularLine.subList(this.columnMapping.length, tabularLine.size()));
        }
        return new TermTabularDataLine(this.lineNumber, line, tabularLine.size());
    }

    public void close() {
        this.tabularDataFileReader.close();
    }
}

