/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.io;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class TabWriter {
    private static final Pattern escapeChars = Pattern.compile("[\t\n\r]");
    private int records = 0;
    private Writer writer;

    public TabWriter(OutputStream stream) {
        try {
            this.writer = new BufferedWriter(new OutputStreamWriter(stream, "UTF8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    public TabWriter(Writer writer) {
        this.writer = writer;
    }

    public void write(String[] row) throws IOException {
        if (row == null || row.length == 0) {
            return;
        }
        String rowString = this.tabRow(row);
        if (rowString != null) {
            this.writer.write(rowString);
        }
    }

    private String tabRow(String[] columns) {
        boolean empty = true;
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i] == null) continue;
            empty = false;
            columns[i] = StringUtils.trimToNull((String)escapeChars.matcher(columns[i]).replaceAll(" "));
        }
        if (empty) {
            return null;
        }
        return StringUtils.join((Object[])columns, (char)'\t') + "\n";
    }

    public void close() throws IOException {
        this.writer.close();
    }
}

