/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.io;

import java.io.File;
import java.io.IOException;
import org.gbif.dwca.io.ArchiveFile;
import org.gbif.utils.file.csv.CSVReader;
import org.gbif.utils.file.csv.CSVReaderFactory;
import org.gbif.utils.file.csv.UnkownDelimitersException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVReaderFactory {
    private static final Logger LOG = LoggerFactory.getLogger(CSVReaderFactory.class);

    public static CSVReader build(ArchiveFile source) throws IOException {
        return new CSVReader(source.getLocationFile(), source.getEncoding(), source.getFieldsTerminatedBy(), source.getFieldsEnclosedBy(), source.getIgnoreHeaderLines());
    }

    private static ArchiveFile buildArchiveFile(File source, String encoding) throws UnkownDelimitersException {
        ArchiveFile dwcFile = new ArchiveFile();
        dwcFile.addLocation(source.getAbsolutePath());
        dwcFile.setEncoding(encoding);
        dwcFile.setIgnoreHeaderLines(1);
        CSVReaderFactory.CSVMetadata csvMetadata = org.gbif.utils.file.csv.CSVReaderFactory.extractCsvMetadata((File)source, (String)encoding);
        dwcFile.setFieldsTerminatedBy(csvMetadata.getDelimiter());
        dwcFile.setFieldsEnclosedBy(csvMetadata.getQuotedBy());
        String msg = "Detected field delimiter >>>" + dwcFile.getFieldsTerminatedBy() + "<<<";
        if (dwcFile.getFieldsEnclosedBy() != null) {
            msg = msg + " and quoted by >>>" + dwcFile.getFieldsEnclosedBy() + "<<<";
        }
        LOG.debug(msg);
        return dwcFile;
    }
}

