/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.dwca.record;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gbif.dwc.terms.Term;
import org.gbif.dwca.record.Record;
import org.gbif.dwca.record.StarRecord;

public class StarRecordImpl
implements StarRecord {
    private Record core;
    private final Map<Term, List<Record>> extensions = new HashMap<Term, List<Record>>();

    public StarRecordImpl(Collection<Term> extensions) {
        for (Term rowType : extensions) {
            this.extensions.put(rowType, new ArrayList());
        }
    }

    public void addRecord(Term rowType, Record record) {
        if (!this.extensions.containsKey(rowType)) {
            throw new IllegalArgumentException("RowType not supported");
        }
        this.extensions.get(rowType).add(record);
    }

    @Override
    public Record core() {
        return this.core;
    }

    @Override
    public boolean hasExtension(Term rowType) {
        return this.extensions.containsKey(rowType);
    }

    @Override
    public List<Record> extension(Term rowType) {
        return this.extensions.get(rowType);
    }

    @Override
    public Map<Term, List<Record>> extensions() {
        return this.extensions;
    }

    @Override
    public Iterator<Record> iterator() {
        ArrayList<Record> records = new ArrayList<Record>();
        for (List<Record> recs : this.extensions.values()) {
            records.addAll(recs);
        }
        return records.iterator();
    }

    public void newCoreRecord(Record core) {
        this.core = core;
        for (List<Record> lists : this.extensions.values()) {
            lists.clear();
        }
    }

    @Override
    public Set<Term> rowTypes() {
        return this.extensions.keySet();
    }

    @Override
    public int size() {
        int x = 0;
        for (List<Record> recs : this.extensions.values()) {
            x += recs.size();
        }
        return x;
    }
}

