/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.dwca.record;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.gbif.dwc.terms.Term;
import org.gbif.dwc.terms.TermFactory;
import org.gbif.dwca.io.ArchiveField;
import org.gbif.dwca.io.ArchiveFile;
import org.gbif.dwca.record.CleanUtils;
import org.gbif.dwca.record.Record;

public class RecordImpl
implements Record {
    private static final TermFactory TERM_FACTORY = TermFactory.instance();
    private final ArchiveField id;
    private final Map<Term, ArchiveField> fields;
    protected String[] row;
    private final Term rowType;
    private final boolean replaceNulls;
    private final boolean replaceEntities;

    public RecordImpl(ArchiveField id, Collection<ArchiveField> fields, Term rowType, boolean replaceNulls, boolean replaceEntities) {
        this.id = id;
        this.fields = new HashMap<Term, ArchiveField>();
        for (ArchiveField f : fields) {
            this.fields.put(f.getTerm(), f);
        }
        this.rowType = rowType;
        this.replaceNulls = replaceNulls;
        this.replaceEntities = replaceEntities;
    }

    public RecordImpl(ArchiveField id, Map<Term, ArchiveField> fields, Term rowType, boolean replaceNulls, boolean replaceEntities) {
        this.id = id;
        this.fields = fields;
        this.rowType = rowType;
        this.replaceNulls = replaceNulls;
        this.replaceEntities = replaceEntities;
    }

    public RecordImpl(ArchiveFile af, boolean replaceNulls, boolean replaceEntities) {
        this.id = af.getId();
        this.fields = af.getFields();
        this.rowType = af.getRowType();
        this.replaceNulls = replaceNulls;
        this.replaceEntities = replaceEntities;
    }

    @Override
    public String column(int index) {
        if (this.row.length > index) {
            return CleanUtils.clean(this.row[index], this.replaceNulls, this.replaceEntities);
        }
        return null;
    }

    public boolean hasRow() {
        return this.row != null;
    }

    @Override
    public String id() {
        if (this.id != null) {
            return this.column(this.id.getIndex());
        }
        return null;
    }

    @Override
    public Term rowType() {
        return this.rowType;
    }

    public void setRow(String[] row) {
        this.row = row;
    }

    public String toString() {
        return "Record{" + this.id() + "}[" + StringUtils.join((Object[])this.row, (String)"|") + "]";
    }

    private String value(ArchiveField f) {
        if (f != null) {
            if (f.getIndex() == null) {
                return f.getDefaultValue();
            }
            String val = this.column(f.getIndex());
            if (StringUtils.isBlank((CharSequence)val)) {
                return f.getDefaultValue();
            }
            return val;
        }
        return null;
    }

    @Override
    public String value(Term term) {
        if (term == null) {
            return null;
        }
        return this.value(this.fields.get(term));
    }

    @Override
    public Set<Term> terms() {
        return this.fields.keySet();
    }
}

