/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.common.parsers.date;

import com.google.common.base.Strings;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.gbif.common.parsers.core.Parsable;
import org.gbif.common.parsers.core.ParseResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
class StringToDateParser
implements Parsable<Date> {
    private static final Logger LOGGER = LoggerFactory.getLogger(StringToDateParser.class);
    private static final Date MAX_VALID_YEAR;
    protected static String[] allPatterns;
    private static Pattern FULL_YEAR;
    private static String[] ASIAN;
    private static String[] TIME_FORMATS;
    private static String[] FREQUENT_FULL;
    private static String[] CHAR6_ONLY_DIGITS;
    private static String[] CHAR8_ONLY_DIGITS;
    private static final Pattern DOUBLE_ZERO_PATTERN;
    private static final Pattern DOUBLE_ZERO_ONE_PATTERN;

    StringToDateParser() {
    }

    private static ParseResult.CONFIDENCE checkMonthDay(Date d, boolean verifyYear) {
        if (d == null) {
            return ParseResult.CONFIDENCE.DEFINITE;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        int day = cal.get(5);
        int month = cal.get(2) + 1;
        if (day > 12 || day == month) {
            if (verifyYear) {
                int year = cal.get(1);
                int yearInCentury = year % 100;
                if (yearInCentury > 31) {
                    return ParseResult.CONFIDENCE.DEFINITE;
                }
                if (year < 1700) {
                    return ParseResult.CONFIDENCE.POSSIBLE;
                }
                return ParseResult.CONFIDENCE.PROBABLE;
            }
            return ParseResult.CONFIDENCE.DEFINITE;
        }
        return ParseResult.CONFIDENCE.POSSIBLE;
    }

    @Override
    public ParseResult<Date> parse(String input) {
        if (Strings.isNullOrEmpty(input)) {
            return ParseResult.fail();
        }
        int len = input.length();
        Date d = null;
        ParseResult.CONFIDENCE confidence = ParseResult.CONFIDENCE.DEFINITE;
        if (input.contains("\u5e74")) {
            d = this.strictParse(input, ASIAN);
        }
        if (StringUtils.isNumeric((CharSequence)input)) {
            if (len <= 4) {
                d = this.strictParse(input, "yy", "yyyy");
            } else if (len == 6) {
                d = this.strictParse(input, CHAR6_ONLY_DIGITS);
                confidence = StringToDateParser.checkMonthDay(d, true);
                confidence = confidence == ParseResult.CONFIDENCE.DEFINITE ? ParseResult.CONFIDENCE.PROBABLE : confidence;
            } else if (len == 8) {
                d = this.strictParse(input, CHAR8_ONLY_DIGITS);
                confidence = StringToDateParser.checkMonthDay(d, true);
            }
        } else {
            Character del = null;
            int delimCount = 0;
            for (char c : input.toCharArray()) {
                if (Character.isDigit(c) || Character.isAlphabetic(c)) continue;
                ++delimCount;
                if (del == null) {
                    del = Character.valueOf(c);
                    continue;
                }
                if (del.equals(Character.valueOf(c))) continue;
                d = this.strictParse(input, TIME_FORMATS);
                confidence = StringToDateParser.checkMonthDay(d, true);
                break;
            }
            if (del == null) {
                return ParseResult.fail();
            }
            if (Character.isLetter(del.charValue())) {
                confidence = ParseResult.CONFIDENCE.POSSIBLE;
            }
            boolean fullYear = FULL_YEAR.matcher(input).find();
            try {
                if (delimCount == 1) {
                    String[] formats;
                    if (fullYear) {
                        formats = new String[]{"yyyy" + del + "MM", "MM" + del + "yyyy"};
                    } else {
                        formats = new String[]{"yy" + del + "MM", "MM" + del + "yy"};
                        confidence = ParseResult.CONFIDENCE.POSSIBLE;
                    }
                    d = this.strictParse(input, formats);
                } else if (delimCount == 2) {
                    if (fullYear) {
                        d = this.strictParse(input, FREQUENT_FULL);
                        if (d == null && (d = this.strictParse(input, TIME_FORMATS)) == null) {
                            String[] formats = new String[]{"yyyy" + del + "MM" + del + "dd", "dd" + del + "MM" + del + "yyyy", "MM" + del + "dd" + del + "yyyy"};
                            d = this.strictParse(input, formats);
                            confidence = StringToDateParser.checkMonthDay(d, false);
                        }
                    } else {
                        String[] formats = del.charValue() == '-' ? new String[]{"yy" + del + "MM" + del + "dd", "dd" + del + "MM" + del + "yy", "MM" + del + "dd" + del + "yy"} : new String[]{"dd" + del + "MM" + del + "yy", "MM" + del + "dd" + del + "yy", "yy" + del + "MM" + del + "dd"};
                        d = this.strictParse(input, formats);
                        confidence = StringToDateParser.checkMonthDay(d, true);
                    }
                } else {
                    d = this.strictParse(input, TIME_FORMATS);
                }
            }
            catch (RuntimeException e) {
                return ParseResult.fail();
            }
        }
        if (d != null && d.before(MAX_VALID_YEAR)) {
            return ParseResult.success(confidence, d);
        }
        return ParseResult.fail();
    }

    Date strictParse(String input, String ... patterns) {
        try {
            return DateUtils.parseDateStrictly((String)input, (String[])patterns);
        }
        catch (ParseException e) {
            return null;
        }
    }

    static {
        Calendar cal = Calendar.getInstance();
        cal.add(1, 3000);
        MAX_VALID_YEAR = cal.getTime();
        allPatterns = new String[]{"dd/MM/yy", "ddMMyy", "dd\\MM\\yy", "dd.MM.yy", "dd-MM-yy", "dd_MM_yy", "MM/dd/yy", "MMddyy", "MM\\dd\\yy", "MM.dd.yy", "MM-dd-yy", "MM_dd_yy", "dd/MM/yyyy", "ddMMyyyy", "dd\\MM\\yyyy", "dd.MM.yyyy", "dd-MM-yyyy", "dd_MM_yyyy", "MM/dd/yyyy", "MMddyyyy", "MM\\dd\\yyyy", "MM.dd.yyyy", "MM-dd-yyyy", "MM_dd_yyyy", "yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd'T'HH", "yyyy-MM-dd'T'HH:mm", "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd'T'HHmm", "yyyy-MM-dd'T'HHmmss", "yyyy-MM-dd'T'HH:mm:ssZZ", "yyyy-MM-dd'T'HH:mm:ss'Z'", "yyyy-MM"};
        FULL_YEAR = Pattern.compile("\\d\\d\\d\\d");
        ASIAN = new String[]{"yyyy\u5e74mm\u6708dd\u65e5", "yyyy\u5e74m\u6708d\u65e5", "yy\u5e74m\u6708d\u65e5"};
        TIME_FORMATS = new String[]{"yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd'T'HH", "yyyy-MM-dd'T'HH:mm", "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd'T'HHmm", "yyyy-MM-dd'T'HHmmss", "yyyy-MM-dd'T'HH:mm:ssZZ", "yyyy-MM-dd'T'HH:mm:ss'Z'"};
        FREQUENT_FULL = new String[]{"yyyy-MM-dd", "dd.MM.yyyy", "dd-MM-yyyy"};
        CHAR6_ONLY_DIGITS = new String[]{"ddMMyy", "MMddyy", "yyMMdd"};
        CHAR8_ONLY_DIGITS = new String[]{"yyyyMMdd", "ddMMyyyy"};
        DOUBLE_ZERO_PATTERN = Pattern.compile("00");
        DOUBLE_ZERO_ONE_PATTERN = Pattern.compile("0101");
    }
}

