/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.common.parsers.date;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.gbif.common.parsers.date.DateFormatHint;
import org.gbif.common.parsers.date.DateTimeMultiParser;
import org.gbif.common.parsers.date.DateTimeParser;
import org.gbif.common.parsers.date.DateTimeSeparatorNormalizer;
import org.gbif.common.parsers.date.ThreeTenNumericalDateParser;
import org.threeten.bp.Year;
import org.threeten.bp.format.DateTimeFormatter;
import org.threeten.bp.format.DateTimeFormatterBuilder;
import org.threeten.bp.format.ResolverStyle;
import org.threeten.bp.temporal.ChronoField;
import org.threeten.bp.temporal.TemporalField;

public class DateTimeParserBuilder {
    private static final String YEAR_2_DIGITS_PATTERN_SUFFIX = "uu";
    private static final String IS_YEAR_2_DIGITS_PATTERN = "^.+[^u]uu$";

    private DateTimeParserBuilder() {
    }

    public static ThreeTenDateParserListBuilder newParserListBuilder() {
        return new ThreeTenDateParserListBuilder();
    }

    public static ThreeTenDateMultiParserListBuilder newMultiParserListBuilder() {
        return new ThreeTenDateMultiParserListBuilder();
    }

    public static DateTimeParser build(@NotNull String pattern, @NotNull DateFormatHint hint) {
        Preconditions.checkNotNull(pattern);
        Preconditions.checkNotNull(hint);
        int minLength = DateTimeParserBuilder.getMinimumStringLengthForPattern(pattern);
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern((String)pattern).withResolverStyle(ResolverStyle.STRICT);
        return new DateTimeParser(dateTimeFormatter, null, hint, minLength);
    }

    public static DateTimeParser build(String pattern, DateFormatHint hint, String separator, String alternativeSeparators) {
        Preconditions.checkNotNull(pattern);
        Preconditions.checkNotNull(hint);
        Preconditions.checkArgument(StringUtils.isNotBlank((CharSequence)separator), "separator must NOT be blank");
        Preconditions.checkArgument(StringUtils.isNotBlank((CharSequence)alternativeSeparators), "alternativeSeparators must NOT be blank");
        DateTimeSeparatorNormalizer dateTimeNormalizer = new DateTimeSeparatorNormalizer(CharMatcher.anyOf(alternativeSeparators), separator);
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern((String)pattern).withResolverStyle(ResolverStyle.STRICT);
        int minLength = DateTimeParserBuilder.getMinimumStringLengthForPattern(pattern);
        return new DateTimeParser(dateTimeFormatter, dateTimeNormalizer, hint, minLength);
    }

    public static DateTimeParser build(String pattern, DateFormatHint hint, Year baseYear) {
        int minLength = DateTimeParserBuilder.getMinimumStringLengthForPattern(pattern);
        DateTimeFormatter dateTimeFormatter = DateTimeParserBuilder.build2DigitsYearDateTimeFormatter(pattern, baseYear);
        return new DateTimeParser(dateTimeFormatter, null, hint, minLength);
    }

    public static DateTimeParser build(String pattern, DateFormatHint hint, String separator, String alternativeSeparators, Year baseYear) {
        Preconditions.checkNotNull(pattern);
        Preconditions.checkNotNull(hint);
        Preconditions.checkArgument(StringUtils.isNotBlank((CharSequence)separator), "separator must NOT be blank");
        Preconditions.checkArgument(StringUtils.isNotBlank((CharSequence)alternativeSeparators), "alternativeSeparators must NOT be blank");
        DateTimeSeparatorNormalizer dateTimeNormalizer = new DateTimeSeparatorNormalizer(CharMatcher.anyOf(alternativeSeparators), separator);
        DateTimeFormatter dateTimeFormatter = DateTimeParserBuilder.build2DigitsYearDateTimeFormatter(pattern, baseYear);
        int minLength = DateTimeParserBuilder.getMinimumStringLengthForPattern(pattern);
        return new DateTimeParser(dateTimeFormatter, dateTimeNormalizer, hint, minLength);
    }

    private static int getMinimumStringLengthForPattern(String pattern) {
        pattern = ThreeTenNumericalDateParser.OPTIONAL_PATTERN_PART.matcher(pattern).replaceAll("").replaceAll("'", "");
        return pattern.length();
    }

    private static DateTimeFormatter build2DigitsYearDateTimeFormatter(String pattern, Year baseYear) {
        Preconditions.checkState(pattern.matches(IS_YEAR_2_DIGITS_PATTERN) || pattern.equals(YEAR_2_DIGITS_PATTERN_SUFFIX), "build2DigitsYearDateTimeFormatter can only be used for patterns with 2 digit year");
        pattern = StringUtils.removeEnd((String)pattern, (String)YEAR_2_DIGITS_PATTERN_SUFFIX);
        return new DateTimeFormatterBuilder().append(DateTimeFormatter.ofPattern((String)pattern)).appendValueReduced((TemporalField)ChronoField.YEAR, 2, 2, baseYear.getValue()).parseStrict().toFormatter();
    }

    public static class ThreeTenDateMultiParserListBuilder {
        private DateTimeParser preferred;
        private List<DateTimeParser> otherParsers = Lists.newArrayList();

        public ThreeTenDateMultiParserListBuilder preferredDateTimeParser(String pattern, DateFormatHint hint) {
            this.preferred = DateTimeParserBuilder.build(pattern, hint);
            return this;
        }

        public ThreeTenDateMultiParserListBuilder preferredDateTimeParser(String pattern, DateFormatHint hint, Year year) {
            this.preferred = DateTimeParserBuilder.build(pattern, hint, year);
            return this;
        }

        public ThreeTenDateMultiParserListBuilder appendDateTimeParser(String pattern, DateFormatHint hint) {
            this.otherParsers.add(DateTimeParserBuilder.build(pattern, hint));
            return this;
        }

        public ThreeTenDateMultiParserListBuilder appendDateTimeParser(String pattern, DateFormatHint hint, Year year) {
            this.otherParsers.add(DateTimeParserBuilder.build(pattern, hint, year));
            return this;
        }

        public ThreeTenDateMultiParserListBuilder appendDateTimeParser(String pattern, DateFormatHint hint, String separator, String alternativeSeparators) {
            this.otherParsers.add(DateTimeParserBuilder.build(pattern, hint, separator, alternativeSeparators));
            return this;
        }

        public ThreeTenDateMultiParserListBuilder appendDateTimeParser(String pattern, DateFormatHint hint, String separator, String alternativeSeparators, Year year) {
            this.otherParsers.add(DateTimeParserBuilder.build(pattern, hint, separator, alternativeSeparators, year));
            return this;
        }

        private void validate() throws IllegalStateException {
            HashSet<DateFormatHint> hints = Sets.newHashSet();
            if (this.preferred != null) {
                hints.add(this.preferred.getHint());
            }
            for (DateTimeParser parser : this.otherParsers) {
                if (hints.add(parser.getHint())) continue;
                throw new IllegalStateException("DateFormatHint can only be used once in a DateTimeMultiParser.[" + (Object)((Object)parser.getHint()) + "]");
            }
        }

        public DateTimeMultiParser build() throws IllegalStateException {
            this.validate();
            return new DateTimeMultiParser(this.preferred, this.otherParsers);
        }
    }

    public static class ThreeTenDateParserListBuilder {
        private final List<DateTimeParser> dateTimeParsers = Lists.newArrayList();

        public ThreeTenDateParserListBuilder appendDateTimeParser(String pattern, DateFormatHint hint) {
            this.dateTimeParsers.add(DateTimeParserBuilder.build(pattern, hint));
            return this;
        }

        public ThreeTenDateParserListBuilder appendDateTimeParser(String pattern, DateFormatHint hint, String separator, String alternativeSeparators) {
            this.dateTimeParsers.add(DateTimeParserBuilder.build(pattern, hint, separator, alternativeSeparators));
            return this;
        }

        public ThreeTenDateParserListBuilder append2DigitsYearDateTimeParser(String pattern, DateFormatHint hint, Year baseYear) {
            int minLength = DateTimeParserBuilder.getMinimumStringLengthForPattern(pattern);
            DateTimeFormatter dateTimeFormatter = DateTimeParserBuilder.build2DigitsYearDateTimeFormatter(pattern, baseYear);
            this.dateTimeParsers.add(new DateTimeParser(dateTimeFormatter, null, hint, minLength));
            return this;
        }

        public ThreeTenDateParserListBuilder append2DigitsYearDateTimeParser(String pattern, DateFormatHint hint, String separator, String alternativeSeparators, Year baseYear) {
            int minLength = DateTimeParserBuilder.getMinimumStringLengthForPattern(pattern);
            DateTimeSeparatorNormalizer dateTimeNormalizer = new DateTimeSeparatorNormalizer(CharMatcher.anyOf(alternativeSeparators), separator);
            DateTimeFormatter dateTimeFormatter = DateTimeParserBuilder.build2DigitsYearDateTimeFormatter(pattern, baseYear);
            this.dateTimeParsers.add(new DateTimeParser(dateTimeFormatter, dateTimeNormalizer, hint, minLength));
            return this;
        }

        public List<DateTimeParser> build() {
            return ImmutableList.copyOf(this.dateTimeParsers);
        }
    }
}

