/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.common.parsers;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlParser {
    private static final Logger LOG = LoggerFactory.getLogger(UrlParser.class);
    private static final String[] MULTI_VALUE_DELIMITERS = new String[]{"|#DELIMITER#|", "|", ",", ";"};
    private static final String HTTP_SCHEME = "http://";

    private UrlParser() {
    }

    public static URI parse(String value) {
        if (Strings.isNullOrEmpty(value = CharMatcher.WHITESPACE.trimFrom(Strings.nullToEmpty(value)))) {
            return null;
        }
        URI uri = null;
        try {
            uri = URI.create(value);
            if (!uri.isAbsolute() && value.startsWith("www")) {
                try {
                    uri = URI.create(HTTP_SCHEME + value);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (Strings.isNullOrEmpty(uri.getHost())) {
                return null;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return uri;
    }

    public static List<URI> parseUriList(String uris) {
        ArrayList<URI> result = Lists.newArrayList();
        if (!Strings.isNullOrEmpty(uris)) {
            URI uri = UrlParser.parse(uris);
            if (uri != null) {
                result.add(uri);
            } else {
                int maxValidUrls = 0;
                for (String delimiter : MULTI_VALUE_DELIMITERS) {
                    Splitter splitter = Splitter.on(delimiter).omitEmptyStrings().trimResults();
                    String[] urls = Iterables.toArray(splitter.split(uris), String.class);
                    if (urls.length <= 1) continue;
                    ArrayList<URI> tmp = Lists.newArrayList();
                    for (String url : urls) {
                        uri = UrlParser.parse(url);
                        if (uri == null) continue;
                        tmp.add(uri);
                    }
                    if (tmp.size() > maxValidUrls) {
                        result = tmp;
                        maxValidUrls = tmp.size();
                        continue;
                    }
                    if (maxValidUrls <= 0 || tmp.size() != maxValidUrls) continue;
                    LOG.info("Unclear what delimiter is being used for concatenated URIs = {}", (Object)uris);
                }
            }
        }
        return result;
    }
}

