/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.common.parsers;

import com.google.common.base.Strings;
import com.google.common.collect.Range;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gbif.api.model.checklistbank.ParsedName;
import org.gbif.common.parsers.core.Parsable;
import org.gbif.common.parsers.core.ParseResult;
import org.gbif.nameparser.NameParser;
import org.gbif.nameparser.UnparsableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypifiedNameParser
implements Parsable<String> {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private static TypifiedNameParser singletonObject = null;
    private static final Range<Integer> REASONABLE_NAME_SIZE_RANGE = Range.closed(4, 40);
    private static final NameParser NAME_PARSER = new NameParser();
    private static final Pattern NAME_SEPARATOR = Pattern.compile("\\sOF\\W*\\s+\\W*(.+)\\W*\\s*$", 2);
    private static final Pattern CLEAN_WHITESPACE = Pattern.compile("\\s+");

    private TypifiedNameParser() {
    }

    @Override
    public ParseResult<String> parse(String input) {
        block3: {
            String name;
            Matcher m;
            if (!Strings.isNullOrEmpty(input) && (m = NAME_SEPARATOR.matcher(input)).find() && !(name = m.group(1)).endsWith("type")) {
                try {
                    ParsedName pn = NAME_PARSER.parse(name, null);
                    return ParseResult.success(ParseResult.CONFIDENCE.PROBABLE, pn.canonicalNameComplete());
                }
                catch (UnparsableException e) {
                    this.log.debug("Cannot parse typified name: [{}] from input [{}]", (Object)name, (Object)input);
                    name = CLEAN_WHITESPACE.matcher(name).replaceAll(" ").trim();
                    if (!REASONABLE_NAME_SIZE_RANGE.contains(name.length())) break block3;
                    return ParseResult.success(ParseResult.CONFIDENCE.POSSIBLE, name);
                }
            }
        }
        return ParseResult.fail();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TypifiedNameParser getInstance() {
        Class<TypifiedNameParser> clazz = TypifiedNameParser.class;
        synchronized (TypifiedNameParser.class) {
            if (singletonObject == null) {
                singletonObject = new TypifiedNameParser();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return singletonObject;
        }
    }
}

