/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.common.parsers;

import com.google.common.base.Strings;
import java.io.InputStream;
import java.net.URI;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.gbif.api.vocabulary.License;
import org.gbif.common.parsers.ContinentParser;
import org.gbif.common.parsers.core.EnumParser;
import org.gbif.common.parsers.core.ParseResult;

public class LicenseParser
extends EnumParser<License> {
    private static final String COMMENT_MARKER = "#";
    private static final String LICENSE_FILEPATH = "/dictionaries/parse/license.txt";
    private static final Pattern REMOVE_HTTP_PATTERN = Pattern.compile("^https?:\\/\\/", 2);
    private static LicenseParser singletonObject = null;

    private LicenseParser() {
        super(License.class, true, new InputStream[0]);
        for (License l : License.values()) {
            this.add(l.name(), l);
            this.add(l.getLicenseTitle(), l);
            this.add(l.getLicenseUrl(), l);
        }
        this.init(LicenseParser.class.getResourceAsStream(LICENSE_FILEPATH), COMMENT_MARKER);
    }

    @Override
    protected String normalize(String value) {
        if (value == null) {
            return null;
        }
        return super.normalize(REMOVE_HTTP_PATTERN.matcher(value).replaceAll(""));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LicenseParser getInstance() {
        Class<ContinentParser> clazz = ContinentParser.class;
        synchronized (ContinentParser.class) {
            if (singletonObject == null) {
                singletonObject = new LicenseParser();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return singletonObject;
        }
    }

    public License parseUriThenTitle(@Nullable URI uri, @Nullable String title) {
        ParseResult result;
        if (uri == null && Strings.isNullOrEmpty(title)) {
            return License.UNSPECIFIED;
        }
        if (uri != null && (result = singletonObject.parse(uri.toString())).isSuccessful()) {
            return (License)result.getPayload();
        }
        if (!Strings.isNullOrEmpty(title) && (result = singletonObject.parse(title)).isSuccessful()) {
            return (License)result.getPayload();
        }
        return License.UNSUPPORTED;
    }
}

