/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.collection;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.CollectionListener;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.collection.DelegateSimpleFeatureIterator;
import org.geotools.feature.collection.SubFeatureCollection;
import org.geotools.feature.collection.SubFeatureList;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.NullProgressListener;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.sort.SortBy;
import org.opengis.util.ProgressListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFeatureCollection
implements SimpleFeatureCollection {
    protected List<CollectionListener> listeners = new ArrayList<CollectionListener>();
    protected String id;
    protected SimpleFeatureType schema;
    protected final Set open = new HashSet();

    protected AbstractFeatureCollection(SimpleFeatureType memberType) {
        this.id = this.id == null ? "featureCollection" : this.id;
        this.schema = memberType;
    }

    @Override
    public SimpleFeatureIterator features() {
        DelegateSimpleFeatureIterator iter = new DelegateSimpleFeatureIterator(this, this.openIterator());
        this.getOpenIterators().add(iter);
        return iter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close(Iterator close) {
        if (close == null) {
            return;
        }
        try {
            this.closeIterator(close);
        }
        catch (Throwable throwable) {
        }
        finally {
            this.open.remove(close);
        }
    }

    @Override
    public void close(FeatureIterator<SimpleFeature> close) {
        if (close != null) {
            close.close();
        }
    }

    protected abstract Iterator<SimpleFeature> openIterator();

    protected abstract void closeIterator(Iterator<SimpleFeature> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purge() {
        Iterator i = this.open.iterator();
        while (i.hasNext()) {
            Object resource = i.next();
            if (!(resource instanceof Iterator)) continue;
            Iterator resourceIterator = (Iterator)resource;
            try {
                this.closeIterator(resourceIterator);
            }
            catch (Throwable e) {}
            continue;
            finally {
                i.remove();
            }
        }
    }

    @Override
    public abstract int size();

    @Override
    public boolean add(SimpleFeature o) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends SimpleFeature> c) {
        boolean modified = false;
        Iterator<? extends SimpleFeature> e = c.iterator();
        try {
            while (e.hasNext()) {
                if (!this.add(e.next())) continue;
                modified = true;
            }
        }
        finally {
            if (c instanceof FeatureCollection) {
                FeatureCollection other = (FeatureCollection)((Object)c);
                other.close(e);
            }
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(FeatureCollection<? extends SimpleFeatureType, ? extends SimpleFeature> c) {
        boolean modified = false;
        FeatureIterator<? extends SimpleFeature> e = c.features();
        try {
            while (e.hasNext()) {
                if (!this.add(e.next())) continue;
                modified = true;
            }
        }
        finally {
            e.close();
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Iterator<SimpleFeature> e = this.iterator();
        try {
            while (e.hasNext()) {
                e.next();
                e.remove();
            }
        }
        finally {
            this.close(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object o) {
        Iterator<SimpleFeature> e = null;
        try {
            e = this.iterator();
            if (o == null) {
                while (e.hasNext()) {
                    if (e.next() != null) continue;
                    boolean bl = true;
                    return bl;
                }
            } else {
                while (e.hasNext()) {
                    if (!o.equals(e.next())) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.close(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(Collection<?> c) {
        Iterator<?> e = c.iterator();
        try {
            while (e.hasNext()) {
                if (this.contains(e.next())) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.close(e);
        }
    }

    public final Set getOpenIterators() {
        return this.open;
    }

    @Override
    public final Iterator<SimpleFeature> iterator() {
        Iterator<SimpleFeature> iterator = this.openIterator();
        this.getOpenIterators().add(iterator);
        return iterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Iterator<SimpleFeature> iterator = this.iterator();
        try {
            boolean bl = !iterator.hasNext();
            return bl;
        }
        finally {
            this.close(iterator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        Iterator<SimpleFeature> e = this.iterator();
        try {
            if (o == null) {
                while (e.hasNext()) {
                    if (e.next() != null) continue;
                    e.remove();
                    boolean bl = true;
                    return bl;
                }
            } else {
                while (e.hasNext()) {
                    if (!o.equals(e.next())) continue;
                    e.remove();
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.close(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean removeAll(Collection<?> c) {
        boolean modified = false;
        Iterator<SimpleFeature> e = this.iterator();
        try {
            while (e.hasNext()) {
                if (!c.contains(e.next())) continue;
                e.remove();
                modified = true;
            }
            boolean bl = modified;
            return bl;
        }
        finally {
            if (c instanceof FeatureCollection) {
                FeatureCollection other = (FeatureCollection)((Object)c);
                other.close(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean retainAll(Collection<?> c) {
        boolean modified = false;
        Iterator<SimpleFeature> e = this.iterator();
        try {
            while (e.hasNext()) {
                if (c.contains(e.next())) continue;
                e.remove();
                modified = true;
            }
            boolean bl = modified;
            return bl;
        }
        finally {
            if (c instanceof FeatureCollection) {
                FeatureCollection other = (FeatureCollection)((Object)c);
                other.close(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.size()];
        Iterator<SimpleFeature> e = null;
        try {
            e = this.iterator();
            int i = 0;
            while (e.hasNext()) {
                result[i] = e.next();
                ++i;
            }
            Object[] objectArray = result;
            return objectArray;
        }
        finally {
            this.close(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] a) {
        int size = this.size();
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        Iterator<SimpleFeature> it = this.iterator();
        try {
            T[] result = a;
            for (int i = 0; i < size; ++i) {
                result[i] = it.next();
            }
            if (a.length > size) {
                a[size] = null;
            }
            Object[] objectArray = a;
            return objectArray;
        }
        finally {
            this.close(it);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accepts(FeatureVisitor visitor, ProgressListener progress) {
        Iterator<SimpleFeature> iterator = null;
        if (progress == null) {
            progress = new NullProgressListener();
        }
        try {
            float size = this.size();
            float position = 0.0f;
            progress.started();
            iterator = this.iterator();
            while (!progress.isCanceled() && iterator.hasNext()) {
                if (size > 0.0f) {
                    float f = position;
                    position = f + 1.0f;
                    progress.progress(f / size);
                }
                try {
                    SimpleFeature feature = iterator.next();
                    visitor.visit((Feature)feature);
                }
                catch (Exception erp) {
                    progress.exceptionOccurred((Throwable)erp);
                }
            }
        }
        finally {
            progress.complete();
            this.close(iterator);
        }
    }

    public SimpleFeatureCollection subList(Filter filter) {
        return new SubFeatureList((SimpleFeatureCollection)this, filter);
    }

    @Override
    public SimpleFeatureCollection subCollection(Filter filter) {
        if (filter == Filter.INCLUDE) {
            return this;
        }
        return new SubFeatureCollection(this, filter);
    }

    @Override
    public SimpleFeatureCollection sort(SortBy order) {
        return new SubFeatureList((SimpleFeatureCollection)this, order);
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public final void addListener(CollectionListener listener) throws NullPointerException {
        this.listeners.add(listener);
    }

    @Override
    public final void removeListener(CollectionListener listener) throws NullPointerException {
        this.listeners.remove(listener);
    }

    @Override
    public SimpleFeatureType getSchema() {
        return this.schema;
    }

    @Override
    public abstract ReferencedEnvelope getBounds();
}

