/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.vocabulary;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;

public enum TypeStatus {
    TYPE,
    TYPE_SPECIES,
    TYPE_GENUS,
    ALLOLECTOTYPE,
    ALLONEOTYPE,
    ALLOTYPE,
    COTYPE,
    EPITYPE,
    EXEPITYPE,
    EXHOLOTYPE,
    EXISOTYPE,
    EXLECTOTYPE,
    EXNEOTYPE,
    EXPARATYPE,
    EXSYNTYPE,
    EXTYPE,
    HAPANTOTYPE,
    HOLOTYPE,
    ICONOTYPE,
    ISOLECTOTYPE,
    ISONEOTYPE,
    ISOSYNTYPE,
    ISOTYPE,
    LECTOTYPE,
    NEOTYPE,
    NOTATYPE,
    ORIGINALMATERIAL,
    PARALECTOTYPE,
    PARANEOTYPE,
    PARATYPE,
    PLASTOHOLOTYPE,
    PLASTOISOTYPE,
    PLASTOLECTOTYPE,
    PLASTONEOTYPE,
    PLASTOPARATYPE,
    PLASTOSYNTYPE,
    PLASTOTYPE,
    SECONDARYTYPE,
    SUPPLEMENTARYTYPE,
    SYNTYPE,
    TOPOTYPE;


    public static List<TypeStatus> specimenTypeStatusList() {
        return ImmutableList.copyOf(Collections2.filter(Lists.newArrayList(TypeStatus.values()), new Predicate<TypeStatus>(){

            @Override
            public boolean apply(@Nullable TypeStatus status) {
                return status.isTypeSpecimen();
            }
        }));
    }

    public static List<TypeStatus> nameTypeStatusList() {
        return ImmutableList.copyOf(Collections2.filter(Lists.newArrayList(TypeStatus.values()), new Predicate<TypeStatus>(){

            @Override
            public boolean apply(@Nullable TypeStatus status) {
                return TYPE == status || !status.isTypeSpecimen();
            }
        }));
    }

    public boolean isTypeSpecimen() {
        return this != TYPE_GENUS && this != TYPE_SPECIES;
    }
}

