/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.vocabulary;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gbif.api.vocabulary.NomenclaturalCode;

public enum Rank {
    DOMAIN("dom."),
    SUPERKINGDOM("superreg."),
    KINGDOM("reg."),
    SUBKINGDOM("subreg."),
    INFRAKINGDOM("infrareg."),
    SUPERPHYLUM("superphyl."),
    PHYLUM("phyl."),
    SUBPHYLUM("subphyl."),
    INFRAPHYLUM("infraphyl."),
    SUPERCLASS("supercl."),
    CLASS("cl."),
    SUBCLASS("subcl."),
    INFRACLASS("infracl."),
    PARVCLASS("parvcl."),
    SUPERLEGION("superleg."),
    LEGION("leg."),
    SUBLEGION("subleg."),
    INFRALEGION("infraleg."),
    SUPERCOHORT("supercohort"),
    COHORT("cohort"),
    SUBCOHORT("subcohort"),
    INFRACOHORT("infracohort"),
    MAGNORDER("magnord."),
    SUPERORDER("superord."),
    GRANDORDER("grandord."),
    ORDER("ord."),
    SUBORDER("subord."),
    INFRAORDER("infraord."),
    PARVORDER("parvord."),
    SUPERFAMILY("superfam."),
    FAMILY("fam."),
    SUBFAMILY("subfam."),
    INFRAFAMILY("infrafam."),
    SUPERTRIBE("supertrib."),
    TRIBE("trib."),
    SUBTRIBE("subtrib."),
    INFRATRIBE("infratrib."),
    SUPRAGENERIC_NAME("supragen."),
    GENUS("gen."),
    SUBGENUS("subgen."),
    INFRAGENUS("infragen."),
    SECTION("sect."),
    SUBSECTION("subsect."),
    SERIES("ser."),
    SUBSERIES("subser."),
    INFRAGENERIC_NAME("infrageneric"),
    SPECIES_AGGREGATE("agg."),
    SPECIES("sp."),
    INFRASPECIFIC_NAME("infrasp."),
    GREX("grex"),
    SUBSPECIES("subsp."),
    CULTIVAR_GROUP,
    CONVARIETY("convar."),
    INFRASUBSPECIFIC_NAME("infrasubsp."),
    PROLES("prol."),
    RACE("race"),
    NATIO("natio"),
    ABERRATION("ab."),
    MORPH("morph"),
    VARIETY("var."),
    SUBVARIETY("subvar."),
    FORM("f."),
    SUBFORM("subf."),
    PATHOVAR("pv."),
    BIOVAR("biovar"),
    CHEMOVAR("chemovar"),
    MORPHOVAR("morphovar"),
    PHAGOVAR("phagovar"),
    SEROVAR("serovar"),
    CHEMOFORM("chemoform"),
    FORMA_SPECIALIS("f.sp."),
    CULTIVAR("cv."),
    STRAIN("strain"),
    OTHER,
    UNRANKED;

    public static final List<Rank> LINNEAN_RANKS;
    public static final List<Rank> DWC_RANKS;
    private static final Set<Rank> UNCOMPARABLE_RANKS;
    private static final Set<Rank> LEGACY_RANKS;
    private static final Map<Rank, NomenclaturalCode> RANK2CODE;
    private final String marker;

    private Rank() {
        this(null);
    }

    private Rank(String marker) {
        this.marker = marker;
    }

    public String getMarker() {
        return this.marker;
    }

    public boolean isInfraspecific() {
        return this != SPECIES && this.isSpeciesOrBelow();
    }

    public boolean isInfrasubspecific() {
        return this.ordinal() > SUBSPECIES.ordinal() && this.notOtherOrUnknown();
    }

    public boolean isInfrageneric() {
        return this.ordinal() > GENUS.ordinal() && this.notOtherOrUnknown();
    }

    public boolean isLinnean() {
        for (Rank r : LINNEAN_RANKS) {
            if (r != this) continue;
            return true;
        }
        return false;
    }

    public boolean isSpeciesOrBelow() {
        return this.ordinal() >= SPECIES.ordinal() && this.notOtherOrUnknown();
    }

    public boolean notOtherOrUnknown() {
        return this != OTHER && this != UNRANKED;
    }

    public boolean isSuprageneric() {
        return this.ordinal() < GENUS.ordinal();
    }

    public boolean isSupraspecific() {
        return this.ordinal() < SPECIES.ordinal();
    }

    public boolean isUncomparable() {
        return UNCOMPARABLE_RANKS.contains((Object)this);
    }

    public boolean isLegacy() {
        return LEGACY_RANKS.contains((Object)this);
    }

    public NomenclaturalCode isRestrictedToCode() {
        return RANK2CODE.get((Object)this);
    }

    public boolean higherThan(Rank other) {
        return this.ordinal() < other.ordinal();
    }

    static {
        LINNEAN_RANKS = ImmutableList.of(KINGDOM, PHYLUM, CLASS, ORDER, FAMILY, GENUS, SPECIES);
        DWC_RANKS = ImmutableList.of(KINGDOM, PHYLUM, CLASS, ORDER, FAMILY, GENUS, SUBGENUS, SPECIES);
        UNCOMPARABLE_RANKS = ImmutableSet.of(INFRAGENERIC_NAME, INFRASPECIFIC_NAME, INFRASUBSPECIFIC_NAME, OTHER, UNRANKED);
        LEGACY_RANKS = ImmutableSet.of(MORPH, ABERRATION, NATIO, RACE, PROLES, CONVARIETY, new Rank[0]);
        RANK2CODE = ImmutableMap.builder().put(PARVCLASS, NomenclaturalCode.ZOOLOGICAL).put(MAGNORDER, NomenclaturalCode.ZOOLOGICAL).put(GRANDORDER, NomenclaturalCode.ZOOLOGICAL).put(PARVORDER, NomenclaturalCode.ZOOLOGICAL).put(SUPERLEGION, NomenclaturalCode.ZOOLOGICAL).put(LEGION, NomenclaturalCode.ZOOLOGICAL).put(SUBLEGION, NomenclaturalCode.ZOOLOGICAL).put(INFRALEGION, NomenclaturalCode.ZOOLOGICAL).put(SUPERCOHORT, NomenclaturalCode.ZOOLOGICAL).put(COHORT, NomenclaturalCode.ZOOLOGICAL).put(SUBCOHORT, NomenclaturalCode.ZOOLOGICAL).put(INFRACOHORT, NomenclaturalCode.ZOOLOGICAL).put(MORPH, NomenclaturalCode.ZOOLOGICAL).put(ABERRATION, NomenclaturalCode.ZOOLOGICAL).put(NATIO, NomenclaturalCode.ZOOLOGICAL).put(RACE, NomenclaturalCode.BOTANICAL).put(PROLES, NomenclaturalCode.BOTANICAL).put(SECTION, NomenclaturalCode.BOTANICAL).put(SUBSECTION, NomenclaturalCode.BOTANICAL).put(SERIES, NomenclaturalCode.BOTANICAL).put(SUBSERIES, NomenclaturalCode.BOTANICAL).put(CULTIVAR, NomenclaturalCode.CULTIVARS).put(CULTIVAR_GROUP, NomenclaturalCode.CULTIVARS).put(CONVARIETY, NomenclaturalCode.CULTIVARS).put(GREX, NomenclaturalCode.CULTIVARS).put(PATHOVAR, NomenclaturalCode.BACTERIAL).put(BIOVAR, NomenclaturalCode.BACTERIAL).put(CHEMOVAR, NomenclaturalCode.BACTERIAL).put(MORPHOVAR, NomenclaturalCode.BACTERIAL).put(PHAGOVAR, NomenclaturalCode.BACTERIAL).put(SEROVAR, NomenclaturalCode.BACTERIAL).put(CHEMOFORM, NomenclaturalCode.BACTERIAL).put(FORMA_SPECIALIS, NomenclaturalCode.BACTERIAL).build();
    }
}

