/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.vocabulary;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import org.apache.commons.lang3.StringUtils;
import org.gbif.api.util.VocabularyUtils;

public enum License {
    CC0_1_0("Public Domain (CC0 1.0)", "http://creativecommons.org/publicdomain/zero/1.0/legalcode"),
    CC_BY_4_0("Creative Commons Attribution (CC-BY) 4.0", "http://creativecommons.org/licenses/by/4.0/legalcode"),
    CC_BY_NC_4_0("Creative Commons Attribution Non Commercial (CC-BY-NC) 4.0", "http://creativecommons.org/licenses/by-nc/4.0/legalcode"),
    UNSPECIFIED(null, null),
    UNSUPPORTED(null, null);

    private final String licenseTitle;
    private final String licenseUrl;

    public static Optional<License> fromString(String license) {
        return VocabularyUtils.lookup(license, License.class);
    }

    public static Optional<License> fromLicenseUrl(String licenseUrl) {
        if (!Strings.isNullOrEmpty(licenseUrl)) {
            licenseUrl = licenseUrl.trim().toLowerCase();
            licenseUrl = StringUtils.removeEnd((String)licenseUrl, (String)"/");
            for (License license : License.values()) {
                if (license.getLicenseUrl() == null || !licenseUrl.equals(license.getLicenseUrl()) && !license.getLicenseUrl().startsWith(licenseUrl)) continue;
                return Optional.fromNullable(license);
            }
        }
        return Optional.absent();
    }

    public static License getMostRestrictive(License license1, License license2, License fallback) {
        if (license1 == null || license2 == null || !license1.isConcrete() || !license2.isConcrete()) {
            return fallback;
        }
        return license1.compareTo(license2) > 0 ? license1 : license2;
    }

    private License(String licenseTitle, String licenseUrl) {
        this.licenseTitle = licenseTitle;
        this.licenseUrl = licenseUrl != null ? licenseUrl.toLowerCase() : null;
    }

    public String getLicenseUrl() {
        return this.licenseUrl;
    }

    public String getLicenseTitle() {
        return this.licenseTitle;
    }

    public boolean isConcrete() {
        return this.licenseUrl != null;
    }
}

