/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.vocabulary;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.SerializerProvider;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.codehaus.jackson.map.ser.std.SerializerBase;

@JsonSerialize(using=IsoSerializer.class)
@JsonDeserialize(using=LenientDeserializer.class)
public enum Language {
    ABKHAZIAN("ab"),
    AFAR("aa"),
    AFRIKAANS("af"),
    AKAN("ak"),
    ALBANIAN("sq"),
    AMHARIC("am"),
    ARABIC("ar"),
    ARAGONESE("an"),
    ARMENIAN("hy"),
    ASSAMESE("as"),
    AVARIC("av"),
    AVESTAN("ae"),
    AYMARA("ay"),
    AZERBAIJANI("az"),
    BAMBARA("bm"),
    BASHKIR("ba"),
    BASQUE("eu"),
    BELARUSIAN("be"),
    BENGALI("bn"),
    BIHARI("bh"),
    BISLAMA("bi"),
    BOSNIAN("bs"),
    BRETON("br"),
    BULGARIAN("bg"),
    BURMESE("my"),
    CATALAN("ca"),
    CHAMORRO("ch"),
    CHECHEN("ce"),
    CHINESE("zh"),
    CHURCH_SLAVIC("cu"),
    CHUVASH("cv"),
    CORNISH("kw"),
    CORSICAN("co"),
    CREE("cr"),
    CROATIAN("hr"),
    CZECH("cs"),
    DANISH("da"),
    DIVEHI("dv"),
    DUTCH("nl"),
    DZONGKHA("dz"),
    ENGLISH("en"),
    ESPERANTO("eo"),
    ESTONIAN("et"),
    EWE("ee"),
    FAROESE("fo"),
    FIJIAN("fj"),
    FINNISH("fi"),
    FRENCH("fr"),
    FRISIAN("fy"),
    FULAH("ff"),
    GALLEGAN("gl"),
    GANDA("lg"),
    GEORGIAN("ka"),
    GERMAN("de"),
    GREEK("el"),
    GREENLANDIC("kl"),
    GUARANI("gn"),
    GUJARATI("gu"),
    HAITIAN("ht"),
    HAUSA("ha"),
    HEBREW("he"),
    HERERO("hz"),
    HINDI("hi"),
    HIRI_MOTU("ho"),
    HUNGARIAN("hu"),
    ICELANDIC("is"),
    IDO("io"),
    IGBO("ig"),
    INDONESIAN("id"),
    INTERLINGUA("ia"),
    INTERLINGUE("ie"),
    INUKTITUT("iu"),
    INUPIAQ("ik"),
    IRISH("ga"),
    ITALIAN("it"),
    JAPANESE("ja"),
    JAVANESE("jv"),
    KANNADA("kn"),
    KANURI("kr"),
    KASHMIRI("ks"),
    KAZAKH("kk"),
    KHMER("km"),
    KIKUYU("ki"),
    KINYARWANDA("rw"),
    KIRGHIZ("ky"),
    KOMI("kv"),
    KONGO("kg"),
    KOREAN("ko"),
    KURDISH("ku"),
    KWANYAMA("kj"),
    LAO("lo"),
    LATIN("la"),
    LATVIAN("lv"),
    LIMBURGISH("li"),
    LINGALA("ln"),
    LITHUANIAN("lt"),
    LUBA_KATANGA("lu"),
    LUXEMBOURGISH("lb"),
    MACEDONIAN("mk"),
    MALAGASY("mg"),
    MALAY("ms"),
    MALAYALAM("ml"),
    MALTESE("mt"),
    MANX("gv"),
    MAORI("mi"),
    MARATHI("mr"),
    MARSHALLESE("mh"),
    MOLDAVIAN("mo"),
    MONGOLIAN("mn"),
    NAURU("na"),
    NAVAJO("nv"),
    NDONGA("ng"),
    NEPALI("ne"),
    NORTH_NDEBELE("nd"),
    NORTHERN_SAMI("se"),
    NORWEGIAN_BOKMAL("nb"),
    NORWEGIAN_NYNORSK("nn"),
    NORWEGIAN("no"),
    NYANJA("ny"),
    OCCITAN("oc"),
    OJIBWA("oj"),
    ORIYA("or"),
    OROMO("om"),
    OSSETIAN("os"),
    PALI("pi"),
    PANJABI("pa"),
    PERSIAN("fa"),
    POLISH("pl"),
    PORTUGUESE("pt"),
    PUSHTO("ps"),
    QUECHUA("qu"),
    RAETO_ROMANCE("rm"),
    ROMANIAN("ro"),
    RUNDI("rn"),
    RUSSIAN("ru"),
    SAMOAN("sm"),
    SANGO("sg"),
    SANSKRIT("sa"),
    SARDINIAN("sc"),
    SCOTTISH_GAELIC("gd"),
    SERBIAN("sr"),
    SHONA("sn"),
    SICHUAN_YI("ii"),
    SINDHI("sd"),
    SINHALESE("si"),
    SLOVAK("sk"),
    SLOVENIAN("sl"),
    SOMALI("so"),
    SOUTH_NDEBELE("nr"),
    SOUTHERN_SOTHO("st"),
    SPANISH("es"),
    SUNDANESE("su"),
    SWAHILI("sw"),
    SWATI("ss"),
    SWEDISH("sv"),
    TAGALOG("tl"),
    TAHITIAN("ty"),
    TAJIK("tg"),
    TAMIL("ta"),
    TATAR("tt"),
    TELUGU("te"),
    THAI("th"),
    TIBETAN("bo"),
    TIGRINYA("ti"),
    TONGA("to"),
    TSONGA("ts"),
    TSWANA("tn"),
    TURKISH("tr"),
    TURKMEN("tk"),
    TWI("tw"),
    UIGHUR("ug"),
    UKRAINIAN("uk"),
    URDU("ur"),
    UZBEK("uz"),
    VENDA("ve"),
    VIETNAMESE("vi"),
    VOLAP\u00dcK("vo"),
    WALLOON("wa"),
    WELSH("cy"),
    WOLOF("wo"),
    XHOSA("xh"),
    YIDDISH("yi"),
    YORUBA("yo"),
    ZHUANG("za"),
    ZULU("zu"),
    UNKNOWN("");

    public static final List<Language> LANGUAGES;
    private final String code;

    public static Language fromIsoCode(String code) {
        block2: {
            String codeLower;
            block3: {
                if (Strings.isNullOrEmpty(code)) break block2;
                codeLower = code.toLowerCase().trim();
                if (codeLower.length() != 2) break block3;
                for (Language language : Language.values()) {
                    if (!codeLower.equals(language.getIso2LetterCode())) continue;
                    return language;
                }
                break block2;
            }
            if (codeLower.length() != 3) break block2;
            for (Language language : Language.values()) {
                if (!codeLower.equals(language.getIso3LetterCode())) continue;
                return language;
            }
        }
        return UNKNOWN;
    }

    private Language(String code) {
        this.code = code;
    }

    public String getIso2LetterCode() {
        return this.code;
    }

    public String getIso3LetterCode() {
        return this.getLocale().getISO3Language();
    }

    public Locale getLocale() {
        return new Locale(this.code);
    }

    public String getTitleEnglish() {
        return this.getLocale().getDisplayLanguage(Locale.ENGLISH);
    }

    public String getTitleNative() {
        Locale loc = this.getLocale();
        return loc.getDisplayLanguage(loc);
    }

    static {
        LANGUAGES = ImmutableList.copyOf(Language.values());
    }

    public static class LenientDeserializer
    extends JsonDeserializer<Language> {
        public Language deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            try {
                if (jp != null && jp.getTextLength() > 0) {
                    return LenientDeserializer.lenientParse(jp.getText());
                }
                return UNKNOWN;
            }
            catch (Exception e) {
                throw new IOException("Unable to deserialize language from provided value (hint: not an ISO 2 or 3 character?): " + jp.getText());
            }
        }

        @VisibleForTesting
        static Language lenientParse(String value) {
            Language l = Language.fromIsoCode(value);
            if (UNKNOWN == l) {
                try {
                    l = Language.valueOf(value);
                }
                catch (IllegalArgumentException e) {
                    l = UNKNOWN;
                }
            }
            return l;
        }
    }

    public static class IsoSerializer
    extends SerializerBase<Language> {
        public IsoSerializer() {
            super(Language.class);
        }

        public void serialize(Language value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            jgen.writeString(value.getIso3LetterCode());
        }
    }
}

