/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.vocabulary;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import org.gbif.api.util.VocabularyUtils;

public enum IdentifierType {
    URL,
    LSID,
    HANDLER,
    DOI,
    UUID,
    FTP,
    URI,
    UNKNOWN,
    GBIF_PORTAL,
    GBIF_NODE,
    GBIF_PARTICIPANT;

    public static final List<IdentifierType> TYPES;

    public static IdentifierType fromString(String identifierType) {
        return VocabularyUtils.lookupEnum(identifierType, IdentifierType.class);
    }

    public static IdentifierType inferFrom(@Nullable String identifier) {
        String lcIdentifier = Strings.nullToEmpty(identifier).trim().toLowerCase();
        if (lcIdentifier.isEmpty()) {
            return UNKNOWN;
        }
        if (lcIdentifier.startsWith("doi:10") || lcIdentifier.startsWith("urn:doi:") || lcIdentifier.startsWith("http://dx.doi.org/10.")) {
            return DOI;
        }
        if (lcIdentifier.startsWith("http:") || lcIdentifier.startsWith("https:") || lcIdentifier.startsWith("www.")) {
            return URL;
        }
        if (lcIdentifier.startsWith("ftp:")) {
            return FTP;
        }
        if (lcIdentifier.startsWith("urn:lsid:") || lcIdentifier.startsWith("lsid:")) {
            return LSID;
        }
        if (lcIdentifier.startsWith("urn:uuid:") || lcIdentifier.startsWith("uuid:")) {
            return UUID;
        }
        try {
            java.util.UUID.fromString(lcIdentifier);
            return UUID;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return UNKNOWN;
        }
    }

    static {
        TYPES = ImmutableList.copyOf(IdentifierType.values());
    }
}

