/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.vocabulary;

import com.google.common.base.Strings;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.gbif.api.jackson.ExtensionDeserializer;
import org.gbif.api.jackson.ExtensionSerializer;

@JsonSerialize(using=ExtensionSerializer.class)
@JsonDeserialize(using=ExtensionDeserializer.class)
public enum Extension {
    AUDUBON("http://rs.tdwg.org/ac/terms/Multimedia"),
    DESCRIPTION("http://rs.gbif.org/terms/1.0/Description"),
    DISTRIBUTION("http://rs.gbif.org/terms/1.0/Distribution"),
    EOL_MEDIA("http://eol.org/schema/media/Document"),
    EOL_REFERENCE("http://eol.org/schema/reference/Reference"),
    GERMPLASM_ACCESSION("http://purl.org/germplasm/germplasmTerm#GermplasmAccession"),
    GERMPLASM_MEASUREMENT_SCORE("http://purl.org/germplasm/germplasmTerm#MeasurementScore"),
    GERMPLASM_MEASUREMENT_TRAIT("http://purl.org/germplasm/germplasmTerm#MeasurementTrait"),
    GERMPLASM_MEASUREMENT_TRIAL("http://purl.org/germplasm/germplasmTerm#MeasurementTrial"),
    IDENTIFICATION("http://rs.tdwg.org/dwc/terms/Identification"),
    IDENTIFIER("http://rs.gbif.org/terms/1.0/Identifier"),
    IMAGE("http://rs.gbif.org/terms/1.0/Image"),
    MEASUREMENT_OR_FACT("http://rs.tdwg.org/dwc/terms/MeasurementOrFact"),
    MULTIMEDIA("http://rs.gbif.org/terms/1.0/Multimedia"),
    REFERENCE("http://rs.gbif.org/terms/1.0/Reference"),
    RESOURCE_RELATIONSHIP("http://rs.tdwg.org/dwc/terms/ResourceRelationship"),
    SPECIES_PROFILE("http://rs.gbif.org/terms/1.0/SpeciesProfile"),
    TYPES_AND_SPECIMEN("http://rs.gbif.org/terms/1.0/TypesAndSpecimen"),
    VERNACULAR_NAME("http://rs.gbif.org/terms/1.0/VernacularName");

    private final String rowType;

    public static Extension fromRowType(String rowType) {
        if (!Strings.isNullOrEmpty(rowType)) {
            for (Extension extension : Extension.values()) {
                if (!rowType.equalsIgnoreCase(extension.getRowType()) && !rowType.equalsIgnoreCase(extension.name().replaceAll("_", ""))) continue;
                return extension;
            }
        }
        return null;
    }

    private Extension(String rowType) {
        this.rowType = rowType;
    }

    public String getRowType() {
        return this.rowType;
    }
}

