/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.vocabulary;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.SerializerProvider;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.codehaus.jackson.map.ser.std.SerializerBase;

@JsonSerialize(using=IsoSerializer.class)
@JsonDeserialize(using=IsoDeserializer.class)
public final class Country
extends Enum<Country> {
    public static final /* enum */ Country AFGHANISTAN;
    public static final /* enum */ Country ALAND_ISLANDS;
    public static final /* enum */ Country ALBANIA;
    public static final /* enum */ Country ALGERIA;
    public static final /* enum */ Country AMERICAN_SAMOA;
    public static final /* enum */ Country ANDORRA;
    public static final /* enum */ Country ANGOLA;
    public static final /* enum */ Country ANGUILLA;
    public static final /* enum */ Country ANTARCTICA;
    public static final /* enum */ Country ANTIGUA_BARBUDA;
    public static final /* enum */ Country ARGENTINA;
    public static final /* enum */ Country ARMENIA;
    public static final /* enum */ Country ARUBA;
    public static final /* enum */ Country AUSTRALIA;
    public static final /* enum */ Country AUSTRIA;
    public static final /* enum */ Country AZERBAIJAN;
    public static final /* enum */ Country BAHAMAS;
    public static final /* enum */ Country BAHRAIN;
    public static final /* enum */ Country BANGLADESH;
    public static final /* enum */ Country BARBADOS;
    public static final /* enum */ Country BELARUS;
    public static final /* enum */ Country BELGIUM;
    public static final /* enum */ Country BELIZE;
    public static final /* enum */ Country BENIN;
    public static final /* enum */ Country BERMUDA;
    public static final /* enum */ Country BHUTAN;
    public static final /* enum */ Country BOLIVIA;
    public static final /* enum */ Country BONAIRE_SINT_EUSTATIUS_SABA;
    public static final /* enum */ Country BOSNIA_HERZEGOVINA;
    public static final /* enum */ Country BOTSWANA;
    public static final /* enum */ Country BOUVET_ISLAND;
    public static final /* enum */ Country BRAZIL;
    public static final /* enum */ Country BRITISH_INDIAN_OCEAN_TERRITORY;
    public static final /* enum */ Country BRUNEI_DARUSSALAM;
    public static final /* enum */ Country BULGARIA;
    public static final /* enum */ Country BURKINA_FASO;
    public static final /* enum */ Country BURUNDI;
    public static final /* enum */ Country CAMBODIA;
    public static final /* enum */ Country CAMEROON;
    public static final /* enum */ Country CANADA;
    public static final /* enum */ Country CAPE_VERDE;
    public static final /* enum */ Country CAYMAN_ISLANDS;
    public static final /* enum */ Country CENTRAL_AFRICAN_REPUBLIC;
    public static final /* enum */ Country CHAD;
    public static final /* enum */ Country CHILE;
    public static final /* enum */ Country CHINA;
    public static final /* enum */ Country CHRISTMAS_ISLAND;
    public static final /* enum */ Country COCOS_ISLANDS;
    public static final /* enum */ Country COLOMBIA;
    public static final /* enum */ Country COMOROS;
    public static final /* enum */ Country CONGO_DEMOCRATIC_REPUBLIC;
    public static final /* enum */ Country CONGO;
    public static final /* enum */ Country COOK_ISLANDS;
    public static final /* enum */ Country COSTA_RICA;
    public static final /* enum */ Country C\u00d4TE_DIVOIRE;
    public static final /* enum */ Country CROATIA;
    public static final /* enum */ Country CUBA;
    public static final /* enum */ Country CURA\u00c7AO;
    public static final /* enum */ Country CYPRUS;
    public static final /* enum */ Country CZECH_REPUBLIC;
    public static final /* enum */ Country DENMARK;
    public static final /* enum */ Country DJIBOUTI;
    public static final /* enum */ Country DOMINICA;
    public static final /* enum */ Country DOMINICAN_REPUBLIC;
    public static final /* enum */ Country ECUADOR;
    public static final /* enum */ Country EGYPT;
    public static final /* enum */ Country EL_SALVADOR;
    public static final /* enum */ Country EQUATORIAL_GUINEA;
    public static final /* enum */ Country ERITREA;
    public static final /* enum */ Country ESTONIA;
    public static final /* enum */ Country ETHIOPIA;
    public static final /* enum */ Country FALKLAND_ISLANDS;
    public static final /* enum */ Country FAROE_ISLANDS;
    public static final /* enum */ Country FIJI;
    public static final /* enum */ Country FINLAND;
    public static final /* enum */ Country FRANCE;
    public static final /* enum */ Country FRENCH_GUIANA;
    public static final /* enum */ Country FRENCH_POLYNESIA;
    public static final /* enum */ Country FRENCH_SOUTHERN_TERRITORIES;
    public static final /* enum */ Country GABON;
    public static final /* enum */ Country GAMBIA;
    public static final /* enum */ Country GEORGIA;
    public static final /* enum */ Country GERMANY;
    public static final /* enum */ Country GHANA;
    public static final /* enum */ Country GIBRALTAR;
    public static final /* enum */ Country GREECE;
    public static final /* enum */ Country GREENLAND;
    public static final /* enum */ Country GRENADA;
    public static final /* enum */ Country GUADELOUPE;
    public static final /* enum */ Country GUAM;
    public static final /* enum */ Country GUATEMALA;
    public static final /* enum */ Country GUERNSEY;
    public static final /* enum */ Country GUINEA;
    public static final /* enum */ Country GUINEA_BISSAU;
    public static final /* enum */ Country GUYANA;
    public static final /* enum */ Country HAITI;
    public static final /* enum */ Country HEARD_MCDONALD_ISLANDS;
    public static final /* enum */ Country VATICAN;
    public static final /* enum */ Country HONDURAS;
    public static final /* enum */ Country HONG_KONG;
    public static final /* enum */ Country HUNGARY;
    public static final /* enum */ Country ICELAND;
    public static final /* enum */ Country INDIA;
    public static final /* enum */ Country INDONESIA;
    public static final /* enum */ Country IRAN;
    public static final /* enum */ Country IRAQ;
    public static final /* enum */ Country IRELAND;
    public static final /* enum */ Country ISLE_OF_MAN;
    public static final /* enum */ Country ISRAEL;
    public static final /* enum */ Country ITALY;
    public static final /* enum */ Country JAMAICA;
    public static final /* enum */ Country JAPAN;
    public static final /* enum */ Country JERSEY;
    public static final /* enum */ Country JORDAN;
    public static final /* enum */ Country KAZAKHSTAN;
    public static final /* enum */ Country KENYA;
    public static final /* enum */ Country KIRIBATI;
    public static final /* enum */ Country KOREA_NORTH;
    public static final /* enum */ Country KOREA_SOUTH;
    public static final /* enum */ Country KUWAIT;
    public static final /* enum */ Country KYRGYZSTAN;
    public static final /* enum */ Country LAO;
    public static final /* enum */ Country LATVIA;
    public static final /* enum */ Country LEBANON;
    public static final /* enum */ Country LESOTHO;
    public static final /* enum */ Country LIBERIA;
    public static final /* enum */ Country LIBYA;
    public static final /* enum */ Country LIECHTENSTEIN;
    public static final /* enum */ Country LITHUANIA;
    public static final /* enum */ Country LUXEMBOURG;
    public static final /* enum */ Country MACAO;
    public static final /* enum */ Country MACEDONIA;
    public static final /* enum */ Country MADAGASCAR;
    public static final /* enum */ Country MALAWI;
    public static final /* enum */ Country MALAYSIA;
    public static final /* enum */ Country MALDIVES;
    public static final /* enum */ Country MALI;
    public static final /* enum */ Country MALTA;
    public static final /* enum */ Country MARSHALL_ISLANDS;
    public static final /* enum */ Country MARTINIQUE;
    public static final /* enum */ Country MAURITANIA;
    public static final /* enum */ Country MAURITIUS;
    public static final /* enum */ Country MAYOTTE;
    public static final /* enum */ Country MEXICO;
    public static final /* enum */ Country MICRONESIA;
    public static final /* enum */ Country MOLDOVA;
    public static final /* enum */ Country MONACO;
    public static final /* enum */ Country MONGOLIA;
    public static final /* enum */ Country MONTENEGRO;
    public static final /* enum */ Country MONTSERRAT;
    public static final /* enum */ Country MOROCCO;
    public static final /* enum */ Country MOZAMBIQUE;
    public static final /* enum */ Country MYANMAR;
    public static final /* enum */ Country NAMIBIA;
    public static final /* enum */ Country NAURU;
    public static final /* enum */ Country NEPAL;
    public static final /* enum */ Country NETHERLANDS;
    public static final /* enum */ Country NEW_CALEDONIA;
    public static final /* enum */ Country NEW_ZEALAND;
    public static final /* enum */ Country NICARAGUA;
    public static final /* enum */ Country NIGER;
    public static final /* enum */ Country NIGERIA;
    public static final /* enum */ Country NIUE;
    public static final /* enum */ Country NORFOLK_ISLAND;
    public static final /* enum */ Country NORTHERN_MARIANA_ISLANDS;
    public static final /* enum */ Country NORWAY;
    public static final /* enum */ Country OMAN;
    public static final /* enum */ Country PAKISTAN;
    public static final /* enum */ Country PALAU;
    public static final /* enum */ Country PALESTINIAN_TERRITORY;
    public static final /* enum */ Country PANAMA;
    public static final /* enum */ Country PAPUA_NEW_GUINEA;
    public static final /* enum */ Country PARAGUAY;
    public static final /* enum */ Country PERU;
    public static final /* enum */ Country PHILIPPINES;
    public static final /* enum */ Country PITCAIRN;
    public static final /* enum */ Country POLAND;
    public static final /* enum */ Country PORTUGAL;
    public static final /* enum */ Country PUERTO_RICO;
    public static final /* enum */ Country QATAR;
    public static final /* enum */ Country R\u00c9UNION;
    public static final /* enum */ Country ROMANIA;
    public static final /* enum */ Country RUSSIAN_FEDERATION;
    public static final /* enum */ Country RWANDA;
    public static final /* enum */ Country SAINT_BARTH\u00c9LEMY;
    public static final /* enum */ Country SAINT_HELENA_ASCENSION_TRISTAN_DA_CUNHA;
    public static final /* enum */ Country SAINT_KITTS_NEVIS;
    public static final /* enum */ Country SAINT_LUCIA;
    public static final /* enum */ Country SAINT_MARTIN_FRENCH;
    public static final /* enum */ Country SAINT_PIERRE_MIQUELON;
    public static final /* enum */ Country SAINT_VINCENT_GRENADINES;
    public static final /* enum */ Country SAMOA;
    public static final /* enum */ Country SAN_MARINO;
    public static final /* enum */ Country SAO_TOME_PRINCIPE;
    public static final /* enum */ Country SAUDI_ARABIA;
    public static final /* enum */ Country SENEGAL;
    public static final /* enum */ Country SERBIA;
    public static final /* enum */ Country SEYCHELLES;
    public static final /* enum */ Country SIERRA_LEONE;
    public static final /* enum */ Country SINGAPORE;
    public static final /* enum */ Country SINT_MAARTEN;
    public static final /* enum */ Country SLOVAKIA;
    public static final /* enum */ Country SLOVENIA;
    public static final /* enum */ Country SOLOMON_ISLANDS;
    public static final /* enum */ Country SOMALIA;
    public static final /* enum */ Country SOUTH_AFRICA;
    public static final /* enum */ Country SOUTH_GEORGIA_SANDWICH_ISLANDS;
    public static final /* enum */ Country SOUTH_SUDAN;
    public static final /* enum */ Country SPAIN;
    public static final /* enum */ Country SRI_LANKA;
    public static final /* enum */ Country SUDAN;
    public static final /* enum */ Country SURINAME;
    public static final /* enum */ Country SVALBARD_JAN_MAYEN;
    public static final /* enum */ Country SWAZILAND;
    public static final /* enum */ Country SWEDEN;
    public static final /* enum */ Country SWITZERLAND;
    public static final /* enum */ Country SYRIA;
    public static final /* enum */ Country TAIWAN;
    public static final /* enum */ Country TAJIKISTAN;
    public static final /* enum */ Country TANZANIA;
    public static final /* enum */ Country THAILAND;
    public static final /* enum */ Country TIMOR_LESTE;
    public static final /* enum */ Country TOGO;
    public static final /* enum */ Country TOKELAU;
    public static final /* enum */ Country TONGA;
    public static final /* enum */ Country TRINIDAD_TOBAGO;
    public static final /* enum */ Country TUNISIA;
    public static final /* enum */ Country TURKEY;
    public static final /* enum */ Country TURKMENISTAN;
    public static final /* enum */ Country TURKS_CAICOS_ISLANDS;
    public static final /* enum */ Country TUVALU;
    public static final /* enum */ Country UGANDA;
    public static final /* enum */ Country UKRAINE;
    public static final /* enum */ Country UNITED_ARAB_EMIRATES;
    public static final /* enum */ Country UNITED_KINGDOM;
    public static final /* enum */ Country UNITED_STATES;
    public static final /* enum */ Country UNITED_STATES_OUTLYING_ISLANDS;
    public static final /* enum */ Country URUGUAY;
    public static final /* enum */ Country UZBEKISTAN;
    public static final /* enum */ Country VANUATU;
    public static final /* enum */ Country VENEZUELA;
    public static final /* enum */ Country VIETNAM;
    public static final /* enum */ Country VIRGIN_ISLANDS_BRITISH;
    public static final /* enum */ Country VIRGIN_ISLANDS;
    public static final /* enum */ Country WALLIS_FUTUNA;
    public static final /* enum */ Country WESTERN_SAHARA;
    public static final /* enum */ Country YEMEN;
    public static final /* enum */ Country ZAMBIA;
    public static final /* enum */ Country ZIMBABWE;
    public static final /* enum */ Country USER_DEFINED;
    public static final /* enum */ Country INTERNATIONAL_WATERS;
    public static final /* enum */ Country OCEANIA;
    public static final /* enum */ Country UNKNOWN;
    public static final Set<String> CUSTOM_CODES;
    public static final List<Country> OFFICIAL_COUNTRIES;
    private final String alpha2;
    private final String alpha3;
    private final int numericalCode;
    private final String title;
    private static final /* synthetic */ Country[] $VALUES;

    public static Country[] values() {
        return (Country[])$VALUES.clone();
    }

    public static Country valueOf(String name) {
        return Enum.valueOf(Country.class, name);
    }

    public static boolean isCustomCode(String code) {
        return code != null && CUSTOM_CODES.contains(code.toUpperCase());
    }

    public static Country fromIsoCode(String code) {
        if (!Strings.isNullOrEmpty(code)) {
            String codeUpper = code.toUpperCase().trim();
            for (Country c : Country.values()) {
                if (!codeUpper.equals(c.getIso2LetterCode()) && !codeUpper.equals(c.getIso3LetterCode())) continue;
                return c;
            }
        }
        return null;
    }

    private Country(String alpha2, String alpha3, int numericalCode, String title) {
        this.alpha2 = alpha2;
        this.alpha3 = alpha3;
        this.numericalCode = numericalCode;
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public String getIso2LetterCode() {
        return this.alpha2;
    }

    public String getIso3LetterCode() {
        return this.alpha3;
    }

    public Integer getIsoNumericalCode() {
        return this.numericalCode;
    }

    public boolean isOfficial() {
        return this != UNKNOWN && this != USER_DEFINED && this != INTERNATIONAL_WATERS && this != OCEANIA;
    }

    static {
        char c2;
        char c;
        AFGHANISTAN = new Country("AF", "AFG", 4, "Afghanistan");
        ALAND_ISLANDS = new Country("AX", "ALA", 248, "\u00c5land Islands");
        ALBANIA = new Country("AL", "ALB", 8, "Albania");
        ALGERIA = new Country("DZ", "DZA", 12, "Algeria");
        AMERICAN_SAMOA = new Country("AS", "ASM", 16, "American Samoa");
        ANDORRA = new Country("AD", "AND", 20, "Andorra");
        ANGOLA = new Country("AO", "AGO", 24, "Angola");
        ANGUILLA = new Country("AI", "AIA", 660, "Anguilla");
        ANTARCTICA = new Country("AQ", "ATA", 10, "Antarctica");
        ANTIGUA_BARBUDA = new Country("AG", "ATG", 28, "Antigua and Barbuda");
        ARGENTINA = new Country("AR", "ARG", 32, "Argentina");
        ARMENIA = new Country("AM", "ARM", 51, "Armenia");
        ARUBA = new Country("AW", "ABW", 533, "Aruba");
        AUSTRALIA = new Country("AU", "AUS", 36, "Australia");
        AUSTRIA = new Country("AT", "AUT", 40, "Austria");
        AZERBAIJAN = new Country("AZ", "AZE", 31, "Azerbaijan");
        BAHAMAS = new Country("BS", "BHS", 44, "Bahamas");
        BAHRAIN = new Country("BH", "BHR", 48, "Bahrain");
        BANGLADESH = new Country("BD", "BGD", 50, "Bangladesh");
        BARBADOS = new Country("BB", "BRB", 52, "Barbados");
        BELARUS = new Country("BY", "BLR", 112, "Belarus");
        BELGIUM = new Country("BE", "BEL", 56, "Belgium");
        BELIZE = new Country("BZ", "BLZ", 84, "Belize");
        BENIN = new Country("BJ", "BEN", 204, "Benin");
        BERMUDA = new Country("BM", "BMU", 60, "Bermuda");
        BHUTAN = new Country("BT", "BTN", 64, "Bhutan");
        BOLIVIA = new Country("BO", "BOL", 68, "Bolivia, Plurinational State of");
        BONAIRE_SINT_EUSTATIUS_SABA = new Country("BQ", "BES", 535, "Bonaire, Sint Eustatius and Saba");
        BOSNIA_HERZEGOVINA = new Country("BA", "BIH", 70, "Bosnia and Herzegovina");
        BOTSWANA = new Country("BW", "BWA", 72, "Botswana");
        BOUVET_ISLAND = new Country("BV", "BVT", 74, "Bouvet Island");
        BRAZIL = new Country("BR", "BRA", 76, "Brazil");
        BRITISH_INDIAN_OCEAN_TERRITORY = new Country("IO", "IOT", 86, "British Indian Ocean Territory");
        BRUNEI_DARUSSALAM = new Country("BN", "BRN", 96, "Brunei Darussalam");
        BULGARIA = new Country("BG", "BGR", 100, "Bulgaria");
        BURKINA_FASO = new Country("BF", "BFA", 854, "Burkina Faso");
        BURUNDI = new Country("BI", "BDI", 108, "Burundi");
        CAMBODIA = new Country("KH", "KHM", 116, "Cambodia");
        CAMEROON = new Country("CM", "CMR", 120, "Cameroon");
        CANADA = new Country("CA", "CAN", 124, "Canada");
        CAPE_VERDE = new Country("CV", "CPV", 132, "Cape Verde");
        CAYMAN_ISLANDS = new Country("KY", "CYM", 136, "Cayman Islands");
        CENTRAL_AFRICAN_REPUBLIC = new Country("CF", "CAF", 140, "Central African Republic");
        CHAD = new Country("TD", "TCD", 148, "Chad");
        CHILE = new Country("CL", "CHL", 152, "Chile");
        CHINA = new Country("CN", "CHN", 156, "China");
        CHRISTMAS_ISLAND = new Country("CX", "CXR", 162, "Christmas Island");
        COCOS_ISLANDS = new Country("CC", "CCK", 166, "Cocos (Keeling) Islands");
        COLOMBIA = new Country("CO", "COL", 170, "Colombia");
        COMOROS = new Country("KM", "COM", 174, "Comoros");
        CONGO_DEMOCRATIC_REPUBLIC = new Country("CD", "COD", 180, "Congo, Democratic Republic of the");
        CONGO = new Country("CG", "COG", 178, "Congo, Republic of the");
        COOK_ISLANDS = new Country("CK", "COK", 184, "Cook Islands");
        COSTA_RICA = new Country("CR", "CRI", 188, "Costa Rica");
        C\u00d4TE_DIVOIRE = new Country("CI", "CIV", 384, "C\u00f4te d'Ivoire");
        CROATIA = new Country("HR", "HRV", 191, "Croatia");
        CUBA = new Country("CU", "CUB", 192, "Cuba");
        CURA\u00c7AO = new Country("CW", "CUW", 531, "Cura\u00e7ao");
        CYPRUS = new Country("CY", "CYP", 196, "Cyprus");
        CZECH_REPUBLIC = new Country("CZ", "CZE", 203, "Czech Republic");
        DENMARK = new Country("DK", "DNK", 208, "Denmark");
        DJIBOUTI = new Country("DJ", "DJI", 262, "Djibouti");
        DOMINICA = new Country("DM", "DMA", 212, "Dominica");
        DOMINICAN_REPUBLIC = new Country("DO", "DOM", 214, "Dominican Republic");
        ECUADOR = new Country("EC", "ECU", 218, "Ecuador");
        EGYPT = new Country("EG", "EGY", 818, "Egypt");
        EL_SALVADOR = new Country("SV", "SLV", 222, "El Salvador");
        EQUATORIAL_GUINEA = new Country("GQ", "GNQ", 226, "Equatorial Guinea");
        ERITREA = new Country("ER", "ERI", 232, "Eritrea");
        ESTONIA = new Country("EE", "EST", 233, "Estonia");
        ETHIOPIA = new Country("ET", "ETH", 231, "Ethiopia");
        FALKLAND_ISLANDS = new Country("FK", "FLK", 238, "Falkland Islands (Malvinas)");
        FAROE_ISLANDS = new Country("FO", "FRO", 234, "Faroe Islands");
        FIJI = new Country("FJ", "FJI", 242, "Fiji");
        FINLAND = new Country("FI", "FIN", 246, "Finland");
        FRANCE = new Country("FR", "FRA", 250, "France");
        FRENCH_GUIANA = new Country("GF", "GUF", 254, "French Guiana");
        FRENCH_POLYNESIA = new Country("PF", "PYF", 258, "French Polynesia");
        FRENCH_SOUTHERN_TERRITORIES = new Country("TF", "ATF", 260, "French Southern Territories");
        GABON = new Country("GA", "GAB", 266, "Gabon");
        GAMBIA = new Country("GM", "GMB", 270, "Gambia");
        GEORGIA = new Country("GE", "GEO", 268, "Georgia");
        GERMANY = new Country("DE", "DEU", 276, "Germany");
        GHANA = new Country("GH", "GHA", 288, "Ghana");
        GIBRALTAR = new Country("GI", "GIB", 292, "Gibraltar");
        GREECE = new Country("GR", "GRC", 300, "Greece");
        GREENLAND = new Country("GL", "GRL", 304, "Greenland");
        GRENADA = new Country("GD", "GRD", 308, "Grenada");
        GUADELOUPE = new Country("GP", "GLP", 312, "Guadeloupe");
        GUAM = new Country("GU", "GUM", 316, "Guam");
        GUATEMALA = new Country("GT", "GTM", 320, "Guatemala");
        GUERNSEY = new Country("GG", "GGY", 831, "Guernsey");
        GUINEA = new Country("GN", "GIN", 324, "Guinea");
        GUINEA_BISSAU = new Country("GW", "GNB", 624, "Guinea-Bissau");
        GUYANA = new Country("GY", "GUY", 328, "Guyana");
        HAITI = new Country("HT", "HTI", 332, "Haiti");
        HEARD_MCDONALD_ISLANDS = new Country("HM", "HMD", 334, "Heard Island and McDonald Islands");
        VATICAN = new Country("VA", "VAT", 336, "Holy See (Vatican City State)");
        HONDURAS = new Country("HN", "HND", 340, "Honduras");
        HONG_KONG = new Country("HK", "HKG", 344, "Hong Kong");
        HUNGARY = new Country("HU", "HUN", 348, "Hungary");
        ICELAND = new Country("IS", "ISL", 352, "Iceland");
        INDIA = new Country("IN", "IND", 356, "India");
        INDONESIA = new Country("ID", "IDN", 360, "Indonesia");
        IRAN = new Country("IR", "IRN", 364, "Iran, Islamic Republic of");
        IRAQ = new Country("IQ", "IRQ", 368, "Iraq");
        IRELAND = new Country("IE", "IRL", 372, "Ireland");
        ISLE_OF_MAN = new Country("IM", "IMN", 833, "Isle of Man");
        ISRAEL = new Country("IL", "ISR", 376, "Israel");
        ITALY = new Country("IT", "ITA", 380, "Italy");
        JAMAICA = new Country("JM", "JAM", 388, "Jamaica");
        JAPAN = new Country("JP", "JPN", 392, "Japan");
        JERSEY = new Country("JE", "JEY", 832, "Jersey");
        JORDAN = new Country("JO", "JOR", 400, "Jordan");
        KAZAKHSTAN = new Country("KZ", "KAZ", 398, "Kazakhstan");
        KENYA = new Country("KE", "KEN", 404, "Kenya");
        KIRIBATI = new Country("KI", "KIR", 296, "Kiribati");
        KOREA_NORTH = new Country("KP", "PRK", 408, "Korea, Democratic People's Republic of");
        KOREA_SOUTH = new Country("KR", "KOR", 410, "Korea, Republic of");
        KUWAIT = new Country("KW", "KWT", 414, "Kuwait");
        KYRGYZSTAN = new Country("KG", "KGZ", 417, "Kyrgyzstan");
        LAO = new Country("LA", "LAO", 418, "Lao People's Democratic Republic");
        LATVIA = new Country("LV", "LVA", 428, "Latvia");
        LEBANON = new Country("LB", "LBN", 422, "Lebanon");
        LESOTHO = new Country("LS", "LSO", 426, "Lesotho");
        LIBERIA = new Country("LR", "LBR", 430, "Liberia");
        LIBYA = new Country("LY", "LBY", 434, "Libya");
        LIECHTENSTEIN = new Country("LI", "LIE", 438, "Liechtenstein");
        LITHUANIA = new Country("LT", "LTU", 440, "Lithuania");
        LUXEMBOURG = new Country("LU", "LUX", 442, "Luxembourg");
        MACAO = new Country("MO", "MAC", 446, "Macao");
        MACEDONIA = new Country("MK", "MKD", 807, "Macedonia, the former Yugoslav Republic of");
        MADAGASCAR = new Country("MG", "MDG", 450, "Madagascar");
        MALAWI = new Country("MW", "MWI", 454, "Malawi");
        MALAYSIA = new Country("MY", "MYS", 458, "Malaysia");
        MALDIVES = new Country("MV", "MDV", 462, "Maldives");
        MALI = new Country("ML", "MLI", 466, "Mali");
        MALTA = new Country("MT", "MLT", 470, "Malta");
        MARSHALL_ISLANDS = new Country("MH", "MHL", 584, "Marshall Islands");
        MARTINIQUE = new Country("MQ", "MTQ", 474, "Martinique");
        MAURITANIA = new Country("MR", "MRT", 478, "Mauritania");
        MAURITIUS = new Country("MU", "MUS", 480, "Mauritius");
        MAYOTTE = new Country("YT", "MYT", 175, "Mayotte");
        MEXICO = new Country("MX", "MEX", 484, "Mexico");
        MICRONESIA = new Country("FM", "FSM", 583, "Micronesia, Federated States of");
        MOLDOVA = new Country("MD", "MDA", 498, "Moldova, Republic of");
        MONACO = new Country("MC", "MCO", 492, "Monaco");
        MONGOLIA = new Country("MN", "MNG", 496, "Mongolia");
        MONTENEGRO = new Country("ME", "MNE", 499, "Montenegro");
        MONTSERRAT = new Country("MS", "MSR", 500, "Montserrat");
        MOROCCO = new Country("MA", "MAR", 504, "Morocco");
        MOZAMBIQUE = new Country("MZ", "MOZ", 508, "Mozambique");
        MYANMAR = new Country("MM", "MMR", 104, "Myanmar");
        NAMIBIA = new Country("NA", "NAM", 516, "Namibia");
        NAURU = new Country("NR", "NRU", 520, "Nauru");
        NEPAL = new Country("NP", "NPL", 524, "Nepal");
        NETHERLANDS = new Country("NL", "NLD", 528, "Netherlands");
        NEW_CALEDONIA = new Country("NC", "NCL", 540, "New Caledonia");
        NEW_ZEALAND = new Country("NZ", "NZL", 554, "New Zealand");
        NICARAGUA = new Country("NI", "NIC", 558, "Nicaragua");
        NIGER = new Country("NE", "NER", 562, "Niger");
        NIGERIA = new Country("NG", "NGA", 566, "Nigeria");
        NIUE = new Country("NU", "NIU", 570, "Niue");
        NORFOLK_ISLAND = new Country("NF", "NFK", 574, "Norfolk Island");
        NORTHERN_MARIANA_ISLANDS = new Country("MP", "MNP", 580, "Northern Mariana Islands");
        NORWAY = new Country("NO", "NOR", 578, "Norway");
        OMAN = new Country("OM", "OMN", 512, "Oman");
        PAKISTAN = new Country("PK", "PAK", 586, "Pakistan");
        PALAU = new Country("PW", "PLW", 585, "Palau");
        PALESTINIAN_TERRITORY = new Country("PS", "PSE", 275, "Palestine, State Of");
        PANAMA = new Country("PA", "PAN", 591, "Panama");
        PAPUA_NEW_GUINEA = new Country("PG", "PNG", 598, "Papua New Guinea");
        PARAGUAY = new Country("PY", "PRY", 600, "Paraguay");
        PERU = new Country("PE", "PER", 604, "Peru");
        PHILIPPINES = new Country("PH", "PHL", 608, "Philippines");
        PITCAIRN = new Country("PN", "PCN", 612, "Pitcairn");
        POLAND = new Country("PL", "POL", 616, "Poland");
        PORTUGAL = new Country("PT", "PRT", 620, "Portugal");
        PUERTO_RICO = new Country("PR", "PRI", 630, "Puerto Rico");
        QATAR = new Country("QA", "QAT", 634, "Qatar");
        R\u00c9UNION = new Country("RE", "REU", 638, "R\u00e9union");
        ROMANIA = new Country("RO", "ROU", 642, "Romania");
        RUSSIAN_FEDERATION = new Country("RU", "RUS", 643, "Russian Federation");
        RWANDA = new Country("RW", "RWA", 646, "Rwanda");
        SAINT_BARTH\u00c9LEMY = new Country("BL", "BLM", 652, "Saint Barth\u00e9lemy");
        SAINT_HELENA_ASCENSION_TRISTAN_DA_CUNHA = new Country("SH", "SHN", 654, "Saint Helena, Ascension and Tristan da Cunha");
        SAINT_KITTS_NEVIS = new Country("KN", "KNA", 659, "Saint Kitts and Nevis");
        SAINT_LUCIA = new Country("LC", "LCA", 662, "Saint Lucia");
        SAINT_MARTIN_FRENCH = new Country("MF", "MAF", 663, "Saint Martin (French part)");
        SAINT_PIERRE_MIQUELON = new Country("PM", "SPM", 666, "Saint Pierre and Miquelon");
        SAINT_VINCENT_GRENADINES = new Country("VC", "VCT", 670, "Saint Vincent and the Grenadines");
        SAMOA = new Country("WS", "WSM", 882, "Samoa");
        SAN_MARINO = new Country("SM", "SMR", 674, "San Marino");
        SAO_TOME_PRINCIPE = new Country("ST", "STP", 678, "Sao Tome and Principe");
        SAUDI_ARABIA = new Country("SA", "SAU", 682, "Saudi Arabia");
        SENEGAL = new Country("SN", "SEN", 686, "Senegal");
        SERBIA = new Country("RS", "SRB", 688, "Serbia");
        SEYCHELLES = new Country("SC", "SYC", 690, "Seychelles");
        SIERRA_LEONE = new Country("SL", "SLE", 694, "Sierra Leone");
        SINGAPORE = new Country("SG", "SGP", 702, "Singapore");
        SINT_MAARTEN = new Country("SX", "SXM", 534, "Sint Maarten (Dutch part)");
        SLOVAKIA = new Country("SK", "SVK", 703, "Slovakia");
        SLOVENIA = new Country("SI", "SVN", 705, "Slovenia");
        SOLOMON_ISLANDS = new Country("SB", "SLB", 90, "Solomon Islands");
        SOMALIA = new Country("SO", "SOM", 706, "Somalia");
        SOUTH_AFRICA = new Country("ZA", "ZAF", 710, "South Africa");
        SOUTH_GEORGIA_SANDWICH_ISLANDS = new Country("GS", "SGS", 239, "South Georgia and the South Sandwich Islands");
        SOUTH_SUDAN = new Country("SS", "SSD", 728, "South Sudan");
        SPAIN = new Country("ES", "ESP", 724, "Spain");
        SRI_LANKA = new Country("LK", "LKA", 144, "Sri Lanka");
        SUDAN = new Country("SD", "SDN", 729, "Sudan");
        SURINAME = new Country("SR", "SUR", 740, "Suriname");
        SVALBARD_JAN_MAYEN = new Country("SJ", "SJM", 744, "Svalbard and Jan Mayen");
        SWAZILAND = new Country("SZ", "SWZ", 748, "Swaziland");
        SWEDEN = new Country("SE", "SWE", 752, "Sweden");
        SWITZERLAND = new Country("CH", "CHE", 756, "Switzerland");
        SYRIA = new Country("SY", "SYR", 760, "Syrian Arab Republic");
        TAIWAN = new Country("TW", "TWN", 158, "Chinese Taipei");
        TAJIKISTAN = new Country("TJ", "TJK", 762, "Tajikistan");
        TANZANIA = new Country("TZ", "TZA", 834, "Tanzania, United Republic of");
        THAILAND = new Country("TH", "THA", 764, "Thailand");
        TIMOR_LESTE = new Country("TL", "TLS", 626, "Timor-Leste");
        TOGO = new Country("TG", "TGO", 768, "Togo");
        TOKELAU = new Country("TK", "TKL", 772, "Tokelau");
        TONGA = new Country("TO", "TON", 776, "Tonga");
        TRINIDAD_TOBAGO = new Country("TT", "TTO", 780, "Trinidad and Tobago");
        TUNISIA = new Country("TN", "TUN", 788, "Tunisia");
        TURKEY = new Country("TR", "TUR", 792, "Turkey");
        TURKMENISTAN = new Country("TM", "TKM", 795, "Turkmenistan");
        TURKS_CAICOS_ISLANDS = new Country("TC", "TCA", 796, "Turks and Caicos Islands");
        TUVALU = new Country("TV", "TUV", 798, "Tuvalu");
        UGANDA = new Country("UG", "UGA", 800, "Uganda");
        UKRAINE = new Country("UA", "UKR", 804, "Ukraine");
        UNITED_ARAB_EMIRATES = new Country("AE", "ARE", 784, "United Arab Emirates");
        UNITED_KINGDOM = new Country("GB", "GBR", 826, "United Kingdom");
        UNITED_STATES = new Country("US", "USA", 840, "United States");
        UNITED_STATES_OUTLYING_ISLANDS = new Country("UM", "UMI", 581, "United States Minor Outlying Islands");
        URUGUAY = new Country("UY", "URY", 858, "Uruguay");
        UZBEKISTAN = new Country("UZ", "UZB", 860, "Uzbekistan");
        VANUATU = new Country("VU", "VUT", 548, "Vanuatu");
        VENEZUELA = new Country("VE", "VEN", 862, "Venezuela, Bolivarian Republic of");
        VIETNAM = new Country("VN", "VNM", 704, "Viet Nam");
        VIRGIN_ISLANDS_BRITISH = new Country("VG", "VGB", 92, "Virgin Islands, British");
        VIRGIN_ISLANDS = new Country("VI", "VIR", 850, "Virgin Islands, U.S.");
        WALLIS_FUTUNA = new Country("WF", "WLF", 876, "Wallis and Futuna");
        WESTERN_SAHARA = new Country("EH", "ESH", 732, "Western Sahara");
        YEMEN = new Country("YE", "YEM", 887, "Yemen");
        ZAMBIA = new Country("ZM", "ZMB", 894, "Zambia");
        ZIMBABWE = new Country("ZW", "ZWE", 716, "Zimbabwe");
        USER_DEFINED = new Country("AA", "AAA", 900, "user defined");
        INTERNATIONAL_WATERS = new Country("XZ", "XZZ", 901, "international waters");
        OCEANIA = new Country("QO", "QOO", 902, "Oceania");
        UNKNOWN = new Country("ZZ", "ZZZ", 999, "unknown or invalid");
        $VALUES = new Country[]{AFGHANISTAN, ALAND_ISLANDS, ALBANIA, ALGERIA, AMERICAN_SAMOA, ANDORRA, ANGOLA, ANGUILLA, ANTARCTICA, ANTIGUA_BARBUDA, ARGENTINA, ARMENIA, ARUBA, AUSTRALIA, AUSTRIA, AZERBAIJAN, BAHAMAS, BAHRAIN, BANGLADESH, BARBADOS, BELARUS, BELGIUM, BELIZE, BENIN, BERMUDA, BHUTAN, BOLIVIA, BONAIRE_SINT_EUSTATIUS_SABA, BOSNIA_HERZEGOVINA, BOTSWANA, BOUVET_ISLAND, BRAZIL, BRITISH_INDIAN_OCEAN_TERRITORY, BRUNEI_DARUSSALAM, BULGARIA, BURKINA_FASO, BURUNDI, CAMBODIA, CAMEROON, CANADA, CAPE_VERDE, CAYMAN_ISLANDS, CENTRAL_AFRICAN_REPUBLIC, CHAD, CHILE, CHINA, CHRISTMAS_ISLAND, COCOS_ISLANDS, COLOMBIA, COMOROS, CONGO_DEMOCRATIC_REPUBLIC, CONGO, COOK_ISLANDS, COSTA_RICA, C\u00d4TE_DIVOIRE, CROATIA, CUBA, CURA\u00c7AO, CYPRUS, CZECH_REPUBLIC, DENMARK, DJIBOUTI, DOMINICA, DOMINICAN_REPUBLIC, ECUADOR, EGYPT, EL_SALVADOR, EQUATORIAL_GUINEA, ERITREA, ESTONIA, ETHIOPIA, FALKLAND_ISLANDS, FAROE_ISLANDS, FIJI, FINLAND, FRANCE, FRENCH_GUIANA, FRENCH_POLYNESIA, FRENCH_SOUTHERN_TERRITORIES, GABON, GAMBIA, GEORGIA, GERMANY, GHANA, GIBRALTAR, GREECE, GREENLAND, GRENADA, GUADELOUPE, GUAM, GUATEMALA, GUERNSEY, GUINEA, GUINEA_BISSAU, GUYANA, HAITI, HEARD_MCDONALD_ISLANDS, VATICAN, HONDURAS, HONG_KONG, HUNGARY, ICELAND, INDIA, INDONESIA, IRAN, IRAQ, IRELAND, ISLE_OF_MAN, ISRAEL, ITALY, JAMAICA, JAPAN, JERSEY, JORDAN, KAZAKHSTAN, KENYA, KIRIBATI, KOREA_NORTH, KOREA_SOUTH, KUWAIT, KYRGYZSTAN, LAO, LATVIA, LEBANON, LESOTHO, LIBERIA, LIBYA, LIECHTENSTEIN, LITHUANIA, LUXEMBOURG, MACAO, MACEDONIA, MADAGASCAR, MALAWI, MALAYSIA, MALDIVES, MALI, MALTA, MARSHALL_ISLANDS, MARTINIQUE, MAURITANIA, MAURITIUS, MAYOTTE, MEXICO, MICRONESIA, MOLDOVA, MONACO, MONGOLIA, MONTENEGRO, MONTSERRAT, MOROCCO, MOZAMBIQUE, MYANMAR, NAMIBIA, NAURU, NEPAL, NETHERLANDS, NEW_CALEDONIA, NEW_ZEALAND, NICARAGUA, NIGER, NIGERIA, NIUE, NORFOLK_ISLAND, NORTHERN_MARIANA_ISLANDS, NORWAY, OMAN, PAKISTAN, PALAU, PALESTINIAN_TERRITORY, PANAMA, PAPUA_NEW_GUINEA, PARAGUAY, PERU, PHILIPPINES, PITCAIRN, POLAND, PORTUGAL, PUERTO_RICO, QATAR, R\u00c9UNION, ROMANIA, RUSSIAN_FEDERATION, RWANDA, SAINT_BARTH\u00c9LEMY, SAINT_HELENA_ASCENSION_TRISTAN_DA_CUNHA, SAINT_KITTS_NEVIS, SAINT_LUCIA, SAINT_MARTIN_FRENCH, SAINT_PIERRE_MIQUELON, SAINT_VINCENT_GRENADINES, SAMOA, SAN_MARINO, SAO_TOME_PRINCIPE, SAUDI_ARABIA, SENEGAL, SERBIA, SEYCHELLES, SIERRA_LEONE, SINGAPORE, SINT_MAARTEN, SLOVAKIA, SLOVENIA, SOLOMON_ISLANDS, SOMALIA, SOUTH_AFRICA, SOUTH_GEORGIA_SANDWICH_ISLANDS, SOUTH_SUDAN, SPAIN, SRI_LANKA, SUDAN, SURINAME, SVALBARD_JAN_MAYEN, SWAZILAND, SWEDEN, SWITZERLAND, SYRIA, TAIWAN, TAJIKISTAN, TANZANIA, THAILAND, TIMOR_LESTE, TOGO, TOKELAU, TONGA, TRINIDAD_TOBAGO, TUNISIA, TURKEY, TURKMENISTAN, TURKS_CAICOS_ISLANDS, TUVALU, UGANDA, UKRAINE, UNITED_ARAB_EMIRATES, UNITED_KINGDOM, UNITED_STATES, UNITED_STATES_OUTLYING_ISLANDS, URUGUAY, UZBEKISTAN, VANUATU, VENEZUELA, VIETNAM, VIRGIN_ISLANDS_BRITISH, VIRGIN_ISLANDS, WALLIS_FUTUNA, WESTERN_SAHARA, YEMEN, ZAMBIA, ZIMBABWE, USER_DEFINED, INTERNATIONAL_WATERS, OCEANIA, UNKNOWN};
        ArrayList<Country> officials = Lists.newArrayList();
        for (Country c3 : Country.values()) {
            if (!c3.isOfficial()) continue;
            officials.add(c3);
        }
        OFFICIAL_COUNTRIES = ImmutableList.copyOf(officials);
        HashSet<String> custom = Sets.newHashSet("AA", "ZZ");
        for (c = 'M'; c <= 'Z'; c = (char)(c + '\u0001')) {
            custom.add("Q" + c);
        }
        for (c = 'A'; c <= 'Z'; c = (char)(c + '\u0001')) {
            custom.add("AA" + c);
            custom.add("ZZ" + c);
        }
        for (c = 'M'; c <= 'Z'; c = (char)(c + '\u0001')) {
            for (c2 = 'A'; c2 <= 'Z'; c2 = (char)((char)(c2 + 1))) {
                custom.add("Q" + c + c2);
            }
        }
        for (c = 'A'; c <= 'Z'; c = (char)(c + '\u0001')) {
            custom.add("X" + c);
            for (c2 = 'A'; c2 <= 'Z'; c2 = (char)(c2 + '\u0001')) {
                custom.add("X" + c + c2);
            }
        }
        CUSTOM_CODES = ImmutableSet.copyOf(custom);
    }

    public static class TitleDeserializer
    extends JsonDeserializer<Country> {
        private static Map<String, Country> TITLE_LOOKUP = Maps.uniqueIndex(Lists.newArrayList(Country.values()), new Function<Country, String>(){

            @Override
            @Nullable
            public String apply(@Nullable Country c) {
                return c.title;
            }
        });

        public Country deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            try {
                return TITLE_LOOKUP.get(jp.getText());
            }
            catch (Exception e) {
                throw new IOException("Unable to deserialize country from provided title : " + jp.getText());
            }
        }
    }

    public static class TitleSerializer
    extends SerializerBase<Country> {
        public TitleSerializer() {
            super(Country.class);
        }

        public void serialize(Country value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeString(value.title);
        }
    }

    public static class IsoDeserializer
    extends JsonDeserializer<Country> {
        public Country deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            try {
                if (jp != null && jp.getTextLength() > 0) {
                    return Country.fromIsoCode(jp.getText());
                }
                return UNKNOWN;
            }
            catch (Exception e) {
                throw new IOException("Unable to deserialize country from provided value (not an ISO 2 character?): " + jp.getText());
            }
        }
    }

    public static class IsoSerializer
    extends SerializerBase<Country> {
        public IsoSerializer() {
            super(Country.class);
        }

        public void serialize(Country value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            jgen.writeString(value.alpha2);
        }
    }
}

