/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.vocabulary;

import com.google.common.collect.ImmutableMap;
import javax.annotation.Nullable;
import org.gbif.api.util.VocabularyUtils;

public enum ContactType {
    TECHNICAL_POINT_OF_CONTACT,
    ADMINISTRATIVE_POINT_OF_CONTACT,
    POINT_OF_CONTACT,
    ORIGINATOR,
    METADATA_AUTHOR,
    PRINCIPAL_INVESTIGATOR,
    AUTHOR,
    CONTENT_PROVIDER,
    CUSTODIAN_STEWARD,
    DISTRIBUTOR,
    EDITOR,
    OWNER,
    PROCESSOR,
    PUBLISHER,
    USER,
    PROGRAMMER,
    CURATOR,
    DATA_ADMINISTRATOR,
    SYSTEM_ADMINISTRATOR,
    HEAD_OF_DELEGATION,
    TEMPORARY_HEAD_OF_DELEGATION,
    ADDITIONAL_DELEGATE,
    TEMPORARY_DELEGATE,
    REGIONAL_NODE_REPRESENTATIVE,
    NODE_MANAGER,
    NODE_STAFF;

    private static final ImmutableMap<String, ContactType> TYPE_LOOKUP;

    public static ContactType fromString(String contactType) {
        return VocabularyUtils.lookupEnum(contactType, ContactType.class);
    }

    public static ContactType inferType(@Nullable String type) {
        if (type != null) {
            ContactType contactType = TYPE_LOOKUP.get(type.toLowerCase());
            if (contactType != null) {
                return contactType;
            }
            return ContactType.fromString(type);
        }
        return null;
    }

    static {
        TYPE_LOOKUP = ImmutableMap.builder().put("administrative", ADMINISTRATIVE_POINT_OF_CONTACT).put("technical", TECHNICAL_POINT_OF_CONTACT).put("pointofcontact", POINT_OF_CONTACT).put("originator", ORIGINATOR).put("metadataprovider", METADATA_AUTHOR).put("principleinvestigator", PRINCIPAL_INVESTIGATOR).put("author", AUTHOR).put("contentprovider", CONTENT_PROVIDER).put("custodiansteward", CUSTODIAN_STEWARD).put("distributor", DISTRIBUTOR).put("editor", EDITOR).put("owner", OWNER).put("processor", PROCESSOR).put("publisher", PUBLISHER).put("user", USER).put("programmer", PROGRAMMER).put("curator", CURATOR).put("data administrator", DATA_ADMINISTRATOR).put("system adminsitrator", SYSTEM_ADMINISTRATOR).put("system administrator", SYSTEM_ADMINISTRATOR).build();
    }
}

