/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.util.iterables;

import javax.annotation.Nullable;
import org.gbif.api.model.common.paging.PagingRequest;
import org.gbif.api.model.common.paging.PagingResponse;
import org.gbif.api.model.registry.Organization;
import org.gbif.api.service.registry.OrganizationService;
import org.gbif.api.util.iterables.EntityPager;
import org.gbif.api.vocabulary.Country;

public class OrganizationPager
extends EntityPager<Organization> {
    private final OrganizationService service;
    @Nullable
    private final Country country;

    public OrganizationPager(OrganizationService service, @Nullable Country country, int pageSize) {
        super(pageSize);
        this.service = service;
        this.country = country;
    }

    @Override
    PagingResponse<Organization> nextPage(PagingRequest page) {
        if (this.country != null) {
            return this.service.listByCountry(this.country, page);
        }
        return this.service.list(page);
    }
}

