/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.util;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.gbif.api.model.registry.MachineTag;
import org.gbif.api.model.registry.MachineTaggable;
import org.gbif.api.vocabulary.TagName;

public class MachineTagUtils {
    private MachineTagUtils() {
    }

    public static <T extends MachineTaggable> List<T> filter(List<T> source, final @Nullable String namespace, final @Nullable String name, final @Nullable String value) {
        return Lists.newArrayList(Iterables.filter(source, new Predicate<T>(){

            @Override
            public boolean apply(@Nullable T e) {
                for (MachineTag t : e.getMachineTags()) {
                    if (namespace != null && !t.getNamespace().equals(namespace) || name != null && !t.getName().equals(name) || value != null && !t.getValue().equals(value)) continue;
                    return true;
                }
                return false;
            }
        }));
    }

    public static Integer tagValueAsInteger(MachineTag tag) {
        if (tag != null) {
            try {
                return Integer.parseInt(tag.getValue());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Double tagValueAsDouble(MachineTag tag) {
        if (tag != null) {
            try {
                return Double.parseDouble(tag.getValue());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public static MachineTag firstTag(MachineTaggable taggable, TagName tagName) {
        return MachineTagUtils.firstTag(taggable, tagName.getNamespace().getNamespace(), tagName.getName());
    }

    public static MachineTag firstTag(MachineTaggable taggable, String namespace, String tagName) {
        for (MachineTag mt : taggable.getMachineTags()) {
            if (!mt.getNamespace().equals(namespace) || !mt.getName().equals(tagName)) continue;
            return mt;
        }
        return null;
    }

    public static List<MachineTag> list(MachineTaggable taggable, TagName tagName) {
        return MachineTagUtils.list(taggable, tagName.getNamespace().getNamespace(), tagName.getName());
    }

    public static List<MachineTag> list(MachineTaggable taggable, String namespace, String tagName) {
        ArrayList<MachineTag> tags = Lists.newArrayList();
        for (MachineTag mt : taggable.getMachineTags()) {
            if (!mt.getNamespace().equals(namespace) || !mt.getName().equals(tagName)) continue;
            tags.add(mt);
        }
        return tags;
    }

    public static List<MachineTag> listByPrefix(MachineTaggable taggable, String namespace, String prefix) {
        ArrayList<MachineTag> tags = Lists.newArrayList();
        for (MachineTag mt : taggable.getMachineTags()) {
            if (!mt.getNamespace().equals(namespace) || !mt.getName().startsWith(prefix)) continue;
            tags.add(mt);
        }
        return tags;
    }
}

