/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.UUID;

public class DatasetKey {
    private static final int UUID_LENGTH = 36;
    private static final int EXTERNAL_KEY_DATASET_ID_START_INDEX = 37;
    private static final char DELIMITER = ':';
    private final UUID registryKey;
    private final String datasetId;

    public static DatasetKey fromString(String key) {
        Preconditions.checkNotNull(key);
        if (key.length() == 36) {
            return new DatasetKey(UUID.fromString(key));
        }
        if (key.length() > 37 && ':' == key.charAt(36)) {
            return new DatasetKey(UUID.fromString(key.substring(0, 36)), key.substring(37));
        }
        throw new IllegalArgumentException("Invalid dataset key " + key);
    }

    public DatasetKey(UUID datasetKey) {
        this.registryKey = Preconditions.checkNotNull(datasetKey);
        this.datasetId = null;
    }

    public DatasetKey(UUID networkKey, String datasetId) {
        this.registryKey = Preconditions.checkNotNull(networkKey);
        this.datasetId = datasetId.trim();
        if (Strings.isNullOrEmpty(this.datasetId)) {
            throw new IllegalArgumentException("datasetId has to have non whitespace characters");
        }
    }

    public UUID getRegistryKey() {
        return this.registryKey;
    }

    public String getDatasetId() {
        return this.datasetId;
    }

    public boolean isExternalKey() {
        return this.datasetId != null;
    }

    public String toDatasetKey() {
        if (this.isExternalKey()) {
            return this.registryKey.toString() + ':' + this.datasetId;
        }
        return this.registryKey.toString();
    }
}

