/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.model.registry.eml.temporal;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import org.gbif.api.model.registry.eml.temporal.TemporalCoverage;
import org.gbif.api.util.formatter.TemporalCoverageFormatterVisitor;

public class DateRange
extends TemporalCoverage
implements Serializable {
    private static final long serialVersionUID = -1482059589547915674L;
    private Date start;
    private Date end;

    public DateRange() {
    }

    public DateRange(Date start, Date end) {
        Preconditions.checkArgument(start.before(end), "start date must be before end");
        this.start = start;
        this.end = end;
    }

    public Date getEnd() {
        return this.end;
    }

    public void setEnd(Date end) {
        this.end = end;
    }

    public Date getStart() {
        return this.start;
    }

    public void setStart(Date start) {
        this.start = start;
    }

    @Override
    public Collection<String> toKeywords() {
        StringBuilder sb = new StringBuilder();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        if (this.start != null) {
            sb.append(sdf.format(this.start));
        }
        if (this.end != null) {
            if (sb.length() > 0) {
                sb.append("-");
            }
            sb.append(sdf.format(this.end));
        }
        return Lists.newArrayList(sb.toString());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DateRange)) {
            return false;
        }
        DateRange that = (DateRange)obj;
        return Objects.equal(this.start, that.start) && Objects.equal(this.end, that.end);
    }

    public int hashCode() {
        return Objects.hashCode(super.hashCode(), this.start, this.end);
    }

    public String toString() {
        return Objects.toStringHelper(this).add("super", super.toString()).add("start", this.start).add("end", this.end).toString();
    }

    @Override
    public String acceptFormatter(TemporalCoverageFormatterVisitor formatter) {
        return formatter.format(this);
    }
}

