/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.model.registry;

import com.google.common.base.Objects;
import java.util.Date;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import javax.validation.constraints.Size;
import org.gbif.api.model.registry.LenientEquals;
import org.gbif.api.model.registry.PostPersist;
import org.gbif.api.model.registry.PrePersist;

public class Tag
implements LenientEquals<Tag> {
    private Integer key;
    private String value;
    private String createdBy;
    private Date created;

    public Tag() {
    }

    public Tag(String value) {
        this.value = value;
    }

    public Tag(String value, String createdBy) {
        this.value = value;
        this.createdBy = createdBy;
    }

    @Null(groups={PrePersist.class})
    @NotNull(groups={PostPersist.class})
    @Min(value=1L)
    public Integer getKey() {
        return this.key;
    }

    public void setKey(Integer key) {
        this.key = key;
    }

    @NotNull
    @Size(min=1)
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Size(min=3)
    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    @Null(groups={PrePersist.class})
    @NotNull(groups={PostPersist.class})
    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public int hashCode() {
        return Objects.hashCode(this.key, this.value, this.createdBy, this.created);
    }

    public boolean equals(Object object) {
        if (object instanceof Tag) {
            Tag that = (Tag)object;
            return Objects.equal(this.key, that.key) && Objects.equal(this.value, that.value) && Objects.equal(this.createdBy, that.createdBy) && Objects.equal(this.created, that.created);
        }
        return false;
    }

    public String toString() {
        return Objects.toStringHelper(this).add("key", this.key).add("value", this.value).add("createdBy", this.createdBy).add("created", this.created).toString();
    }

    @Override
    public boolean lenientEquals(Tag other) {
        if (this == other) {
            return true;
        }
        return Objects.equal(this.value, other.value);
    }
}

