/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.model.registry;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.net.URI;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.gbif.api.model.registry.Address;
import org.gbif.api.model.registry.Comment;
import org.gbif.api.model.registry.Commentable;
import org.gbif.api.model.registry.Contact;
import org.gbif.api.model.registry.Contactable;
import org.gbif.api.model.registry.Endpoint;
import org.gbif.api.model.registry.Endpointable;
import org.gbif.api.model.registry.Identifiable;
import org.gbif.api.model.registry.Identifier;
import org.gbif.api.model.registry.LenientEquals;
import org.gbif.api.model.registry.MachineTag;
import org.gbif.api.model.registry.MachineTaggable;
import org.gbif.api.model.registry.NetworkEntity;
import org.gbif.api.model.registry.Tag;
import org.gbif.api.model.registry.Taggable;
import org.gbif.api.util.HttpURI;
import org.gbif.api.vocabulary.Country;
import org.gbif.api.vocabulary.Language;

public class Network
implements NetworkEntity,
Contactable,
Endpointable,
MachineTaggable,
Taggable,
Commentable,
Identifiable,
LenientEquals<Network>,
Address {
    private UUID key;
    private String title;
    private String description;
    private Language language;
    private int numConstituents;
    private List<String> email;
    private List<String> phone;
    private List<URI> homepage;
    private URI logoUrl;
    private List<String> address;
    private String city;
    private String province;
    private Country country;
    private String postalCode;
    private String createdBy;
    private String modifiedBy;
    private Date created;
    private Date modified;
    private Date deleted;
    private List<Contact> contacts = Lists.newArrayList();
    private List<Endpoint> endpoints = Lists.newArrayList();
    private List<MachineTag> machineTags = Lists.newArrayList();
    private List<Tag> tags = Lists.newArrayList();
    private List<Identifier> identifiers = Lists.newArrayList();
    private List<Comment> comments = Lists.newArrayList();

    @Override
    public UUID getKey() {
        return this.key;
    }

    @Override
    public void setKey(UUID key) {
        this.key = key;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public Date getCreated() {
        return this.created;
    }

    @Override
    public void setCreated(Date created) {
        this.created = created;
    }

    @Override
    public Date getModified() {
        return this.modified;
    }

    @Override
    public void setModified(Date modified) {
        this.modified = modified;
    }

    @Override
    public Date getDeleted() {
        return this.deleted;
    }

    @Override
    public void setDeleted(Date deleted) {
        this.deleted = deleted;
    }

    @NotNull
    public Language getLanguage() {
        return this.language;
    }

    public void setLanguage(Language language) {
        this.language = language;
    }

    @Override
    @Nullable
    public List<String> getEmail() {
        return this.email;
    }

    @Override
    public void setEmail(List<String> email) {
        this.email = email;
    }

    @Override
    @Nullable
    public List<String> getPhone() {
        return this.phone;
    }

    @Override
    public void setPhone(List<String> phone) {
        this.phone = phone;
    }

    @Override
    @Nullable
    public List<URI> getHomepage() {
        return this.homepage;
    }

    @Override
    public void setHomepage(List<URI> homepage) {
        this.homepage = homepage;
    }

    @HttpURI
    @Nullable
    public URI getLogoUrl() {
        return this.logoUrl;
    }

    public void setLogoUrl(URI logoUrl) {
        this.logoUrl = logoUrl;
    }

    @Override
    @Nullable
    public List<String> getAddress() {
        return this.address;
    }

    @Override
    public void setAddress(List<String> address) {
        this.address = address;
    }

    @Override
    @Nullable
    @Size(min=1)
    public String getCity() {
        return this.city;
    }

    @Override
    public void setCity(String city) {
        this.city = city;
    }

    @Override
    @Nullable
    @Size(min=1)
    public String getProvince() {
        return this.province;
    }

    @Override
    public void setProvince(String province) {
        this.province = province;
    }

    @Override
    @Nullable
    public Country getCountry() {
        return this.country;
    }

    @Override
    public void setCountry(Country country) {
        this.country = country;
    }

    @Override
    @Nullable
    @Size(min=1)
    public String getPostalCode() {
        return this.postalCode;
    }

    @Override
    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    @Override
    public String getCreatedBy() {
        return this.createdBy;
    }

    @Override
    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    @Override
    public String getModifiedBy() {
        return this.modifiedBy;
    }

    @Override
    public void setModifiedBy(String modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    @Override
    public List<Contact> getContacts() {
        return this.contacts;
    }

    @Override
    public void setContacts(List<Contact> contacts) {
        this.contacts = contacts;
    }

    @Override
    public List<Endpoint> getEndpoints() {
        return this.endpoints;
    }

    @Override
    public void setEndpoints(List<Endpoint> endpoints) {
        this.endpoints = endpoints;
    }

    @Override
    public void addEndpoint(Endpoint endpoint) {
        this.endpoints.add(endpoint);
    }

    @Override
    public List<MachineTag> getMachineTags() {
        return this.machineTags;
    }

    @Override
    public void setMachineTags(List<MachineTag> machineTags) {
        this.machineTags = machineTags;
    }

    @Override
    public void addMachineTag(MachineTag machineTag) {
        this.machineTags.add(machineTag);
    }

    @Override
    public List<Tag> getTags() {
        return this.tags;
    }

    @Override
    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        return this.identifiers;
    }

    @Override
    public void setIdentifiers(List<Identifier> identifiers) {
        this.identifiers = identifiers;
    }

    @Override
    public List<Comment> getComments() {
        return this.comments;
    }

    @Override
    public void setComments(List<Comment> comments) {
        this.comments = comments;
    }

    @Min(value=0L)
    public int getNumConstituents() {
        return this.numConstituents;
    }

    public void setNumConstituents(int numConstituents) {
        this.numConstituents = numConstituents;
    }

    @Override
    @Nullable
    @JsonIgnore
    public String getOrganization() {
        return this.getTitle();
    }

    @Override
    public void setOrganization(String organization) {
        this.setTitle(organization);
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.key, this.title, this.description, this.language, this.email, this.phone, this.homepage, this.logoUrl, this.address, this.city, this.province, this.country, this.postalCode, this.createdBy, this.modifiedBy, this.created, this.modified, this.deleted, this.contacts, this.endpoints, this.machineTags, this.tags, this.identifiers, this.comments, this.numConstituents});
    }

    public boolean equals(Object object) {
        if (object instanceof Network) {
            Network that = (Network)object;
            return Objects.equal(this.key, that.key) && Objects.equal(this.title, that.title) && Objects.equal(this.description, that.description) && Objects.equal((Object)this.language, (Object)that.language) && Objects.equal(this.email, that.email) && Objects.equal(this.phone, that.phone) && Objects.equal(this.homepage, that.homepage) && Objects.equal(this.logoUrl, that.logoUrl) && Objects.equal(this.address, that.address) && Objects.equal(this.city, that.city) && Objects.equal(this.province, that.province) && Objects.equal((Object)this.country, (Object)that.country) && Objects.equal(this.postalCode, that.postalCode) && Objects.equal(this.createdBy, that.createdBy) && Objects.equal(this.modifiedBy, that.modifiedBy) && Objects.equal(this.created, that.created) && Objects.equal(this.modified, that.modified) && Objects.equal(this.deleted, that.deleted) && Objects.equal(this.contacts, that.contacts) && Objects.equal(this.endpoints, that.endpoints) && Objects.equal(this.machineTags, that.machineTags) && Objects.equal(this.tags, that.tags) && Objects.equal(this.identifiers, that.identifiers) && Objects.equal(this.comments, that.comments) && Objects.equal(this.numConstituents, that.numConstituents);
        }
        return false;
    }

    public String toString() {
        return Objects.toStringHelper(this).add("key", this.key).add("title", this.title).add("description", this.description).add("language", (Object)this.language).add("email", this.email).add("phone", this.phone).add("homepage", this.homepage).add("logoUrl", this.logoUrl).add("address", this.address).add("city", this.city).add("province", this.province).add("country", (Object)this.country).add("postalCode", this.postalCode).add("createdBy", this.createdBy).add("modifiedBy", this.modifiedBy).add("created", this.created).add("modified", this.modified).add("deleted", this.deleted).add("contacts", this.contacts).add("endpoints", this.endpoints).add("machineTags", this.machineTags).add("tags", this.tags).add("identifiers", this.identifiers).add("comments", this.comments).add("numConstituents", this.numConstituents).toString();
    }

    @Override
    public boolean lenientEquals(Network other) {
        if (this == other) {
            return true;
        }
        return Objects.equal(this.title, other.title) && Objects.equal(this.description, other.description) && Objects.equal((Object)this.language, (Object)other.language) && Objects.equal(this.email, other.email) && Objects.equal(this.phone, other.phone) && Objects.equal(this.homepage, other.homepage) && Objects.equal(this.logoUrl, other.logoUrl) && Objects.equal(this.address, other.address) && Objects.equal(this.city, other.city) && Objects.equal(this.province, other.province) && Objects.equal((Object)this.country, (Object)other.country) && Objects.equal(this.postalCode, other.postalCode);
    }
}

