/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.model.registry;

import com.google.common.base.Objects;
import java.util.Date;
import java.util.UUID;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.gbif.api.model.registry.LenientEquals;
import org.gbif.api.vocabulary.MetadataType;

public class Metadata
implements LenientEquals<Metadata> {
    private Integer key;
    private UUID datasetKey;
    private MetadataType type;
    private String content;
    private String createdBy;
    private String modifiedBy;
    private Date created;
    private Date modified;

    @Min(value=1L)
    public Integer getKey() {
        return this.key;
    }

    public void setKey(Integer key) {
        this.key = key;
    }

    @NotNull
    public UUID getDatasetKey() {
        return this.datasetKey;
    }

    public void setDatasetKey(UUID datasetKey) {
        this.datasetKey = datasetKey;
    }

    @NotNull
    public MetadataType getType() {
        return this.type;
    }

    public void setType(MetadataType type) {
        this.type = type;
    }

    @NotNull
    @Size(min=1)
    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    @NotNull
    @Size(min=3)
    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    @NotNull
    @Size(min=3)
    public String getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(String modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    @NotNull
    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    @NotNull
    public Date getModified() {
        return this.modified;
    }

    public void setModified(Date modified) {
        this.modified = modified;
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.key, this.datasetKey, this.type, this.content, this.createdBy, this.modifiedBy, this.created, this.modified});
    }

    public boolean equals(Object object) {
        if (object instanceof Metadata) {
            Metadata that = (Metadata)object;
            return Objects.equal(this.key, that.key) && Objects.equal(this.datasetKey, that.datasetKey) && Objects.equal((Object)this.type, (Object)that.type) && Objects.equal(this.content, that.content) && Objects.equal(this.createdBy, that.createdBy) && Objects.equal(this.modifiedBy, that.modifiedBy) && Objects.equal(this.created, that.created) && Objects.equal(this.modified, that.modified);
        }
        return false;
    }

    public String toString() {
        return Objects.toStringHelper(this).add("key", this.key).add("datasetKey", this.datasetKey).add("type", (Object)this.type).add("content", this.content).add("createdBy", this.createdBy).add("modifiedBy", this.modifiedBy).add("created", this.created).add("modified", this.modified).toString();
    }

    @Override
    public boolean lenientEquals(Metadata other) {
        if (this == other) {
            return true;
        }
        return Objects.equal(this.datasetKey, other.datasetKey) && Objects.equal((Object)this.type, (Object)other.type) && Objects.equal(this.content, other.content);
    }
}

