/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.model.registry;

import com.google.common.base.Objects;
import java.util.Date;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import javax.validation.constraints.Size;
import org.gbif.api.model.registry.LenientEquals;
import org.gbif.api.model.registry.PostPersist;
import org.gbif.api.model.registry.PrePersist;

public class MachineTag
implements LenientEquals<MachineTag> {
    private Integer key;
    private String namespace;
    private String name;
    private String value;
    private String createdBy;
    private Date created;

    public static MachineTag newInstance(String namespace, String name, String value) {
        return new MachineTag(namespace, name, value);
    }

    public MachineTag() {
    }

    public MachineTag(String namespace, String name, String value) {
        this.namespace = namespace;
        this.name = name;
        this.value = value;
    }

    @Null(groups={PrePersist.class})
    @NotNull(groups={PostPersist.class})
    public Integer getKey() {
        return this.key;
    }

    public void setKey(Integer key) {
        this.key = key;
    }

    @NotNull
    @Size(min=1, max=255)
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @NotNull
    @Size(min=1, max=255)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @NotNull
    @Size(min=1, max=255)
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Size(min=3)
    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    @Null(groups={PrePersist.class})
    @NotNull(groups={PostPersist.class})
    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public int hashCode() {
        return Objects.hashCode(this.key, this.namespace, this.name, this.value, this.createdBy, this.created);
    }

    public boolean equals(Object object) {
        if (object instanceof MachineTag) {
            MachineTag that = (MachineTag)object;
            return Objects.equal(this.key, that.key) && Objects.equal(this.namespace, that.namespace) && Objects.equal(this.name, that.name) && Objects.equal(this.value, that.value) && Objects.equal(this.createdBy, that.createdBy) && Objects.equal(this.created, that.created);
        }
        return false;
    }

    public String toString() {
        return Objects.toStringHelper(this).add("key", this.key).add("namespace", this.namespace).add("name", this.name).add("value", this.value).add("createdBy", this.createdBy).add("created", this.created).toString();
    }

    @Override
    public boolean lenientEquals(MachineTag other) {
        if (this == other) {
            return true;
        }
        return Objects.equal(this.namespace, other.namespace) && Objects.equal(this.name, other.name) && Objects.equal(this.value, other.value);
    }
}

