/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.model.registry;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.gbif.api.model.registry.Comment;
import org.gbif.api.model.registry.Commentable;
import org.gbif.api.model.registry.Contact;
import org.gbif.api.model.registry.Contactable;
import org.gbif.api.model.registry.Endpoint;
import org.gbif.api.model.registry.Endpointable;
import org.gbif.api.model.registry.Identifiable;
import org.gbif.api.model.registry.Identifier;
import org.gbif.api.model.registry.LenientEquals;
import org.gbif.api.model.registry.MachineTag;
import org.gbif.api.model.registry.MachineTaggable;
import org.gbif.api.model.registry.NetworkEntity;
import org.gbif.api.model.registry.PostPersist;
import org.gbif.api.model.registry.PrePersist;
import org.gbif.api.model.registry.Tag;
import org.gbif.api.model.registry.Taggable;
import org.gbif.api.vocabulary.InstallationType;

public class Installation
implements NetworkEntity,
Contactable,
Endpointable,
MachineTaggable,
Taggable,
Commentable,
Identifiable,
LenientEquals<Installation> {
    private UUID key;
    private UUID organizationKey;
    private String password;
    private InstallationType type;
    private String title;
    private String description;
    private String createdBy;
    private String modifiedBy;
    private Date created;
    private Date modified;
    private Date deleted;
    private boolean disabled;
    private List<Contact> contacts = Lists.newArrayList();
    private List<Endpoint> endpoints = Lists.newArrayList();
    private List<MachineTag> machineTags = Lists.newArrayList();
    private List<Tag> tags = Lists.newArrayList();
    private List<Identifier> identifiers = Lists.newArrayList();
    private List<Comment> comments = Lists.newArrayList();

    @Override
    @Null(groups={PrePersist.class})
    @NotNull(groups={PostPersist.class})
    public UUID getKey() {
        return this.key;
    }

    @Override
    public void setKey(UUID key) {
        this.key = key;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    @Null(groups={PrePersist.class})
    @NotNull(groups={PostPersist.class})
    public Date getCreated() {
        return this.created;
    }

    @Override
    public void setCreated(Date created) {
        this.created = created;
    }

    @Override
    @Null(groups={PrePersist.class})
    @NotNull(groups={PostPersist.class})
    public Date getModified() {
        return this.modified;
    }

    @Override
    public void setModified(Date modified) {
        this.modified = modified;
    }

    @Override
    public Date getDeleted() {
        return this.deleted;
    }

    @Override
    public void setDeleted(Date deleted) {
        this.deleted = deleted;
    }

    @NotNull
    public UUID getOrganizationKey() {
        return this.organizationKey;
    }

    public void setOrganizationKey(UUID organizationKey) {
        this.organizationKey = organizationKey;
    }

    @JsonIgnore
    @Nullable
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @NotNull
    public InstallationType getType() {
        return this.type;
    }

    public void setType(InstallationType type) {
        this.type = type;
    }

    @Override
    public String getCreatedBy() {
        return this.createdBy;
    }

    @Override
    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    @Override
    public String getModifiedBy() {
        return this.modifiedBy;
    }

    @Override
    public void setModifiedBy(String modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    @Override
    public List<Contact> getContacts() {
        return this.contacts;
    }

    @Override
    public void setContacts(List<Contact> contacts) {
        this.contacts = contacts;
    }

    @Override
    public List<Endpoint> getEndpoints() {
        return this.endpoints;
    }

    @Override
    public void setEndpoints(List<Endpoint> endpoints) {
        this.endpoints = endpoints;
    }

    @Override
    public void addEndpoint(Endpoint endpoint) {
        this.endpoints.add(endpoint);
    }

    @Override
    public List<MachineTag> getMachineTags() {
        return this.machineTags;
    }

    @Override
    public void setMachineTags(List<MachineTag> machineTags) {
        this.machineTags = machineTags;
    }

    @Override
    public void addMachineTag(MachineTag machineTag) {
        this.machineTags.add(machineTag);
    }

    @Override
    public List<Tag> getTags() {
        return this.tags;
    }

    @Override
    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        return this.identifiers;
    }

    @Override
    public void setIdentifiers(List<Identifier> identifiers) {
        this.identifiers = identifiers;
    }

    @Override
    public List<Comment> getComments() {
        return this.comments;
    }

    @Override
    public void setComments(List<Comment> comments) {
        this.comments = comments;
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.key, this.organizationKey, this.password, this.type, this.title, this.description, this.createdBy, this.modifiedBy, this.created, this.modified, this.deleted, this.disabled, this.contacts, this.endpoints, this.machineTags, this.tags, this.identifiers, this.comments});
    }

    public boolean equals(Object object) {
        if (object instanceof Installation) {
            Installation that = (Installation)object;
            return Objects.equal(this.key, that.key) && Objects.equal(this.organizationKey, that.organizationKey) && Objects.equal(this.password, that.password) && Objects.equal((Object)this.type, (Object)that.type) && Objects.equal(this.title, that.title) && Objects.equal(this.description, that.description) && Objects.equal(this.createdBy, that.createdBy) && Objects.equal(this.modifiedBy, that.modifiedBy) && Objects.equal(this.created, that.created) && Objects.equal(this.modified, that.modified) && Objects.equal(this.deleted, that.deleted) && Objects.equal(this.disabled, that.disabled) && Objects.equal(this.contacts, that.contacts) && Objects.equal(this.endpoints, that.endpoints) && Objects.equal(this.machineTags, that.machineTags) && Objects.equal(this.tags, that.tags) && Objects.equal(this.identifiers, that.identifiers) && Objects.equal(this.comments, that.comments);
        }
        return false;
    }

    public String toString() {
        return Objects.toStringHelper(this).add("key", this.key).add("organizationKey", this.organizationKey).add("password", this.password).add("type", (Object)this.type).add("title", this.title).add("description", this.description).add("createdBy", this.createdBy).add("modifiedBy", this.modifiedBy).add("created", this.created).add("modified", this.modified).add("deleted", this.deleted).add("disabled", this.disabled).add("contacts", this.contacts).add("endpoints", this.endpoints).add("machineTags", this.machineTags).add("tags", this.tags).add("identifiers", this.identifiers).add("comments", this.comments).toString();
    }

    @Override
    public boolean lenientEquals(Installation other) {
        if (this == other) {
            return true;
        }
        return Objects.equal(this.organizationKey, other.organizationKey) && Objects.equal((Object)this.type, (Object)other.type) && Objects.equal(this.title, other.title) && Objects.equal(this.description, other.description);
    }
}

