/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.model.registry;

import com.google.common.base.Objects;
import java.util.Date;
import javax.annotation.Nullable;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import javax.validation.constraints.Size;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.gbif.api.model.registry.LenientEquals;
import org.gbif.api.model.registry.PostPersist;
import org.gbif.api.model.registry.PrePersist;
import org.gbif.api.util.IdentifierUtils;
import org.gbif.api.vocabulary.IdentifierType;

public class Identifier
implements LenientEquals<Identifier> {
    private Integer key;
    private IdentifierType type;
    private String identifier;
    private String createdBy;
    private Date created;

    public Identifier() {
    }

    public Identifier(IdentifierType type, String identifier) {
        this.type = type;
        this.identifier = identifier;
    }

    @Null(groups={PrePersist.class})
    @NotNull(groups={PostPersist.class})
    @Min(value=1L)
    public Integer getKey() {
        return this.key;
    }

    public void setKey(Integer key) {
        this.key = key;
    }

    @NotNull
    public IdentifierType getType() {
        return this.type;
    }

    public void setType(IdentifierType type) {
        this.type = type;
    }

    @NotNull
    @Size(min=1)
    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @Size(min=3)
    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    @Null(groups={PrePersist.class})
    @NotNull(groups={PostPersist.class})
    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    @Nullable
    @JsonIgnore
    public String getIdentifierLink() {
        return IdentifierUtils.getIdentifierLink(this.identifier, this.type);
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.key, this.type, this.identifier, this.createdBy, this.created});
    }

    public boolean equals(Object object) {
        if (object instanceof Identifier) {
            Identifier that = (Identifier)object;
            return Objects.equal(this.key, that.key) && Objects.equal((Object)this.type, (Object)that.type) && Objects.equal(this.identifier, that.identifier) && Objects.equal(this.createdBy, that.createdBy) && Objects.equal(this.created, that.created);
        }
        return false;
    }

    public String toString() {
        return Objects.toStringHelper(this).add("key", this.key).add("type", (Object)this.type).add("identifier", this.identifier).add("createdBy", this.createdBy).add("created", this.created).toString();
    }

    @Override
    public boolean lenientEquals(Identifier other) {
        if (this == other) {
            return true;
        }
        return Objects.equal((Object)this.type, (Object)other.type) && Objects.equal(this.identifier, other.identifier);
    }
}

