/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.model.occurrence.predicate;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import javax.validation.constraints.NotNull;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;
import org.gbif.api.model.occurrence.predicate.Predicate;
import org.gbif.api.model.occurrence.search.OccurrenceSearchParameter;
import org.gbif.api.util.SearchTypeValidator;

public class WithinPredicate
implements Predicate {
    @NotNull
    private final String geometry;

    @JsonCreator
    public WithinPredicate(@JsonProperty(value="geometry") String geometry) {
        Preconditions.checkNotNull(geometry, "<geometry> may not be null");
        SearchTypeValidator.validate(OccurrenceSearchParameter.GEOMETRY, geometry);
        this.geometry = geometry;
    }

    public String getGeometry() {
        return this.geometry;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof WithinPredicate)) {
            return false;
        }
        WithinPredicate that = (WithinPredicate)obj;
        return Objects.equal(this.geometry, that.geometry);
    }

    public int hashCode() {
        return Objects.hashCode(this.geometry);
    }

    public String toString() {
        return Objects.toStringHelper(this).add("geometry", this.geometry).toString();
    }
}

